/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import net.minecraft.client.render.tessellator.Tessellator;

public abstract class TessellatorBase
extends Tessellator {
    @Override
    public void addVertexWithUV(double x, double y, double z, double u, double v) {
        this.setTextureUV(u, v);
        this.addVertex(x, y, z);
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        this.checkIsDrawing();
        this.addVertex(x, y, 0.0);
        this.addVertex(x, y + height, 0.0);
        this.addVertex(x + width, y + height, 0.0);
        this.addVertex(x + width, y, 0.0);
    }

    @Override
    public void drawRectangleWithUV(int x, int y, int width, int height, double u, double v, double uvWidth, double uvHeight) {
        this.checkIsDrawing();
        this.addVertexWithUV(x, y, 0.0, u, v);
        this.addVertexWithUV(x, y + height, 0.0, u, v + uvHeight);
        this.addVertexWithUV(x + width, y + height, 0.0, u + uvWidth, v + uvHeight);
        this.addVertexWithUV(x + width, y, 0.0, u + uvWidth, v);
    }

    @Override
    public void setColorOpaque(int r, int g, int b) {
        this.setColorRGBA(r, g, b, 255);
    }

    @Override
    public void setColorOpaque_F(float r, float g, float b) {
        this.setColorOpaque((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    @Override
    public void setColorOpaque_I(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        this.setColorOpaque(r, g, b);
    }

    @Override
    public void setColorRGBA_F(float r, float g, float b, float a) {
        this.setColorRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    @Override
    public void setColorRGBA_I(int rgb, int a) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        this.setColorRGBA(r, g, b, a);
    }

    @Override
    public void startDrawingQuads() {
        this.startDrawing(7);
    }

    public abstract void checkIsDrawing();
}

