/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.debug;

import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenGLLoggerCallback
implements GLDebugMessageCallbackI {
    private static final Logger LOGGER = LoggerFactory.getLogger("OpenGL");
    private final Int2BooleanMap didReport = new Int2BooleanOpenHashMap();

    @Override
    public void invoke(int source, int type, int id, int severity, int length, long message, long userParam) {
        if (type == 33357) {
            if (this.didReport.getOrDefault(id, false)) {
                return;
            }
            this.didReport.put(id, true);
            LOGGER.warn("Disabling repeated logging of next error, due to known hyper frequency");
        }
        String msg = MemoryUtil.memASCII(message, length);
        switch (severity) {
            case 37190: {
                LOGGER.error("High Severity error from '{}' Type='{}' ErrorCode[{}]:", this.getSourceName(source), this.getTypeName(type), this.getIdName(id), new RuntimeException(msg));
                break;
            }
            case 37191: {
                LOGGER.warn("Medium Severity error from '{}' Type='{}' ErrorCode[{}]:", this.getSourceName(source), this.getTypeName(type), this.getIdName(id), new RuntimeException(msg));
                break;
            }
            case 37192: {
                LOGGER.warn("Low Severity issue from '{}' Type='{}' ErrorCode[{}]:", this.getSourceName(source), this.getTypeName(type), this.getIdName(id), new RuntimeException(msg));
                break;
            }
            default: {
                LOGGER.debug("Notification from '{}' Type='{}' ErrorCode[{}]\t'{}'", this.getSourceName(source), this.getTypeName(type), this.getIdName(id), msg);
            }
        }
    }

    @NotNull
    public String getIdName(int error) {
        switch (error) {
            case 1280: {
                return "Invalid Enum";
            }
            case 1281: {
                return "Invalid Value";
            }
            case 1282: {
                return "Invalid Operation";
            }
            case 1283: {
                return "Stack Overflow";
            }
            case 1284: {
                return "Stack Underflow";
            }
            case 1285: {
                return "Out of Memory";
            }
            case 1286: {
                return "Invalid Framebuffer Operation";
            }
        }
        return "Unknown 0x" + Integer.toHexString(error);
    }

    @NotNull
    public String getSourceName(int source) {
        switch (source) {
            case 33350: {
                return "OpenGL API";
            }
            case 33351: {
                return "Window System API";
            }
            case 33352: {
                return "Shader Compiler";
            }
            case 33353: {
                return "Third Party";
            }
            case 33354: {
                return "Application";
            }
            case 33355: {
                return "Other";
            }
        }
        return "Other 0x" + Integer.toHexString(source);
    }

    @NotNull
    public String getTypeName(int type) {
        switch (type) {
            case 33356: {
                return "Error";
            }
            case 33357: {
                return "Deprecated Behavior";
            }
            case 33358: {
                return "Undefined Behavior";
            }
            case 33359: {
                return "Not Portable";
            }
            case 33360: {
                return "Performance";
            }
            case 33384: {
                return "Marker";
            }
            case 33385: {
                return "Group Push";
            }
            case 33386: {
                return "Group Pop";
            }
            case 33361: {
                return "Other";
            }
        }
        return "Other 0x" + Integer.toHexString(type);
    }
}

