/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFarmland;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;

public class BlockLogicCropsPumpkin
extends BlockLogicFlower
implements IBonemealable {
    public BlockLogicCropsPumpkin(Block<?> block) {
        super(block);
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        float onePix = 0.0625f;
        float size = 0.0f;
        if (meta == 0) {
            size = 6.0f * onePix;
        } else if (meta == 1) {
            size = 8.0f * onePix;
        } else if (meta == 2) {
            size = 10.0f * onePix;
        } else if (meta == 3) {
            size = 12.0f * onePix;
        } else if (meta == 4) {
            size = 14.0f * onePix;
        }
        return AABB.fromPool(0.5f - size / 2.0f, 0.0, 0.5f - size / 2.0f, 0.5f + size / 2.0f, size, 0.5f + size / 2.0f);
    }

    @Override
    protected boolean mayPlaceOn(int blockId) {
        return blockId == Blocks.FARMLAND_DIRT.id();
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand, boolean isRandomTick) {
        float f;
        int meta;
        super.updateTick(world, x, y, z, rand, isRandomTick);
        if (world.getBlockLightValue(x, y + 1, z) >= 9 && (meta = world.getBlockMetadata(x, y, z)) < 6 && rand.nextInt((int)(100.0f / (f = this.getGrowthRate(world, x, y, z)))) == 0) {
            if (++meta == 5) {
                world.setBlockAndMetadataWithNotify(x, y, z, Blocks.PUMPKIN.id(), 0);
            } else {
                world.setBlockMetadataWithNotify(x, y, z, meta);
            }
        }
    }

    public void fertilize(World world, int x, int y, int z) {
        world.setBlockWithNotify(x, y, z, Blocks.PUMPKIN.id());
    }

    private float getGrowthRate(World world, int x, int y, int z) {
        float growthRate = 1.0f;
        for (int dx = x - 1; dx <= x + 1; ++dx) {
            for (int dz = z - 1; dz <= z + 1; ++dz) {
                int id = world.getBlockId(dx, y - 1, dz);
                float growthRateMod = 0.0f;
                if (id == Blocks.FARMLAND_DIRT.id()) {
                    growthRateMod = 1.0f;
                    if (world.getBlockMetadata(dx, y - 1, dz) > 0) {
                        growthRateMod = 3.0f;
                    }
                }
                if (dx != x || dz != z) {
                    growthRateMod /= 4.0f;
                }
                growthRate += growthRateMod;
            }
        }
        boolean isFertilized = BlockLogicFarmland.isFertilized(world.getBlockMetadata(x, y - 1, z));
        if (!isFertilized) {
            if (world.getSeasonManager().getCurrentSeason() != null) {
                growthRate *= world.getSeasonManager().getCurrentSeason().cropGrowthFactor;
            }
        } else {
            growthRate *= 1.5f;
        }
        return growthRate;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.SEEDS_PUMPKIN, 1)};
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 0) {
            return null;
        }
        return this.getBlockBoundsFromState(world, x, y, z).move(x, y, z);
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, @Nullable Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (world.getBlockMetadata(blockX, blockY, blockZ) < 5) {
            if (!world.isClientSide) {
                this.fertilize(world, blockX, blockY, blockZ);
                if (player == null || player.getGamemode().consumeBlocks()) {
                    --itemstack.stackSize;
                }
            }
            return true;
        }
        return false;
    }
}

