/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLayerBase;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class BlockLogicLayerAsh
extends BlockLogicLayerBase {
    public BlockLogicLayerAsh(Block<?> block, Block<?> fullBlock, Material material) {
        super(block, fullBlock, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        block.setTicking(true);
    }

    public void accumulate(World world, int x, int y, int z) {
        boolean negZValid;
        boolean negXValid;
        boolean posZValid;
        boolean posXValid;
        int myMetadata = world.getBlockMetadata(x, y, z);
        if (myMetadata == 7) {
            return;
        }
        boolean bl = posXValid = world.isBlockOpaqueCube(x + 1, y, z) || world.getBlockId(x + 1, y, z) == this.id() && world.getBlockMetadata(x + 1, y, z) >= myMetadata;
        if (!posXValid) {
            return;
        }
        boolean bl2 = posZValid = world.isBlockOpaqueCube(x, y, z + 1) || world.getBlockId(x, y, z + 1) == this.id() && world.getBlockMetadata(x, y, z + 1) >= myMetadata;
        if (!posZValid) {
            return;
        }
        boolean bl3 = negXValid = world.isBlockOpaqueCube(x - 1, y, z) || world.getBlockId(x - 1, y, z) == this.id() && world.getBlockMetadata(x - 1, y, z) >= myMetadata;
        if (!negXValid) {
            return;
        }
        boolean bl4 = negZValid = world.isBlockOpaqueCube(x, y, z - 1) || world.getBlockId(x, y, z - 1) == this.id() && world.getBlockMetadata(x, y, z - 1) >= myMetadata;
        if (!negZValid) {
            return;
        }
        world.setBlockMetadata(x, y, z, myMetadata + 1);
        world.markBlockNeedsUpdate(x, y, z);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        int l = world.getBlockId(x, y - 1, z);
        if (l == 0 || !Blocks.blocksList[l].isSolidRender()) {
            return false;
        }
        Material material = world.getBlockMaterial(x, y - 1, z);
        return material.blocksMotion();
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!this.canPlaceBlockAt(world, x, y, z)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(this, meta + 1)};
            }
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return null;
    }
}

