/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicDoor;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDoor
extends Item {
    protected final Block<? extends BlockLogicDoor> doorBlockBottom;
    protected final Block<? extends BlockLogicDoor> doorBlockTop;

    public ItemDoor(String name, String namespaceId, int id, Block<? extends BlockLogicDoor> doorBlockBottom, Block<? extends BlockLogicDoor> doorBlockTop) {
        super(name, namespaceId, id);
        this.maxStackSize = 64;
        this.doorBlockBottom = doorBlockBottom;
        this.doorBlockTop = doorBlockTop;
    }

    @Override
    public boolean onUseItemOnBlock(@NotNull ItemStack itemstack, @Nullable Player player, @NotNull World world, int blockX, int blockY, int blockZ, @NotNull Side side, double xPlaced, double yPlaced) {
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        Direction dir = player.getHorizontalPlacementDirection(side).rotate(3);
        int meta = dir.getHorizontalIndex();
        int isSolidBlockLeft = (this.isSupported(world, blockX, blockY, blockZ, dir, false) ? 1 : 0) + (this.isSupported(world, blockX, blockY + 1, blockZ, dir, false) ? 1 : 0);
        int isSolidBlockRight = (this.isSupported(world, blockX, blockY, blockZ, dir.getOpposite(), true) ? 1 : 0) + (this.isSupported(world, blockX, blockY + 1, blockZ, dir.getOpposite(), true) ? 1 : 0);
        boolean isDoorLeft = world.getBlockId(blockX + dir.getOffsetX(), blockY, blockZ + dir.getOffsetZ()) == this.doorBlockBottom.id() || world.getBlockId(blockX + dir.getOffsetX(), blockY + 1, blockZ + dir.getOffsetZ()) == this.doorBlockTop.id();
        boolean isDoorRight = world.getBlockId(blockX - dir.getOffsetX(), blockY, blockZ - dir.getOffsetZ()) == this.doorBlockBottom.id() || world.getBlockId(blockX - dir.getOffsetX(), blockY + 1, blockZ - dir.getOffsetZ()) == this.doorBlockTop.id();
        boolean isMirrored = false;
        if (isDoorLeft && !isDoorRight) {
            isMirrored = (world.getBlockMetadata(blockX + dir.getOffsetX(), blockY, blockZ + dir.getOffsetZ()) & 8) == 0;
        } else if (isSolidBlockLeft <= 0 || side.getDirection() != dir.getOpposite()) {
            if (isSolidBlockRight > 0 && side.getDirection() == dir) {
                isMirrored = true;
            } else if (isSolidBlockRight > isSolidBlockLeft) {
                isMirrored = true;
            }
        }
        if (isMirrored) {
            meta = meta - 1 & 3;
            meta |= 4;
            meta |= 8;
        }
        if (!this.doorBlockBottom.getLogic().canPlaceBlockAt(world, blockX, blockY, blockZ, meta)) {
            return false;
        }
        world.noNeighborUpdate = true;
        world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, this.doorBlockBottom.id(), meta);
        world.setBlockAndMetadataWithNotify(blockX, blockY + 1, blockZ, this.doorBlockTop.id(), meta);
        world.noNeighborUpdate = false;
        world.notifyBlocksOfNeighborChange(blockX, blockY, blockZ, this.doorBlockBottom.id());
        world.notifyBlocksOfNeighborChange(blockX, blockY + 1, blockZ, this.doorBlockTop.id());
        world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, this.doorBlockBottom, EnumBlockSoundEffectType.PLACE);
        this.doorBlockBottom.onBlockPlacedByMob(world, blockX, blockY, blockZ, side, player, xPlaced, yPlaced);
        this.doorBlockTop.onBlockPlacedByMob(world, blockX, blockY + 1, blockZ, side, player, xPlaced, yPlaced);
        itemstack.consumeItem(player);
        return true;
    }

    public boolean isSupported(@NotNull World world, int x, int y, int z, @NotNull Direction direction, boolean mirrored) {
        ISupport support = world.getSupport(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ(), direction.getSide().getOpposite());
        return support.canSupport(mirrored ? PartialSupport.INSTANCE.right() : PartialSupport.INSTANCE.left(), direction.getSide());
    }

    @Override
    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += direction.getOffsetX();
            blockY += direction.getOffsetY();
            blockZ += direction.getOffsetZ();
        }
        if (!direction.isHorizontal()) {
            direction = Direction.NORTH;
        }
        Direction dir = direction.rotate(3);
        int meta = dir.getHorizontalIndex();
        int isSolidBlockLeft = (world.isBlockNormalCube(blockX + dir.getOffsetX(), blockY, blockZ + dir.getOffsetZ()) ? 1 : 0) + (world.isBlockNormalCube(blockX + dir.getOffsetX(), blockY + 1, blockZ + dir.getOffsetZ()) ? 1 : 0);
        int isSolidBlockRight = (world.isBlockNormalCube(blockX - dir.getOffsetX(), blockY, blockZ - dir.getOffsetZ()) ? 1 : 0) + (world.isBlockNormalCube(blockX - dir.getOffsetX(), blockY + 1, blockZ - dir.getOffsetZ()) ? 1 : 0);
        boolean isDoorLeft = world.getBlockId(blockX + dir.getOffsetX(), blockY, blockZ + dir.getOffsetZ()) == this.doorBlockBottom.id() || world.getBlockId(blockX + dir.getOffsetX(), blockY + 1, blockZ + dir.getOffsetZ()) == this.doorBlockTop.id();
        boolean isDoorRight = world.getBlockId(blockX - dir.getOffsetX(), blockY, blockZ - dir.getOffsetZ()) == this.doorBlockBottom.id() || world.getBlockId(blockX - dir.getOffsetX(), blockY + 1, blockZ - dir.getOffsetZ()) == this.doorBlockTop.id();
        boolean isMirrored = false;
        if (isDoorLeft && !isDoorRight) {
            isMirrored = (world.getBlockMetadata(blockX + dir.getOffsetX(), blockY, blockZ + dir.getOffsetZ()) & 8) == 0;
        } else if (isSolidBlockRight > isSolidBlockLeft) {
            isMirrored = true;
        }
        if (isMirrored) {
            meta = meta - 1 & 3;
            meta |= 4;
            meta |= 8;
        }
        if (!this.doorBlockBottom.getLogic().canPlaceBlockAt(world, blockX, blockY, blockZ, meta)) {
            return;
        }
        world.noNeighborUpdate = true;
        world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, this.doorBlockBottom.id(), meta);
        world.setBlockAndMetadataWithNotify(blockX, blockY + 1, blockZ, this.doorBlockTop.id(), meta);
        world.noNeighborUpdate = false;
        world.notifyBlocksOfNeighborChange(blockX, blockY, blockZ, this.doorBlockBottom.id());
        world.notifyBlocksOfNeighborChange(blockX, blockY + 1, blockZ, this.doorBlockTop.id());
        world.playBlockSoundEffect(null, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, this.doorBlockBottom, EnumBlockSoundEffectType.PLACE);
        this.doorBlockBottom.onBlockPlacedOnSide(world, blockX, blockY, blockZ, direction.getSide(), 0.5, 0.5);
        this.doorBlockTop.onBlockPlacedOnSide(world, blockX, blockY + 1, blockZ, direction.getSide(), 0.5, 0.5);
        itemStack.consumeItem(null);
    }
}

