/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.world.noise.SimplexNoise;
import net.minecraft.core.world.noise.SurfaceNoise;

public class PerlinSimplexNoise
extends SurfaceNoise {
    private final SimplexNoise[] octaves;
    private final int numOctaves;

    public PerlinSimplexNoise(Random random, int numOctaves) {
        this.numOctaves = numOctaves;
        this.octaves = new SimplexNoise[numOctaves];
        for (int i = 0; i < numOctaves; ++i) {
            this.octaves[i] = new SimplexNoise(random);
        }
    }

    public double getMaximumValue() {
        return this.getMaximumValue(0.5);
    }

    public double getMaximumValue(double amplitudeScale) {
        double max = 0.0;
        double amplitude = 1.0;
        for (int l = 0; l < this.numOctaves; ++l) {
            max += 0.55 / amplitude;
            amplitude *= amplitudeScale;
        }
        return max;
    }

    public double[] getValue(double[] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double frequencyScale) {
        return this.getValue(out, x, z, xSize, zSize, xScale, zScale, frequencyScale, 0.5);
    }

    public double[] getValue(double[] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double frequencyScale, double amplitudeScale) {
        xScale /= 1.5;
        zScale /= 1.5;
        if (out == null || out.length < xSize * zSize) {
            out = new double[xSize * zSize];
        } else {
            Arrays.fill(out, 0.0);
        }
        double frequency = 1.0;
        double amplitude = 1.0;
        for (int l = 0; l < this.numOctaves; ++l) {
            this.octaves[l].add(out, x, z, xSize, zSize, xScale * frequency, zScale * frequency, 0.55 / amplitude);
            frequency *= frequencyScale;
            amplitude *= amplitudeScale;
        }
        return out;
    }
}

