/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.modelviewer.elements.IActionListener;
import net.minecraft.client.gui.modelviewer.elements.IKeyListener;
import net.minecraft.client.gui.modelviewer.elements.IListenerElement;

public class ListenerButtonElement
extends ButtonElement
implements IListenerElement<ListenerButtonElement> {
    protected IActionListener action;
    protected IKeyListener keyListener;
    protected Runnable onValueChanged;

    public ListenerButtonElement(int id, int xPosition, int yPosition, String text) {
        super(id, xPosition, yPosition, text);
    }

    public ListenerButtonElement(int id, int xPosition, int yPosition, int width, int height, String text) {
        super(id, xPosition, yPosition, width, height, text);
    }

    @Override
    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        boolean flag = super.mouseClicked(mc, mouseX, mouseY);
        if (flag) {
            this.onClick(mc, mouseX, mouseY);
        }
        return flag;
    }

    protected void onClick(Minecraft mc, int mouseX, int mouseY) {
        if (this.action != null) {
            this.action.onInteract();
            this.onValueChanged();
        }
    }

    @Override
    public ListenerButtonElement setActionListener(IActionListener listener) {
        this.action = listener;
        return this;
    }

    @Override
    public ListenerButtonElement setKeyListener(IKeyListener listener) {
        this.keyListener = listener;
        return this;
    }

    @Override
    public ListenerButtonElement setOnValueChanged(Runnable runnable) {
        this.onValueChanged = runnable;
        return this;
    }

    @Override
    public void onKeyTyped(char c, int key) {
        if (this.keyListener != null) {
            this.keyListener.onKeyPressed(key);
        }
    }

    @Override
    public void onValueChanged() {
        if (this.onValueChanged != null) {
            this.onValueChanged.run();
        }
    }

    public void tick() {
    }
}

