/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Fluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class BlockLogicFluidStill
extends BlockLogicFluid {
    public final Block<?> blockFlowing;

    public BlockLogicFluidStill(Block<?> block, Material material, @NotNull Fluid fluid, Block<?> blockFlowing) {
        super(block, material, fluid);
        block.setTicking(this.fluid.shouldTick());
        this.blockFlowing = blockFlowing;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        if (blockId == Side.TOP.getId()) {
            return;
        }
        if (world.getBlockId(x, y, z) == this.block.id()) {
            this.setFlowing(world, x, y, z);
        }
    }

    private void setFlowing(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        world.noNeighborUpdate = true;
        world.setBlockAndMetadata(x, y, z, this.blockFlowing.id(), meta);
        world.markBlocksDirty(x, y, z, x, y, z);
        world.scheduleBlockUpdate(x, y, z, this.blockFlowing.id(), this.tickDelay());
        world.noNeighborUpdate = false;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand, boolean isRandomTick) {
        this.fluid.updateTickStill(this, world, x, y, z, rand);
    }
}

