/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.sound.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundEntry {
    @NotNull
    public final SoundEvent parent;
    @NotNull
    public final TexturePack pack;
    @NotNull
    public final String name;
    @Nullable
    public final String title;
    @Nullable
    public final String author;
    public final int weight;
    public final int attenuationDistance;
    public final float volume;
    public final float pitch;
    public final boolean shouldStream;
    @NotNull
    public final Type type;
    @Nullable
    protected File file;

    public SoundEntry(@NotNull SoundEvent parentEvent, @NotNull TexturePack pack, @NotNull String name, @Nullable String title, @Nullable String author, float volume, float pitch, int weight, int attenuationDistance, boolean shouldStream, @NotNull Type type) {
        this.parent = parentEvent;
        this.pack = pack;
        this.name = name;
        this.title = title;
        this.author = author;
        this.volume = volume;
        this.pitch = pitch;
        this.weight = weight;
        this.attenuationDistance = attenuationDistance;
        this.shouldStream = shouldStream;
        this.type = type;
        this.file = type == Type.FILE ? new File(parentEvent.parentRepo.rootFile, name) : null;
    }

    @Nullable
    public URL getURL() {
        if (this.file == null || !this.file.exists()) {
            return null;
        }
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            System.err.println("Error getting url for sound '" + this.name + "'");
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "SoundEntry{file=" + this.file + ", name='" + this.name + '\'' + ", pack=" + this.pack + ", shouldStream=" + this.shouldStream + '}';
    }

    public static enum Type {
        FILE,
        EVENT;

    }
}

