/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.logging;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.Marker;

public final class CategorizedLogger
implements Logger {
    @NotNull
    private static final @NotNull Map<@NotNull String, @NotNull Boolean> CATEGORIES_ENABLED = new HashMap<String, Boolean>();
    @NotNull
    private final Logger delegate;

    public static void setCategoryEnabled(@NotNull String category, boolean enabled) {
        CATEGORIES_ENABLED.put(category, enabled);
    }

    public static boolean isCategoryEnabled(@NotNull String category) {
        if (!CATEGORIES_ENABLED.containsKey(category)) {
            CATEGORIES_ENABLED.put(category, false);
            return false;
        }
        return CATEGORIES_ENABLED.getOrDefault(category, false);
    }

    public static Collection<String> getKnownCategories() {
        return CATEGORIES_ENABLED.keySet();
    }

    public CategorizedLogger(@NotNull Logger logger) {
        this.delegate = logger;
    }

    @NotNull
    private String prependCategory(@NotNull String category, @NotNull String message) {
        return category + ": " + message;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        this.delegate.trace(msg);
    }

    @Override
    public void trace(String format, Object arg) {
        this.delegate.trace(format, arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.delegate.trace(format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.delegate.trace(format, arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.delegate.trace(msg, t);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    @Override
    public void trace(Marker marker, String msg) {
        this.delegate.trace(marker, msg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        this.delegate.trace(marker, format, arg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.trace(marker, format, arg1, arg2);
    }

    @Override
    public void trace(Marker marker, String format, Object ... argArray) {
        this.delegate.trace(marker, format, argArray);
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        this.delegate.trace(marker, msg, t);
    }

    public void trace(String category, String msg) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.trace(this.prependCategory(category, msg));
    }

    public void trace(String category, String format, Object arg) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.trace(this.prependCategory(category, format), arg);
    }

    public void trace(String category, String format, Object arg1, Object arg2) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.trace(this.prependCategory(category, format), arg1, arg2);
    }

    public void trace(String category, String format, Object ... arguments) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.trace(this.prependCategory(category, format), arguments);
    }

    public void trace(String category, String msg, Throwable t) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.trace(this.prependCategory(category, msg), t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.delegate.debug(msg);
    }

    @Override
    public void debug(String format, Object arg) {
        this.delegate.debug(format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.delegate.debug(format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.delegate.debug(format, arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.delegate.debug(msg, t);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    @Override
    public void debug(Marker marker, String msg) {
        this.delegate.debug(marker, msg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        this.delegate.debug(marker, format, arg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.debug(marker, format, arg1, arg2);
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        this.delegate.debug(marker, format, arguments);
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        this.delegate.debug(marker, msg, t);
    }

    public void debug(String category, String msg) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.debug(this.prependCategory(category, msg));
    }

    public void debug(String category, String format, Object arg) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.debug(this.prependCategory(category, format), arg);
    }

    public void debug(String category, String format, Object arg1, Object arg2) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.debug(this.prependCategory(category, format), arg1, arg2);
    }

    public void debug(String category, String format, Object ... arguments) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.debug(this.prependCategory(category, format), arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        this.delegate.info(msg);
    }

    @Override
    public void info(String format, Object arg) {
        this.delegate.info(format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.delegate.info(format, arg1, arg2);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.delegate.info(format, arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.delegate.info(msg, t);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    @Override
    public void info(Marker marker, String msg) {
        this.delegate.info(marker, msg);
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        this.delegate.info(marker, format, arg);
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.info(marker, format, arg1, arg2);
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        this.delegate.info(marker, format, arguments);
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        this.delegate.info(marker, msg, t);
    }

    public void info(String category, String msg) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.info(this.prependCategory(category, msg));
    }

    public void info(String category, String format, Object arg) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.info(this.prependCategory(category, format), arg);
    }

    public void info(String category, String format, Object arg1, Object arg2) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.info(this.prependCategory(category, format), arg1, arg2);
    }

    public void info(String category, String format, Object ... arguments) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.info(this.prependCategory(category, format), arguments);
    }

    public void info(String category, String msg, Throwable t) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.info(this.prependCategory(category, msg), t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        this.delegate.warn(msg);
    }

    @Override
    public void warn(String format, Object arg) {
        this.delegate.warn(format, arg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.delegate.warn(format, arguments);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.delegate.warn(format, arg1, arg2);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.delegate.warn(msg, t);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    @Override
    public void warn(Marker marker, String msg) {
        this.delegate.warn(marker, msg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        this.delegate.warn(marker, format, arg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.warn(marker, format, arg1, arg2);
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        this.delegate.warn(marker, format, arguments);
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        this.delegate.warn(marker, msg, t);
    }

    public void warn(String category, String msg) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.warn(this.prependCategory(category, msg));
    }

    public void warn(String category, String format, Object arg) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.warn(this.prependCategory(category, format), arg);
    }

    public void warn(String category, String format, Object ... arguments) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.warn(this.prependCategory(category, format), arguments);
    }

    public void warn(String category, String format, Object arg1, Object arg2) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.warn(this.prependCategory(category, format), arg1, arg2);
    }

    public void warn(String category, String msg, Throwable t) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.warn(this.prependCategory(category, msg), t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        this.delegate.error(msg);
    }

    @Override
    public void error(String format, Object arg) {
        this.delegate.error(format, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.delegate.error(format, arg1, arg2);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.delegate.error(format, arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.delegate.error(msg, t);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    @Override
    public void error(Marker marker, String msg) {
        this.delegate.error(marker, msg);
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        this.delegate.error(marker, format, arg);
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.error(marker, format, arg1, arg2);
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        this.delegate.error(marker, format, arguments);
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        this.delegate.error(marker, msg, t);
    }

    public void error(String category, String msg) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.error(this.prependCategory(category, msg));
    }

    public void error(String category, String format, Object arg) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.error(this.prependCategory(category, format), arg);
    }

    public void error(String category, String format, Object arg1, Object arg2) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.error(this.prependCategory(category, format), arg1, arg2);
    }

    public void error(String category, String format, Object ... arguments) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.error(this.prependCategory(category, format), arguments);
    }

    public void error(String category, String msg, Throwable t) {
        if (!CategorizedLogger.isCategoryEnabled(category)) {
            return;
        }
        this.delegate.error(this.prependCategory(category, msg), t);
    }
}

