/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.BlockLogicFire;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.Fluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class FluidLava
implements Fluid {
    @Override
    public int tickDelay() {
        return 30;
    }

    @Override
    public void animationTick(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z, @NotNull Random rand) {
        boolean isTop;
        boolean bl = isTop = world.getBlockMaterial(x, y + 1, z) == Material.air && !world.isBlockOpaqueCube(x, y + 1, z);
        if (isTop && rand.nextInt(100) == 0) {
            double xOff = (double)x + (double)rand.nextFloat();
            double yOff = (double)y + logicFluid.getBounds().maxY;
            double zOff = (double)z + (double)rand.nextFloat();
            world.spawnParticle("lava", xOff, yOff, zOff, 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public void checkForHarden(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z, @NotNull Material encountered) {
        if (encountered == Material.water) {
            int data = world.getBlockMetadata(x, y, z) & 0xF;
            if (data == 0) {
                if (world.dimension == Dimension.NETHER) {
                    world.setBlockWithNotify(x, y, z, Blocks.COBBLE_NETHERRACK_IGNEOUS.id());
                } else {
                    world.setBlockWithNotify(x, y, z, Blocks.OBSIDIAN.id());
                }
            } else if (data <= 2) {
                world.setBlockWithNotify(x, y, z, Blocks.COBBLE_GRANITE.id());
            } else if (data <= 4) {
                world.setBlockWithNotify(x, y, z, Blocks.COBBLE_STONE.id());
            } else {
                world.setBlockWithNotify(x, y, z, Blocks.COBBLE_BASALT.id());
            }
            BlockLogicFluid.fizz(world, x, y, z);
        }
    }

    @Override
    public boolean shouldTick() {
        return true;
    }

    @Override
    public void updateTickStill(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z, @NotNull Random rand) {
        int count = rand.nextInt(3);
        for (int i = 0; i < count; ++i) {
            int id = world.getBlockId(x += rand.nextInt(3) - 1, ++y, z += rand.nextInt(3) - 1);
            if (id == 0) {
                if (!FluidLava.isFlammable(world, x - 1, y, z) && !FluidLava.isFlammable(world, x + 1, y, z) && !FluidLava.isFlammable(world, x, y, z - 1) && !FluidLava.isFlammable(world, x, y, z + 1) && !FluidLava.isFlammable(world, x, y - 1, z) && !FluidLava.isFlammable(world, x, y + 1, z)) continue;
                world.setBlockWithNotify(x, y, z, Blocks.FIRE.id());
                return;
            }
            if (!Blocks.blocksList[id].getMaterial().blocksMotion()) continue;
            return;
        }
    }

    private static boolean isFlammable(World world, int x, int y, int z) {
        return BlockLogicFire.canBurn(world, x, y, z);
    }

    @Override
    public byte getFlowDecayMod(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z) {
        if (world.dimension == Dimension.NETHER) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean canBecomeSource(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z, @NotNull Random rand) {
        return false;
    }

    @Override
    public void onFlowIntoBlock(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z, int meta) {
        BlockLogicFluid.fizz(world, x, y, z);
    }

    @Override
    public boolean canSpreadTo(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z, @NotNull Material material) {
        return material != Material.lava;
    }
}

