/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.enums.IArmorShape;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemArmor<T extends IArmorShape>
extends Item
implements IArmorItem<T> {
    private final ArmorMaterial material;
    private final T armorShape;

    public ItemArmor(@NotNull String name, @NotNull String namespaceId, int id, ArmorMaterial material, @NotNull T armorShape) {
        super(name, namespaceId, id);
        this.material = material;
        this.armorShape = armorShape;
        this.setMaxDamage((int)(armorShape.getDurabilityModifier() * (float)material.durability));
        this.maxStackSize = 1;
    }

    @Override
    @Nullable
    public ItemStack onUseItem(@NotNull ItemStack itemstack, @NotNull World world, @NotNull Player entityplayer) {
        if (!(this.armorShape instanceof HumanArmorShape)) {
            return itemstack;
        }
        HumanArmorShape humanArmorShape = (HumanArmorShape)this.armorShape;
        ItemStack currentArmorInSlot = entityplayer.getItemInArmorSlot(humanArmorShape);
        entityplayer.setItemInArmorSlot(humanArmorShape, itemstack);
        return currentArmorInSlot;
    }

    @Override
    public ArmorMaterial getArmorMaterial() {
        return this.material;
    }

    @Override
    @NotNull
    public T getArmorShape() {
        return this.armorShape;
    }
}

