/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.bta;

import java.io.File;
import java.util.Objects;
import net.minecraft.core.world.save.LevelData;
import org.jetbrains.annotations.NotNull;
import org.useless.seedviewer.bta.BTAChunkProvider;
import org.useless.seedviewer.bta.worldloader.LevelDataLoader;
import org.useless.seedviewer.data.ViewerWorld;
import org.useless.seedviewer.gui.ChunkProvider;

public class BTAWorld
implements ViewerWorld {
    @NotNull
    private final File worldFolder;
    private final LevelData data;

    public BTAWorld(@NotNull File worldFolder) {
        this.worldFolder = worldFolder;
        this.data = Objects.requireNonNull(LevelDataLoader.getLevelData(worldFolder), "Failed to get level data from world '" + worldFolder + "'");
    }

    @Override
    public File getFolder() {
        return this.worldFolder;
    }

    @Override
    public long getSeed() {
        return this.data.getRandomSeed();
    }

    @Override
    public String getName() {
        return this.data.getWorldName();
    }

    @Override
    public long getLastPlayed() {
        return this.data.getLastTimePlayed();
    }

    @Override
    public ChunkProvider getChunkProvider() {
        return new BTAChunkProvider(this.worldFolder, this.data);
    }
}

