/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public abstract class ButtonComponent
implements OptionsComponent {
    protected static final Minecraft mc = Minecraft.getMinecraft();
    protected static final int COMPONENT_SPACING = 2;
    private static final int BUTTON_WIDTH = 100;
    @NotNull
    private final String translationKey;
    @Nullable
    private final String tooltipTranslationKey;
    protected final ButtonElement resetButton;
    private boolean hovered = false;

    public ButtonComponent(@NotNull String translationKey, @Nullable String tooltipTranslationKey) {
        this.translationKey = translationKey;
        this.tooltipTranslationKey = tooltipTranslationKey;
        this.resetButton = new ButtonElement(0, 0, 0, 20, 20, "").setTextures("minecraft:gui/misc/icon_reset", "minecraft:gui/misc/icon_reset_highlighted", "minecraft:gui/misc/icon_reset");
    }

    public abstract void resetValue();

    public abstract boolean isDefault();

    @Override
    public int getHeight() {
        return 24;
    }

    @Override
    @Nullable
    public String getTooltipTranslationKey() {
        if (!this.hovered) {
            return null;
        }
        return this.tooltipTranslationKey;
    }

    @Override
    public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        String translated = I18n.getInstance().translateKey(this.translationKey);
        int textColor = -1;
        if (relativeMouseX >= 0 && relativeMouseX <= width && relativeMouseY >= 2 && relativeMouseY <= this.getHeight() - 2) {
            textColor = -96;
        }
        this.hovered = relativeMouseX >= 0 && relativeMouseX <= width - 100 && relativeMouseY >= 2 && relativeMouseY <= this.getHeight() - 2;
        ButtonComponent.mc.font.render(Tessellator.instance, translated, x, y + this.getHeight() / 2 - 4).setShadow().setColor(textColor).call();
        this.resetButton.enabled = !this.isDefault();
        this.renderButton(x, y, width - 100, 2, 100, 20, relativeMouseX, relativeMouseY);
        int stringWidth = ButtonComponent.mc.font.stringWidth(translated);
        int lineMaxX = x + width - 100 - 8;
        if (this.resetButton.enabled) {
            lineMaxX -= 20;
        }
        this.drawRect(x + stringWidth + 8, y + this.getHeight() / 2, lineMaxX, y + this.getHeight() / 2 + 1, 0x5F7F7F7F);
    }

    @Override
    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (relativeMouseX >= width - 100 && relativeMouseX <= width && relativeMouseY >= 2 && relativeMouseY <= 22) {
            ButtonComponent.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
            this.buttonClicked(mouseButton, x, y, width, this.getHeight(), relativeMouseX - (width - 100), relativeMouseY - 2);
        } else if (this.resetButton.enabled && relativeMouseX >= width - 100 - 20 && relativeMouseX <= width - 100 && relativeMouseY >= 2 && relativeMouseY <= 22) {
            ButtonComponent.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
            this.resetValue();
        }
    }

    @Override
    public void onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        this.buttonDragged(x, y, width, this.getHeight(), relativeMouseX - (width - 100), relativeMouseY - 2);
    }

    @Override
    public void onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        this.buttonReleased(mouseButton, x, y, width, this.getHeight(), relativeMouseX - (width - 100), relativeMouseY - 2);
    }

    protected abstract void buttonClicked(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected void buttonDragged(int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
    }

    protected void buttonReleased(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onKeyPress(int keyCode, char character) {
    }

    @Override
    public boolean matchesSearchTerm(String term) {
        return I18n.getInstance().translateKey(this.translationKey).toLowerCase().contains(term.toLowerCase());
    }

    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        if (this.resetButton.enabled) {
            this.resetButton.xPosition = x + relativeButtonX - 20;
            this.resetButton.yPosition = y + relativeButtonY;
            this.resetButton.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
            if (relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
                ButtonComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
            }
        }
    }

    protected void drawRect(int minX, int minY, int maxX, int maxY, int argb) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable(3042);
        GL11.glDisable(3553);
        GL11.glBlendFunc(770, 771);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(argb & 0xFFFFFF, argb >> 24 & 0xFF);
        tessellator.addVertex(minX, maxY, 0.0);
        tessellator.addVertex(maxX, maxY, 0.0);
        tessellator.addVertex(maxX, minY, 0.0);
        tessellator.addVertex(minX, minY, 0.0);
        tessellator.draw();
        GL11.glEnable(3553);
        GL11.glDisable(3042);
    }
}

