/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.support;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public interface ISupportable {
    @NotNull
    public ISupport getSupportConstraint(@NotNull World var1, int var2, int var3, int var4, @NotNull Side var5);

    default public boolean isSupported(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        Block<?> supportingBlock = world.getBlock(x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ());
        if (supportingBlock == null) {
            return false;
        }
        ISupport supporting = supportingBlock.getSupport(world, x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ(), side.getOpposite());
        ISupport supported = this.getSupportConstraint(world, x, y, z, side);
        return supporting.canSupport(supported, side.getOpposite());
    }
}

