/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.bta;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.chunk.Chunk;
import org.jetbrains.annotations.NotNull;
import org.useless.seedviewer.bta.BTABiome;
import org.useless.seedviewer.collections.ChunkPos2D;
import org.useless.seedviewer.collections.ChunkPos3D;
import org.useless.seedviewer.data.ViewerBiome;
import org.useless.seedviewer.data.ViewerChunk;

public class BTAComplexChunk
implements ViewerChunk {
    private final Chunk chunk;
    private final BiomeProvider provider;

    public BTAComplexChunk(@NotNull Chunk chunk, BiomeProvider biomeProvider) {
        this.chunk = chunk;
        this.provider = biomeProvider;
    }

    @Override
    public ViewerBiome getBiome(ChunkPos3D pos) {
        Biome b = this.chunk.getBlockBiome(pos.x, pos.y, pos.z);
        if (b != null) {
            return new BTABiome(b);
        }
        return new BTABiome(this.provider.getBiome(this.chunk.xPosition * 16 + pos.x, pos.y, this.chunk.zPosition * 16 + pos.z));
    }

    @Override
    public int getBlockColor(ChunkPos3D pos) {
        Block<?> b = Blocks.getBlock(this.chunk.getBlockID(pos.x, pos.y, pos.z));
        if (b == null) {
            return 0;
        }
        int meta = this.chunk.getBlockMetadata(pos.x, pos.y, pos.z);
        return MaterialColor.getColorFromIndex(MaterialColor.getColorIndexFromBlock(b, meta)) | 0xFF000000;
    }

    @Override
    public int getHeight(ChunkPos2D pos) {
        return this.chunk.getHeightValue(pos.x, pos.z);
    }

    @Override
    public int getWaterDepth(ChunkPos2D pos) {
        Block<?> b;
        int y;
        int start = this.getHeight(pos) - 1;
        int depth = 0;
        while ((y = start - depth) >= 0 && (b = Blocks.getBlock(this.chunk.getBlockID(pos.x, y, pos.z))) != null && b.getMaterial() == Material.water) {
            ++depth;
        }
        return depth;
    }
}

