/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenMainMenu;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.ScreenStats;
import net.minecraft.client.gui.achievements.ScreenAchievements;
import net.minecraft.client.gui.guidebook.GuidebookPageManager;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.gui.guidebook.search.GuidebookPageSearch;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.input.InputType;
import net.minecraft.client.util.helper.UrlHelper;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;

public class ScreenPause
extends Screen {
    private int updateCounter2 = 0;
    private int updateCounter = 0;
    public static boolean photoModeDisabled = false;

    @Override
    public void init() {
        I18n i = I18n.getInstance();
        this.updateCounter2 = 0;
        this.buttons.clear();
        int byte0 = -16;
        this.buttons.add(new ButtonElement(1, this.width / 2 - 100, this.height / 4 + 120 + byte0, i.translateKey("gui.ingame_menu.button.save_and_quit")));
        if (this.mc.isMultiplayerWorld()) {
            ((ButtonElement)this.buttons.get((int)0)).displayString = i.translateKey("gui.ingame_menu.button.disconnect");
        }
        this.buttons.add(new ButtonElement(4, this.width / 2 - 100, this.height / 4 + 24 + byte0, i.translateKey("gui.ingame_menu.button.back_to_game")));
        this.buttons.add(new ButtonElement(0, this.width / 2 - 100, this.height / 4 + 96 + byte0, 98, 20, i.translateKey("gui.ingame_menu.button.options")));
        ButtonElement photoModeButton = new ButtonElement(7, this.width / 2 + 2, this.height / 4 + 96 + byte0, 98, 20, i.translateKey("gui.ingame_menu.button.photo_mode"));
        this.buttons.add(photoModeButton);
        if (photoModeDisabled) {
            photoModeButton.enabled = false;
        }
        this.buttons.add(new ButtonElement(5, this.width / 2 - 100, this.height / 4 + 48 + byte0, 98, 20, I18n.getInstance().translateKey("gui.ingame_menu.button.achievements")));
        this.buttons.add(new ButtonElement(6, this.width / 2 + 2, this.height / 4 + 48 + byte0, 98, 20, I18n.getInstance().translateKey("gui.ingame_menu.button.statistics")));
        ButtonElement debugButton = new ButtonElement(9, this.width - 8, this.height - 8, 8, 8, "");
        debugButton.visible = false;
        this.buttons.add(debugButton);
        this.buttons.add(new ButtonElement(10, this.width / 2 - 100 - 24, this.height / 4 + 120 + byte0, 20, 20, "").setTextures("minecraft:gui/misc/button_support", "minecraft:gui/misc/button_support_highlighted", "minecraft:gui/misc/button_support"));
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        switch (button.id) {
            case 0: {
                this.mc.displayScreen(new ScreenOptions(this));
                break;
            }
            case 1: {
                this.mc.statsCounter.add(StatList.leaveGameStat, 1);
                if (this.mc.isMultiplayerWorld()) {
                    this.mc.currentWorld.sendQuittingDisconnectingPacket();
                    Registries.RECIPES = Registries.RECIPES_LOCAL_COPY;
                    GuidebookPageSearch.searchField.setText("");
                    GuidebookPageManager.searchQuery = SearchQuery.resolve(GuidebookPageSearch.searchField.getText());
                    ScreenGuidebook.getPageManager().updatePages();
                }
                this.mc.changeWorld(null);
                this.mc.displayScreen(new ScreenMainMenu());
                break;
            }
            case 4: {
                this.mc.displayScreen(null);
                this.mc.setIngameFocus();
                if (this.mc.inputType != InputType.CONTROLLER) break;
                this.mc.controllerInput.buttonA.cancelButtonPress();
                break;
            }
            case 5: {
                this.mc.displayScreen(new ScreenAchievements(this, this.mc.statsCounter));
                break;
            }
            case 6: {
                this.mc.displayScreen(new ScreenStats(this, this.mc.statsCounter));
                break;
            }
            case 7: {
                this.mc.displayScreen(new ScreenPhotoMode());
                break;
            }
            case 9: {
                this.mc.displayScreen(new ScreenOptions(this, OptionsPages.DEBUG));
                break;
            }
            case 10: {
                UrlHelper.openURL("https://bugs.betterthanadventure.net/");
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        ++this.updateCounter;
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        boolean isSaving;
        I18n i = I18n.getInstance();
        this.renderBackground();
        if (this.mc == null || this.mc.currentWorld == null) {
            this.mc.displayScreen(null);
            return;
        }
        boolean bl = isSaving = !this.mc.currentWorld.pauseScreenSave(this.updateCounter2++);
        if (isSaving || this.updateCounter < 20) {
            float f1 = ((float)(this.updateCounter % 10) + partialTick) / 10.0f;
            f1 = MathHelper.sin(f1 * (float)Math.PI * 2.0f) * 0.2f + 0.8f;
            int k = (int)(255.0f * f1);
            this.drawStringShadow(this.fontRenderer, i.translateKey("gui.ingame_menu.label.saving"), 8, this.height - 16, k << 16 | k << 8 | k);
        }
        this.drawStringCenteredShadow(this.fontRenderer, i.translateKey("gui.ingame_menu.label.title"), this.width / 2, 40, 0xFFFFFF);
        String score = TextFormatting.YELLOW.toString() + this.mc.thePlayer.getScore();
        this.drawStringCenteredShadow(this.fontRenderer, i.translateKeyAndFormat("gui.ingame_menu.label.score", score), this.width / 2, 56, 0xFEFEFE);
        super.render(mx, my, partialTick);
    }
}

