/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.popup;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.popup.ButtonComponent;
import net.minecraft.client.gui.popup.ButtonGroupComponent;
import net.minecraft.client.gui.popup.LabelComponent;
import net.minecraft.client.gui.popup.ListComponent;
import net.minecraft.client.gui.popup.MessageBoxComponent;
import net.minecraft.client.gui.popup.PopupCloseListener;
import net.minecraft.client.gui.popup.PopupComponent;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.gui.popup.TextInputComponent;
import net.minecraft.core.lang.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupBuilder {
    @Nullable
    private final Screen parent;
    private final int width;
    @Nullable
    private Integer statusCodeOnEsc = null;
    @Nullable
    private Integer statusCodeOnEnter = null;
    @Nullable
    private Integer statusCodeOnClickOut = null;
    @NotNull
    private final @NotNull List<@NotNull PopupComponent> components = new ArrayList<PopupComponent>();
    @NotNull
    private final @NotNull Map<@NotNull PopupComponent, @NotNull String> componentKeyMap = new HashMap<PopupComponent, String>();
    @NotNull
    private final @NotNull List<@NotNull PopupCloseListener> onCloseListeners = new ArrayList<PopupCloseListener>();
    @Nullable
    private IntIntPair backgroundColor = null;

    public PopupBuilder(@Nullable Screen parent, int width) {
        this.parent = parent;
        this.width = width;
    }

    public PopupScreen build() {
        PopupScreen popup = new PopupScreen(this.parent, this.width, this.getHeight(), this.statusCodeOnEsc, this.statusCodeOnEnter, this.statusCodeOnClickOut, this.components, this.componentKeyMap, this.onCloseListeners, this.backgroundColor);
        for (PopupComponent component : this.components) {
            component.setParent(popup);
        }
        return popup;
    }

    private int getHeight() {
        int accY = 8;
        for (PopupComponent component : this.components) {
            accY += component.getHeight() + 4;
        }
        accY -= 4;
        return accY += 8;
    }

    @NotNull
    public PopupBuilder closeOnEsc(int statusCode) {
        this.statusCodeOnEsc = statusCode;
        return this;
    }

    @NotNull
    public PopupBuilder closeOnEnter(int statusCode) {
        this.statusCodeOnEnter = statusCode;
        return this;
    }

    @NotNull
    public PopupBuilder closeOnClickOut(int statusCode) {
        this.statusCodeOnClickOut = statusCode;
        return this;
    }

    @NotNull
    public PopupBuilder withLabelLiteral(@NotNull String text, int color) {
        @NotNull LabelComponent component = new LabelComponent(this.width, text, color);
        this.components.add(component);
        return this;
    }

    @NotNull
    public PopupBuilder withLabelLiteral(@NotNull String text) {
        return this.withLabelLiteral(text, -1);
    }

    @NotNull
    public PopupBuilder withLabel(@NotNull String translationKey, int color) {
        return this.withLabelLiteral(I18n.getInstance().translateKey(translationKey), color);
    }

    @NotNull
    public PopupBuilder withLabel(@NotNull String translationKey) {
        return this.withLabel(translationKey, -1);
    }

    @NotNull
    public PopupBuilder withTextField(@NotNull String key, @NotNull String defaultText) {
        @NotNull TextInputComponent component = new TextInputComponent(this.width - 16, defaultText, "");
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    @NotNull
    public PopupBuilder withTextField(@NotNull String key, @NotNull String defaultText, @NotNull String placeholderTranslationKey) {
        @NotNull TextInputComponent component = new TextInputComponent(this.width - 16, defaultText, I18n.getInstance().translateKey(placeholderTranslationKey));
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    @NotNull
    public PopupBuilder withButtonGroup(@NotNull String key, @NotNull @NotNull String @NotNull [] buttonTranslationKeys, int @NotNull [] buttonStatusCodes) {
        @NotNull String @NotNull [] buttonLabels = new String[buttonTranslationKeys.length];
        for (int i = 0; i < buttonTranslationKeys.length; ++i) {
            buttonLabels[i] = I18n.getInstance().translateKey(buttonTranslationKeys[i]);
        }
        boolean @NotNull [] enabled = new boolean[buttonTranslationKeys.length];
        Arrays.fill(enabled, true);
        ButtonGroupComponent component = new ButtonGroupComponent(this.width - 16, buttonLabels, buttonStatusCodes, enabled);
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    public PopupBuilder withButtonGroup(@NotNull String key, @NotNull @NotNull String @NotNull [] buttonTranslationKeys, int @NotNull [] buttonStatusCodes, boolean @NotNull [] enabled) {
        @NotNull String @NotNull [] buttonLabels = new String[buttonTranslationKeys.length];
        for (int i = 0; i < buttonTranslationKeys.length; ++i) {
            buttonLabels[i] = I18n.getInstance().translateKey(buttonTranslationKeys[i]);
        }
        @NotNull ButtonGroupComponent component = new ButtonGroupComponent(this.width - 16, buttonLabels, buttonStatusCodes, enabled);
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    @NotNull
    public PopupBuilder withList(@NotNull String key, int height, @NotNull @NotNull String @NotNull [] buttons, @NotNull String @Nullable [] buttonDescs, int selectedItem, boolean closeOnItemSelected) {
        @NotNull ListComponent component = new ListComponent(this.width - 16, height, buttons, buttonDescs, selectedItem, closeOnItemSelected);
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    @NotNull
    public PopupBuilder withMessageBox(@NotNull String key, int height, @NotNull String text, int chars) {
        @NotNull MessageBoxComponent component = new MessageBoxComponent(this.width - 16, height, text, chars);
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    @NotNull
    public PopupBuilder withButton(@NotNull String key, @NotNull String labelTranslationKey, int defaultValue, String ... valueTranslationKeys) {
        ButtonComponent component = new ButtonComponent(this.width - 16, labelTranslationKey, valueTranslationKeys, defaultValue);
        this.components.add(component);
        this.componentKeyMap.put(component, key);
        return this;
    }

    @NotNull
    public PopupBuilder withBackgroundColor(int color, int color2) {
        this.backgroundColor = IntIntPair.of(color, color2);
        return this;
    }

    @NotNull
    public PopupBuilder withOnCloseListener(@NotNull PopupCloseListener listener) {
        this.onCloseListeners.add(listener);
        return this;
    }
}

