/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicVeryRotatable;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.DisplayPos;

public class BlockModelVeryRotatable<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected static final DisplayPos ROTATABLE_GUI = new DisplayPos(0.0f, 0.0f, 0.0f, 30.0f, 45.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    protected static final DisplayPos ROTATABLE_HEAD = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, -180.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    protected static final DisplayPos ROTATABLE_FIRST_PERSON_RIGHT_HAND = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, -45.0f, 0.0f, 0.4f, 0.4f, 0.4f);

    public BlockModelVeryRotatable(Block<T> block) {
        super(block);
        this.setDisplayPos("gui", ROTATABLE_GUI);
        this.setDisplayPos("head", ROTATABLE_HEAD);
        this.setDisplayPos("firstperson_righthand", ROTATABLE_FIRST_PERSON_RIGHT_HAND);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        int meta = worldSource.getBlockMetadata(x, y, z);
        Direction dir = BlockLogicVeryRotatable.metaToDirection(meta);
        if (dir == Direction.DOWN || dir == Direction.UP) {
            BlockModelVeryRotatable.renderBlocks.uvRotateSouth = 1;
            BlockModelVeryRotatable.renderBlocks.uvRotateNorth = 2;
            BlockModelVeryRotatable.renderBlocks.uvRotateEast = 1;
            BlockModelVeryRotatable.renderBlocks.uvRotateWest = 2;
        } else if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            BlockModelVeryRotatable.renderBlocks.uvRotateTop = 1;
            BlockModelVeryRotatable.renderBlocks.uvRotateBottom = 1;
        }
        boolean result = super.render(tessellator, worldSource, x, y, z);
        renderBlocks.resetRenderBlocks();
        return result;
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        BlockModelVeryRotatable.renderBlocks.uvRotateTop = 1;
        BlockModelVeryRotatable.renderBlocks.uvRotateBottom = 1;
        super.renderStandalone(tessellator, 3, brightness, alpha, lightmapCoordinate);
        renderBlocks.resetRenderBlocks();
    }

    @Override
    @Nullable
    public IconCoordinate getBlockOverbrightTextureFromSideAndMeta(Side side, int data) {
        return super.getBlockOverbrightTextureFromSideAndMeta(this.getRotatedSide(side, data), data);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return super.getBlockTextureFromSideAndMetadata(this.getRotatedSide(side, data), data);
    }

    public Side getRotatedSide(Side side, int data) {
        Direction dir = BlockLogicVeryRotatable.metaToDirection(data);
        switch (dir) {
            case SOUTH: {
                return side;
            }
            case EAST: {
                return side.getDirection().rotate(1).getSide();
            }
            case NORTH: {
                return side.getDirection().rotate(2).getSide();
            }
            case WEST: {
                return side.getDirection().rotate(3).getSide();
            }
            case UP: {
                switch (side) {
                    case NORTH: {
                        return Side.TOP;
                    }
                    case SOUTH: {
                        return Side.BOTTOM;
                    }
                    case TOP: {
                        return Side.SOUTH;
                    }
                    case BOTTOM: {
                        return Side.NORTH;
                    }
                }
                return side;
            }
            case DOWN: {
                switch (side) {
                    case NORTH: {
                        return Side.TOP;
                    }
                    case SOUTH: {
                        return Side.BOTTOM;
                    }
                    case TOP: {
                        return Side.NORTH;
                    }
                    case BOTTOM: {
                        return Side.SOUTH;
                    }
                }
                return side;
            }
        }
        return Side.BOTTOM;
    }
}

