/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.logging;

import com.mojang.logging.CategorizedLogger;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LogUtils {
    public static final String FATAL_MARKER_ID = "FATAL";
    public static final Marker FATAL_MARKER = MarkerFactory.getMarker("FATAL");

    public static boolean isLoggerActive() {
        org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext();
        if (loggerContext instanceof LifeCycle) {
            LifeCycle lifeCycle = (LifeCycle)((Object)loggerContext);
            return !lifeCycle.isStopped();
        }
        return true;
    }

    public static void configureRootLoggingLevel(org.slf4j.event.Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(LogUtils.convertLevel(level));
        ctx.updateLoggers();
    }

    private static Level convertLevel(org.slf4j.event.Level level) {
        switch (level) {
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        throw new IncompatibleClassChangeError();
    }

    public static Object defer(Supplier<Object> result) {
        class ToString {
            final /* synthetic */ Supplier val$result;

            ToString(Supplier supplier) {
                this.val$result = supplier;
            }

            public String toString() {
                return this.val$result.get().toString();
            }
        }
        return new ToString(result);
    }

    public static CategorizedLogger getLogger() {
        return new CategorizedLogger(LoggerFactory.getLogger(LogUtils.getCallerClass().getSimpleName()));
    }

    private static Class<?> getCallerClass() {
        try {
            StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
            for (int i = 1; i < stElements.length; ++i) {
                StackTraceElement ste = stElements[i];
                if (ste.getClassName().equals(LogUtils.class.getName()) || ste.getClassName().indexOf("java.lang.Thread") == 0) continue;
                return Class.forName(ste.getClassName());
            }
        }
        catch (ClassNotFoundException notFoundException) {
            System.err.print("Could not find calling class!");
        }
        return LogUtils.class;
    }
}

