/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScrolledSelectionList;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatItem;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.achievement.stat.StatsCounter;
import net.minecraft.core.item.Item;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ScreenStats
extends Screen {
    private static final int STATS_ICON_SIZE = 18;
    private static final int COLUMN_BUTTON_SIZE = 36;
    private static final int COLUMN0_RIGHT = 115;
    private static final int COLUMN1_RIGHT = 165;
    private static final int COLUMN2_RIGHT = 215;
    protected Screen parent;
    protected TooltipElement tooltip;
    protected String title = I18n.getInstance().translateKey("gui.statistics.label.title");
    private GeneralStatisticsList generalStatisticsList;
    private ItemStatisticsList itemStatisticsList;
    private BlockStatisticsList blockStatisticsList;
    private final StatsCounter statsCounter;
    private ScrolledSelectionList selectionList = null;

    public ScreenStats(Screen parent, StatsCounter statsCounter) {
        this.parent = parent;
        this.statsCounter = statsCounter;
        this.tooltip = new TooltipElement(Minecraft.getMinecraft());
    }

    @Override
    public void init() {
        this.generalStatisticsList = new GeneralStatisticsList();
        this.itemStatisticsList = new ItemStatisticsList();
        this.blockStatisticsList = new BlockStatisticsList();
        this.selectionList = this.generalStatisticsList;
        this.createButtons();
    }

    public void createButtons() {
        I18n i18n = I18n.getInstance();
        this.buttons.add(new ButtonElement(0, this.width / 2 + 4, this.height - 28, 150, 20, i18n.translateKey("gui.statistics.button.done")));
        this.buttons.add(new ButtonElement(1, this.width / 2 - 154, this.height - 52, 100, 20, i18n.translateKey("gui.statistics.button.general")));
        ButtonElement blocksButton = new ButtonElement(2, this.width / 2 - 46, this.height - 52, 100, 20, i18n.translateKey("gui.statistics.button.blocks"));
        this.buttons.add(blocksButton);
        ButtonElement itemsButton = new ButtonElement(3, this.width / 2 + 62, this.height - 52, 100, 20, i18n.translateKey("gui.statistics.button.items"));
        this.buttons.add(itemsButton);
        if (this.blockStatisticsList.getItemCount() == 0) {
            blocksButton.enabled = false;
        }
        if (this.itemStatisticsList.getItemCount() == 0) {
            itemsButton.enabled = false;
        }
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.mc.displayScreen(this.parent);
        } else if (button.id == 1) {
            this.selectionList = this.generalStatisticsList;
        } else if (button.id == 3) {
            this.selectionList = this.itemStatisticsList;
        } else if (button.id == 2) {
            this.selectionList = this.blockStatisticsList;
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        this.selectionList.render(mx, my, partialTick);
        this.drawStringCenteredShadow(this.fontRenderer, this.title, this.width / 2, 20, 0xFFFFFF);
        super.render(mx, my, partialTick);
    }

    private void renderItemAsIcon(int x, int y, int itemID) {
        this.renderBackgroundIcon(x + 1, y + 1);
        GL11.glEnable(32826);
        Lighting.enableInventoryLight();
        Item item = Item.itemsList[itemID];
        ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(item)).renderGui(Tessellator.instance, null, item.getDefaultStack(), x + 2, y + 2, 1.0f, 1.0f, 1.0f);
        Lighting.disable();
        GL11.glDisable(32826);
    }

    private void renderBackgroundIcon(int x, int y) {
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.drawGuiIcon(x, y, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/slot"));
    }

    class GeneralStatisticsList
    extends ScrolledSelectionList {
        public GeneralStatisticsList() {
            super(ScreenStats.this.mc, ScreenStats.this.width, ScreenStats.this.height, 32, ScreenStats.this.height - 64, 10);
            this.setRenderSelection(false);
        }

        @Override
        protected int getItemCount() {
            return StatList.basicStats.size();
        }

        @Override
        protected void selectItem(int itemIndex, boolean doubleClicked) {
        }

        @Override
        protected boolean isSelectedItem(int itemIndex) {
            return false;
        }

        @Override
        protected int getMaxPosition() {
            return this.getItemCount() * 10;
        }

        @Override
        protected void renderHoleBackground() {
            ScreenStats.this.renderBackground();
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            Stat stat = StatList.basicStats.get(index);
            ScreenStats.this.drawStringShadow(ScreenStats.this.fontRenderer, stat.getStatName(), x + 2, y + 1, index % 2 != 0 ? 0x909090 : 0xFFFFFF);
            String s = stat.getFormattedValue(ScreenStats.this.statsCounter.readStat(stat));
            ScreenStats.this.drawStringShadow(ScreenStats.this.fontRenderer, s, x + 2 + 213 - MathHelper.ceil(ScreenStats.this.fontRenderer.stringWidthDouble(s)), y + 1, index % 2 != 0 ? 0x909090 : 0xFFFFFF);
        }
    }

    public class ItemStatisticsList
    extends StatsSelectionList {
        public ItemStatisticsList() {
            this.statsList = new ArrayList();
            for (Stat stat : StatList.usedItemStats) {
                StatItem statItem = (StatItem)stat;
                boolean flag = false;
                int i = statItem.getItemID();
                Stat broken = statItem.getItem().getStat("stat_broken");
                Stat crafted = statItem.getItem().getStat("stat_crafted");
                if (ScreenStats.this.statsCounter.readStat(statItem) > 0) {
                    flag = true;
                } else if (broken != null && ScreenStats.this.statsCounter.readStat(broken) > 0) {
                    flag = true;
                } else if (crafted != null && ScreenStats.this.statsCounter.readStat(crafted) > 0) {
                    flag = true;
                }
                if (!flag) continue;
                this.statsList.add(statItem);
            }
            this.statsSorter = (stat1, stat2) -> {
                int id1 = stat1.getItemID();
                int id2 = stat2.getItemID();
                Stat statbase1 = null;
                Stat statbase2 = null;
                if (this.sortingColumn == 0) {
                    statbase1 = stat1.getItem().getStat("stat_broken");
                    statbase2 = stat2.getItem().getStat("stat_broken");
                } else if (this.sortingColumn == 1) {
                    statbase1 = stat1.getItem().getStat("stat_crafted");
                    statbase2 = stat2.getItem().getStat("stat_crafted");
                } else if (this.sortingColumn == 2) {
                    statbase1 = stat1.getItem().getStat("stat_used");
                    statbase2 = stat2.getItem().getStat("stat_used");
                }
                if (statbase1 != null || statbase2 != null) {
                    int l;
                    if (statbase1 == null) {
                        return 1;
                    }
                    if (statbase2 == null) {
                        return -1;
                    }
                    int k = ScreenStats.this.statsCounter.readStat(statbase1);
                    if (k != (l = ScreenStats.this.statsCounter.readStat(statbase2))) {
                        return (k - l) * this.sortingMode;
                    }
                }
                return id1 - id2;
            };
        }

        @Override
        protected void renderHeader(int x, int y, Tessellator tessellator) {
            super.renderHeader(x, y, tessellator);
            if (this.clickedColumn == 0) {
                ScreenStats.this.drawGuiIcon(x + 115 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/depleted"));
            } else {
                ScreenStats.this.drawGuiIcon(x + 115 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/depleted"));
            }
            if (this.clickedColumn == 1) {
                ScreenStats.this.drawGuiIcon(x + 165 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/crafted"));
            } else {
                ScreenStats.this.drawGuiIcon(x + 165 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/crafted"));
            }
            if (this.clickedColumn == 2) {
                ScreenStats.this.drawGuiIcon(x + 215 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/used"));
            } else {
                ScreenStats.this.drawGuiIcon(x + 215 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/used"));
            }
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            StatItem statItem = this.getStat(index);
            int i1 = statItem.getItemID();
            ScreenStats.this.renderItemAsIcon(x + 40, y, i1);
            this.renderStatValue((StatItem)statItem.getItem().getStat("stat_broken"), x + 115, y, index % 2 == 0);
            this.renderStatValue((StatItem)statItem.getItem().getStat("stat_crafted"), x + 165, y, index % 2 == 0);
            this.renderStatValue(statItem, x + 215, y, index % 2 == 0);
        }

        @Override
        protected String getTooltipKey(int column) {
            if (column == 1) {
                return "stat.crafted";
            }
            if (column == 2) {
                return "stat.used";
            }
            return "stat.depleted";
        }
    }

    public class BlockStatisticsList
    extends StatsSelectionList {
        public BlockStatisticsList() {
            this.statsList = new ArrayList();
            for (Stat stat : Objects.requireNonNull(Item.getStats("stat_mined"))) {
                StatItem statItem = (StatItem)stat;
                boolean flag = false;
                Stat used = statItem.getItem().getStat("stat_used");
                Stat crafted = statItem.getItem().getStat("stat_crafted");
                if (ScreenStats.this.statsCounter.readStat(statItem) > 0) {
                    flag = true;
                } else if (used != null && ScreenStats.this.statsCounter.readStat(used) > 0) {
                    flag = true;
                } else if (crafted != null && ScreenStats.this.statsCounter.readStat(crafted) > 0) {
                    flag = true;
                }
                if (!flag) continue;
                this.statsList.add(statItem);
            }
            this.statsSorter = (stat1, stat2) -> {
                int id1 = stat1.getItemID();
                int id2 = stat2.getItemID();
                Stat statbase1 = null;
                Stat statbase2 = null;
                if (this.sortingColumn == 2) {
                    statbase1 = stat1.getItem().getStat("stat_mined");
                    statbase2 = stat2.getItem().getStat("stat_mined");
                } else if (this.sortingColumn == 0) {
                    statbase1 = stat1.getItem().getStat("stat_crafted");
                    statbase2 = stat2.getItem().getStat("stat_crafted");
                } else if (this.sortingColumn == 1) {
                    statbase1 = stat1.getItem().getStat("stat_used");
                    statbase2 = stat2.getItem().getStat("stat_used");
                }
                if (statbase1 != null || statbase2 != null) {
                    int l;
                    if (statbase1 == null) {
                        return 1;
                    }
                    if (statbase2 == null) {
                        return -1;
                    }
                    int k = ScreenStats.this.statsCounter.readStat(statbase1);
                    if (k != (l = ScreenStats.this.statsCounter.readStat(statbase2))) {
                        return (k - l) * this.sortingMode;
                    }
                }
                return id1 - id2;
            };
        }

        @Override
        protected void renderHeader(int x, int y, Tessellator tessellator) {
            super.renderHeader(x, y, tessellator);
            if (this.clickedColumn == 0) {
                ScreenStats.this.drawGuiIcon(x + 115 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/crafted"));
            } else {
                ScreenStats.this.drawGuiIcon(x + 115 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/crafted"));
            }
            if (this.clickedColumn == 1) {
                ScreenStats.this.drawGuiIcon(x + 165 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/used"));
            } else {
                ScreenStats.this.drawGuiIcon(x + 165 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/used"));
            }
            if (this.clickedColumn == 2) {
                ScreenStats.this.drawGuiIcon(x + 215 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/mined"));
            } else {
                ScreenStats.this.drawGuiIcon(x + 215 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/mined"));
            }
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            StatItem statItem = this.getStat(index);
            int id = statItem.getItem().id;
            ScreenStats.this.renderItemAsIcon(x + 40, y, id);
            this.renderStatValue((StatItem)statItem.getItem().getStat("stat_crafted"), x + 115, y, index % 2 == 0);
            this.renderStatValue((StatItem)statItem.getItem().getStat("stat_used"), x + 165, y, index % 2 == 0);
            this.renderStatValue(statItem, x + 215, y, index % 2 == 0);
        }

        @Override
        protected String getTooltipKey(int column) {
            if (column == 0) {
                return "stat.crafted";
            }
            if (column == 1) {
                return "stat.used";
            }
            return "stat.mined";
        }
    }

    abstract class StatsSelectionList
    extends ScrolledSelectionList {
        protected int clickedColumn;
        protected List<StatItem> statsList;
        protected Comparator<StatItem> statsSorter;
        public int sortingColumn;
        public int sortingMode;

        protected StatsSelectionList() {
            super(ScreenStats.this.mc, ScreenStats.this.width, ScreenStats.this.height, 32, ScreenStats.this.height - 64, 20);
            this.clickedColumn = -1;
            this.sortingColumn = -1;
            this.sortingMode = 0;
            this.setRenderSelection(false);
            this.setRenderHeader(true, 20);
        }

        @Override
        protected void selectItem(int itemIndex, boolean doubleClicked) {
        }

        @Override
        protected boolean isSelectedItem(int itemIndex) {
            return false;
        }

        @Override
        protected void renderHoleBackground() {
            ScreenStats.this.renderBackground();
        }

        @Override
        protected void renderHeader(int x, int y, Tessellator tessellator) {
            if (!Mouse.isButtonDown(0)) {
                this.clickedColumn = -1;
            }
            if (this.clickedColumn == 0) {
                ScreenStats.this.drawGuiIcon(x + 115 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/slot"));
            } else {
                ScreenStats.this.drawGuiIcon(x + 115 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/slot_raised"));
            }
            if (this.clickedColumn == 1) {
                ScreenStats.this.drawGuiIcon(x + 165 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/slot"));
            } else {
                ScreenStats.this.drawGuiIcon(x + 165 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/slot_raised"));
            }
            if (this.clickedColumn == 2) {
                ScreenStats.this.drawGuiIcon(x + 215 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/slot"));
            } else {
                ScreenStats.this.drawGuiIcon(x + 215 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/slot_raised"));
            }
            if (this.sortingColumn != -1) {
                int c = 79;
                boolean up = false;
                if (this.sortingColumn == 1) {
                    c = 129;
                } else if (this.sortingColumn == 2) {
                    c = 179;
                }
                if (this.sortingMode == 1) {
                    up = true;
                }
                ScreenStats.this.drawGuiIcon(x + c, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/stats/arrow_" + (up ? "up" : "down")));
            }
        }

        @Override
        protected void clickedHeader(int x, int y) {
            this.clickedColumn = -1;
            if (x >= 79 && x < 115) {
                this.clickedColumn = 0;
            } else if (x >= 129 && x < 165) {
                this.clickedColumn = 1;
            } else if (x >= 179 && x < 215) {
                this.clickedColumn = 2;
            }
            if (this.clickedColumn >= 0) {
                this.clickedColumn(this.clickedColumn);
                ScreenStats.this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
            }
        }

        @Override
        protected final int getItemCount() {
            return this.statsList.size();
        }

        protected final StatItem getStat(int index) {
            return this.statsList.get(index);
        }

        protected abstract String getTooltipKey(int var1);

        protected void renderStatValue(StatItem statItem, int x, int y, boolean white) {
            if (statItem != null) {
                String s = statItem.getFormattedValue(ScreenStats.this.statsCounter.readStat(statItem));
                ScreenStats.this.drawStringShadow(ScreenStats.this.fontRenderer, s, x - MathHelper.ceil(ScreenStats.this.fontRenderer.stringWidthDouble(s)), y + 5, white ? 0xFFFFFF : 0x909090);
            } else {
                String s1 = "-";
                ScreenStats.this.drawStringShadow(ScreenStats.this.fontRenderer, s1, x - MathHelper.ceil(ScreenStats.this.fontRenderer.stringWidthDouble(s1)), y + 5, white ? 0xFFFFFF : 0x909090);
            }
        }

        @Override
        protected void renderDecorations(int x, int y) {
            GL11.glEnable(3553);
            GL11.glShadeModel(7424);
            GL11.glEnable(3008);
            if (y < this.y0 || y > this.y1) {
                return;
            }
            int row = this.getItemAtPosition(x, y);
            int statsListLeft = ScreenStats.this.width / 2 - 92 - 16;
            if (row >= 0) {
                if (x < statsListLeft + 40 || x > statsListLeft + 40 + 20) {
                    return;
                }
                StatItem statItem = this.getStat(row);
                this.renderStatItemTooltip(statItem, x, y);
            } else {
                String s;
                if (x >= statsListLeft + 115 - 18 && x <= statsListLeft + 115) {
                    s = this.getTooltipKey(0);
                } else if (x >= statsListLeft + 165 - 18 && x <= statsListLeft + 165) {
                    s = this.getTooltipKey(1);
                } else if (x >= statsListLeft + 215 - 18 && x <= statsListLeft + 215) {
                    s = this.getTooltipKey(2);
                } else {
                    return;
                }
                s = I18n.getInstance().translateKey(s).trim();
                ScreenStats.this.tooltip.render(s, x, y, 8, -8);
            }
        }

        protected void renderStatItemTooltip(StatItem statItem, int x, int y) {
            if (statItem == null) {
                return;
            }
            Item item = statItem.getItem();
            String s = I18n.getInstance().translateKey(item.getKey() + ".name").trim();
            ScreenStats.this.tooltip.render(s, x, y, 8, -8);
        }

        protected void clickedColumn(int column) {
            if (column != this.sortingColumn) {
                this.sortingColumn = column;
                this.sortingMode = -1;
            } else if (this.sortingMode == -1) {
                this.sortingMode = 1;
            } else {
                this.sortingColumn = -1;
                this.sortingMode = 0;
            }
            this.statsList.sort(this.statsSorter);
        }
    }
}

