/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.animal.MobSquid;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererSquid
extends MobRenderer<MobSquid> {
    public MobRendererSquid(float shadowSize) {
        super(shadowSize);
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull MobSquid entity, float brightness, float partialTick, int layer) {
        StaticEntityModel model = this.getModel("main");
        model.resetBones();
        float limbPitch = this.getLimbPitch(entity, partialTick);
        model.getTransform((String)"tentacle1").rotX = limbPitch;
        model.getTransform((String)"tentacle2").rotX = limbPitch;
        model.getTransform((String)"tentacle3").rotX = limbPitch;
        model.getTransform((String)"tentacle4").rotX = limbPitch;
        model.getTransform((String)"tentacle5").rotX = limbPitch;
        model.getTransform((String)"tentacle6").rotX = limbPitch;
        model.getTransform((String)"tentacle7").rotX = limbPitch;
        model.getTransform((String)"tentacle8").rotX = limbPitch;
        return model;
    }

    @Override
    protected float getLimbPitch(@NotNull MobSquid squid, float partialTick) {
        return MathHelper.lerp(squid.oldTentacleAngle, squid.tentacleAngle, partialTick);
    }

    @Override
    protected void preRenderTransform(@NotNull MobSquid entity, double x, double y, double z, float _yaw, float partialTick) {
        if (entity.isSpecial()) {
            GL11.glTranslated(0.0, 1.5, 0.0);
            super.preRenderTransform(entity, x, y, z, _yaw, partialTick);
        } else {
            GL11.glTranslated(x, y + 0.5, z);
            GL11.glScalef(0.0625f, 0.0625f, 0.0625f);
            float pitch = entity.xBodyRotO + (entity.xBodyRot - entity.xBodyRotO) * partialTick;
            float yaw = entity.zBodyRotO + (entity.zBodyRot - entity.zBodyRotO) * partialTick;
            GL11.glRotatef(180.0f - this.getBodyYaw(entity, partialTick) * MathHelper.RAD_TO_DEG, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(pitch, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(yaw, 0.0f, 1.0f, 0.0f);
        }
    }

    @Override
    public void renderPreview(@NotNull Tessellator tessellator, @NotNull MobSquid squid, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f, 1.25f, 0.0f);
        super.renderPreview(tessellator, squid, x, y, z, yaw, partialTick);
        GL11.glPopMatrix();
    }
}

