/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFlowerStackable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicFlower
extends BlockLogic
implements IBonemealable {
    public static final int MASK_PERMANENT = 128;
    public boolean killedByWeather = false;
    public boolean canBeBonemealed = false;

    public BlockLogicFlower(Block<?> block) {
        super(block, Material.plant);
        block.setTicking(true);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f * 3.0f, 0.5f + f);
    }

    public BlockLogicFlower setKilledByWeather() {
        this.killedByWeather = true;
        return this;
    }

    public BlockLogicFlower setBonemealable() {
        this.canBeBonemealed = true;
        return this;
    }

    @Override
    public int getPlacedBlockMetadata(@Nullable Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        return 128;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return super.canPlaceBlockAt(world, x, y, z) && this.mayPlaceOn(world.getBlockId(x, y - 1, z));
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    protected boolean mayPlaceOn(int blockId) {
        if (Blocks.blocksList[blockId] == null) {
            return false;
        }
        return Blocks.blocksList[blockId].hasTag(BlockTags.GROWS_FLOWERS);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        this.checkAlive(world, x, y, z);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand, boolean isRandomTick) {
        this.checkAlive(world, x, y, z);
        if (world.getGameRuleValue(GameRules.DO_SEASONAL_GROWTH).booleanValue() && world.getSeasonManager().getCurrentSeason() != null && !BlockLogicFlower.isPermanent(world.getBlockMetadata(x, y, z)) && world.getSeasonManager().getCurrentSeason().killFlowers && this.killedByWeather && rand.nextInt(256) == 0) {
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    protected final void checkAlive(World world, int x, int y, int z) {
        if (!this.canBlockStay(world, x, y, z)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        return (world.getFullBlockLightValue(x, y, z) >= 8 || world.canBlockSeeTheSky(x, y, z)) && this.mayPlaceOn(world.getBlockId(x, y - 1, z));
    }

    public static boolean isPermanent(int metadata) {
        return (metadata & 0x80) > 0;
    }

    public static int setPermanent(int metadata, boolean permanent) {
        return metadata & 0xFFFFFF7F | (permanent ? 128 : 0);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, @Nullable Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        Random rand = world.rand;
        if (!world.isClientSide && this.canBeBonemealed && itemstack.consumeItem(player)) {
            int meta;
            if (Block.hasLogicClass(world.getBlock(blockX, blockY, blockZ), BlockLogicFlowerStackable.class) && BlockLogicFlowerStackable.getStackCount(meta = world.getBlockMetadata(blockX, blockY, blockZ)) < 3) {
                world.setBlockMetadataWithNotify(blockX, blockY, blockZ, BlockLogicFlowerStackable.setStackCount(meta, BlockLogicFlowerStackable.getStackCount(meta) + 1));
            }
            System.out.printf("%s, %s, %s\n", blockX, blockY, blockZ);
            block0: for (int i = 0; i < 128; ++i) {
                int x = blockX;
                int y = blockY;
                int z = blockZ;
                for (int j = 0; j < i / 16; ++j) {
                    int blockId = world.getBlockId(x += rand.nextInt(3) - 1, (y += (rand.nextInt(3) - 1) * rand.nextInt(3) / 2) - 1, z += rand.nextInt(3) - 1);
                    if (!this.mayPlaceOn(blockId)) continue block0;
                }
                Block<?> b = world.getBlock(x, y, z);
                if (Block.hasLogicClass(b, BlockLogicFlowerStackable.class)) {
                    int meta2 = world.getBlockMetadata(x, y, z);
                    if (BlockLogicFlowerStackable.getStackCount(meta2) >= 3) continue;
                    world.setBlockMetadataWithNotify(x, y, z, BlockLogicFlowerStackable.setStackCount(meta2, BlockLogicFlowerStackable.getStackCount(meta2) + 1));
                    continue;
                }
                if (b != null || !((double)rand.nextFloat() > 0.75)) continue;
                world.setBlockWithNotify(x, y, z, this.block.id());
            }
            return true;
        }
        return this.canBeBonemealed;
    }
}

