/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.piston.BlockLogicPistonBase;
import net.minecraft.core.block.piston.BlockLogicPistonHead;
import net.minecraft.core.block.piston.BlockLogicPistonMoving;
import net.minecraft.core.block.piston.TileEntityMovingPistonBlock;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockLogicPistonBaseSteel
extends BlockLogicPistonBase {
    public static final double HEAD_THICKNESS_STEEL = 0.375;
    private Entity flungBlock = null;

    public BlockLogicPistonBaseSteel(Block<?> container, int maxPushedBlocks) {
        super(container, maxPushedBlocks);
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        int data = world.getBlockMetadata(x, y, z);
        if (BlockLogicPistonBaseSteel.isPowered(data)) {
            switch (BlockLogicPistonBaseSteel.getDirection(data)) {
                case DOWN: {
                    return AABB.fromPool(0.0, 0.375, 0.0, 1.0, 1.0, 1.0);
                }
                case UP: {
                    return AABB.fromPool(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
                }
                case NORTH: {
                    return AABB.fromPool(0.0, 0.0, 0.375, 1.0, 1.0, 1.0);
                }
                case SOUTH: {
                    return AABB.fromPool(0.0, 0.0, 0.0, 1.0, 1.0, 0.625);
                }
                case WEST: {
                    return AABB.fromPool(0.375, 0.0, 0.0, 1.0, 1.0, 1.0);
                }
            }
            return AABB.fromPool(0.0, 0.0, 0.0, 0.625, 1.0, 1.0);
        }
        return AABB.fromPool(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    protected boolean canPushLine(World world, int x, int y, int z, Direction direction, int maxPushedBlocks) {
        int blocks;
        int xo = x + direction.getOffsetX();
        int yo = y + direction.getOffsetY();
        int zo = z + direction.getOffsetZ();
        boolean didCrush = false;
        for (blocks = 0; blocks < maxPushedBlocks + 1; ++blocks) {
            if (yo < 0 || yo >= world.getHeightBlocks()) {
                return false;
            }
            int id = world.getBlockId(xo, yo, zo);
            if (id == 0) break;
            if (!this.isPushable(id, world, xo, yo, zo, true)) {
                if (blocks == 1 && BlockTags.PISTON_CRUSHING.appliesTo(Blocks.getBlock(id)) && this.tryCrush(world, x, y, z, direction)) {
                    didCrush = true;
                    break;
                }
                return false;
            }
            if (Blocks.blocksList[id].getPistonPushReaction(world, xo, yo, zo) == 1) break;
            if (blocks == maxPushedBlocks) {
                return false;
            }
            xo += direction.getOffsetX();
            yo += direction.getOffsetY();
            zo += direction.getOffsetZ();
        }
        if (!didCrush && blocks == 1) {
            xo = x + direction.getOffsetX();
            Block<?> block = world.getBlock(xo, yo = y + direction.getOffsetY(), zo = z + direction.getOffsetZ());
            if (block == null) {
                return true;
            }
            int blockMeta = world.getBlockMetadata(xo, yo, zo);
            TileEntity tileEntity = world.getTileEntity(xo, yo, zo);
            world.removeBlockTileEntity(xo, yo, zo);
            world.setBlockWithNotify(xo, yo, zo, 0);
            if (!world.isClientSide) {
                EntityFallingBlock entityFallingBlock = new EntityFallingBlock(world, (double)xo + 0.5, (double)yo + 0.5, (double)zo + 0.5, block.id(), blockMeta, tileEntity);
                entityFallingBlock.hasRemovedBlock = true;
                if (tileEntity instanceof IVehicle) {
                    Entity rider = ((IVehicle)((Object)tileEntity)).getPassenger();
                    ((IVehicle)((Object)tileEntity)).ejectRider();
                    if (rider != null) {
                        rider.startRiding(entityFallingBlock);
                    }
                }
                world.entityJoinedWorld(entityFallingBlock);
                double speed = 2.0;
                entityFallingBlock.fling((double)direction.getOffsetX() * 2.0, (double)direction.getOffsetY() * 2.0, (double)direction.getOffsetZ() * 2.0, 1.0f);
                this.flungBlock = entityFallingBlock;
            }
        }
        return true;
    }

    @Override
    public boolean tryCrush(World world, int x, int y, int z, Direction direction) {
        int z2;
        int y2;
        int x2 = x + direction.getOffsetX();
        Block<?> block = world.getBlock(x2, y2 = y + direction.getOffsetY(), z2 = z + direction.getOffsetZ());
        if (block == null) {
            return true;
        }
        world.playBlockEvent(null, 2001, x2, y2, z2, world.getBlockId(x2, y2, z2));
        block.dropBlockWithCause(world, EnumDropCause.PISTON_CRUSH, x2, y2, z2, world.getBlockMetadata(x2, y2, z2), null, null);
        world.setBlockWithNotify(x2, y2, z2, 0);
        return true;
    }

    @Override
    protected boolean tryExtend(World world, int x, int y, int z, Direction direction, int maxPushedBlocks) {
        if (world.isClientSide) {
            int blocks;
            int data = world.getBlockMetadata(x, y, z);
            int xo = x + direction.getOffsetX();
            int yo = y + direction.getOffsetY();
            int zo = z + direction.getOffsetZ();
            for (blocks = 0; blocks < maxPushedBlocks + 1; ++blocks) {
                if (yo < 0 || yo >= world.getHeightBlocks()) {
                    return false;
                }
                int blockId = world.getBlockId(xo, yo, zo);
                if (blockId == 0) break;
                if (!this.isPushable(blockId, world, xo, yo, zo, true)) {
                    return false;
                }
                if (Blocks.blocksList[blockId].getPistonPushReaction(world, xo, yo, zo) == 1) {
                    Blocks.blocksList[blockId].dropBlockWithCause(world, EnumDropCause.WORLD, xo, yo, zo, world.getBlockMetadata(xo, yo, zo), world.getTileEntity(xo, yo, zo), null);
                    break;
                }
                if (blocks == maxPushedBlocks) {
                    return false;
                }
                xo += direction.getOffsetX();
                yo += direction.getOffsetY();
                zo += direction.getOffsetZ();
            }
            if (blocks == 1) {
                while (xo != x || yo != y || zo != z) {
                    int px = xo - direction.getOffsetX();
                    int py = yo - direction.getOffsetY();
                    int pz = zo - direction.getOffsetZ();
                    int pushId = world.getBlockId(px, py, pz);
                    TileEntity pushEntity = world.getTileEntity(px, py, pz);
                    if (pushEntity instanceof TileEntityMovingPistonBlock && px == x && py == y && pz == z) break;
                    if (pushId == this.block.id() && px == x && py == y && pz == z) {
                        this.createPistonHeadAt(world, xo, yo, zo, data, direction);
                    }
                    if (px != x || py != y || pz != z) {
                        world.setBlockAndMetadataRaw(px, py, pz, 0, 0);
                    }
                    xo = px;
                    yo = py;
                    zo = pz;
                }
                return true;
            }
        }
        return super.tryExtend(world, x, y, z, direction, maxPushedBlocks);
    }

    @Override
    public void extendEvent(World world, int x, int y, int z, int data, Direction direction) {
        ArrayList<Entity> entityList = new ArrayList<Entity>(world.getEntitiesWithinAABBExcludingEntity(null, AABB.fromPool((double)x + (double)direction.getOffsetX(), (double)y + (double)direction.getOffsetY(), (double)z + (double)direction.getOffsetZ(), (double)x + (double)direction.getOffsetX() + 1.0, (double)y + (double)direction.getOffsetY() + 1.0, (double)z + (double)direction.getOffsetZ() + 1.0)));
        for (Entity entity : entityList) {
            if (entity == null || entity.noPhysics || entity == this.flungBlock || entity.world != null && entity.world.isClientSide && entity instanceof Player) continue;
            double speed = 2.0;
            entity.fling((double)direction.getOffsetX() * 2.0, (double)direction.getOffsetY() * 2.0, (double)direction.getOffsetZ() * 2.0, 1.0f);
        }
        this.flungBlock = null;
        super.extendEvent(world, x, y, z, data, direction);
    }

    @Override
    public void createPistonHeadAt(World world, int x, int y, int z, int data, Direction direction) {
        world.setBlockAndMetadata(x, y, z, Blocks.PISTON_MOVING.id(), BlockLogicPistonHead.setPistonType(2, direction.getId()));
        world.replaceBlockTileEntity(x, y, z, BlockLogicPistonMoving.createTileEntity(Blocks.PISTON_HEAD_STEEL.id(), BlockLogicPistonHead.setPistonType(2, direction.getId()), null, direction, true, false));
    }
}

