/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.CompoundTag;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.EntityPrimedTNT;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobButterfly;
import net.minecraft.core.entity.animal.MobChicken;
import net.minecraft.core.entity.animal.MobCow;
import net.minecraft.core.entity.animal.MobDeer;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.entity.animal.MobSquid;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.entity.factories.EntityDontUseFactory;
import net.minecraft.core.entity.factories.EntityFactory;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.entity.monster.MobGhast;
import net.minecraft.core.entity.monster.MobGiant;
import net.minecraft.core.entity.monster.MobHuman;
import net.minecraft.core.entity.monster.MobScorpion;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.monster.MobSlime;
import net.minecraft.core.entity.monster.MobSnowman;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.monster.MobZombieArmored;
import net.minecraft.core.entity.monster.MobZombiePig;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ProjectileArrow;
import net.minecraft.core.entity.projectile.ProjectileArrowGolden;
import net.minecraft.core.entity.projectile.ProjectileArrowPurple;
import net.minecraft.core.entity.projectile.ProjectileCannonball;
import net.minecraft.core.entity.projectile.ProjectileEgg;
import net.minecraft.core.entity.projectile.ProjectileFireball;
import net.minecraft.core.entity.projectile.ProjectilePebble;
import net.minecraft.core.entity.projectile.ProjectileSnowball;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class EntityDispatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private static final EntityDispatcher INSTANCE = new EntityDispatcher();
    private int mappingCount = 0;
    public final List<@NotNull EntityDispatcherEntry<?>> entries = new ArrayList();
    public final Map<@NotNull NamespaceID, @NotNull EntityDispatcherEntry<?>> idToEntryMap = new HashMap();
    public final Map<@NotNull String, @NotNull EntityDispatcherEntry<?>> stringIdToEntryMap = new HashMap();
    public final Map<@NotNull Class<?>, @NotNull EntityDispatcherEntry<?>> classToEntryMap = new HashMap();
    private final Int2ObjectMap<@NotNull EntityDispatcherEntry<?>> numericIdToEntryMap = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<@NotNull String> numericIdToStringIdMap = new Int2ObjectOpenHashMap<String>();
    public final EntityFactory<EntityItem> FACTORY_ITEM = this.addMapping(EntityItem.class, NamespaceID.fromPool("minecraft", "item"), EntityItem::new);
    public final EntityFactory<EntityPainting> FACTORY_PAINTING = this.addMapping(EntityPainting.class, NamespaceID.fromPool("minecraft", "painting"), EntityPainting::new);
    public final EntityFactory<EntityLightning> FACTORY_LIGHTNING = this.addMapping(EntityLightning.class, NamespaceID.fromPool("minecraft", "lightning"), EntityLightning::new);
    public final EntityFactory<EntityFallingBlock> FACTORY_FALLING_BLOCK = this.addMapping(EntityFallingBlock.class, NamespaceID.fromPool("minecraft", "falling_block"), EntityFallingBlock::new);
    public final EntityFactory<EntityMinecart> FACTORY_MINECART = this.addMapping(EntityMinecart.class, NamespaceID.fromPool("minecraft", "minecart"), EntityMinecart::new);
    public final EntityFactory<EntityBoat> FACTORY_BOAT = this.addMapping(EntityBoat.class, NamespaceID.fromPool("minecraft", "boat"), EntityBoat::new);
    public final EntityFactory<EntityPrimedTNT> FACTORY_PRIMED_TNT = this.addMapping(EntityPrimedTNT.class, NamespaceID.fromPool("minecraft", "primed_tnt"), EntityPrimedTNT::new);
    public final EntityFactory<ProjectilePebble> FACTORY_PROJECTILE_PEBBLE = this.addMapping(ProjectilePebble.class, NamespaceID.fromPool("minecraft", "pebble"), ProjectilePebble::new);
    public final EntityFactory<ProjectileEgg> FACTORY_PROJECTILE_EGG = this.addMapping(ProjectileEgg.class, NamespaceID.fromPool("minecraft", "egg"), ProjectileEgg::new);
    public final EntityFactory<ProjectileArrow> FACTORY_PROJECTILE_ARROW = this.addMapping(ProjectileArrow.class, NamespaceID.fromPool("minecraft", "arrow"), ProjectileArrow::new);
    public final EntityFactory<ProjectileArrowGolden> FACTORY_PROJECTILE_ARROW_GOLDEN = this.addMapping(ProjectileArrowGolden.class, NamespaceID.fromPool("minecraft", "arrow_golden"), ProjectileArrowGolden::new);
    public final EntityFactory<ProjectileArrowPurple> FACTORY_PROJECTILE_ARROW_PURPLE = this.addMapping(ProjectileArrowPurple.class, NamespaceID.fromPool("minecraft", "arrow_purple"), ProjectileArrowPurple::new);
    public final EntityFactory<ProjectileSnowball> FACTORY_PROJECTILE_SNOWBALL = this.addMapping(ProjectileSnowball.class, NamespaceID.fromPool("minecraft", "snowball"), ProjectileSnowball::new);
    public final EntityFactory<ProjectileFireball> FACTORY_PROJECTILE_FIREBALL = this.addMapping(ProjectileFireball.class, NamespaceID.fromPool("minecraft", "fireball"), ProjectileFireball::new);
    public final EntityFactory<ProjectileCannonball> FACTORY_PROJECTILE_CANNONBALL = this.addMapping(ProjectileCannonball.class, NamespaceID.fromPool("minecraft", "cannonball"), ProjectileCannonball::new);
    public final EntityFactory<Mob> FACTORY_MOB = this.addMapping(Mob.class, NamespaceID.fromPool("minecraft", "mob"), new EntityDontUseFactory());
    public final EntityFactory<MobHuman> FACTORY_HUMAN = this.addMapping(MobHuman.class, NamespaceID.fromPool("minecraft", "human"), MobHuman::new);
    public final EntityFactory<Player> FACTORY_PLAYER = this.addMapping(Player.class, NamespaceID.fromPool("minecraft", "player"), new EntityDontUseFactory());
    public final EntityFactory<MobZombie> FACTORY_ZOMBIE = this.addMapping(MobZombie.class, NamespaceID.fromPool("minecraft", "zombie"), MobZombie::new, "guidebook.section.mob.zombie.name");
    public final EntityFactory<MobZombieArmored> FACTORY_ZOMBIE_ARMORED = this.addMapping(MobZombieArmored.class, NamespaceID.fromPool("minecraft", "zombie_armored"), MobZombieArmored::new, "guidebook.section.mob.armored_zombie.name");
    public final EntityFactory<MobZombiePig> FACTORY_ZOMBIE_PIG = this.addMapping(MobZombiePig.class, NamespaceID.fromPool("minecraft", "zombie_pigman"), MobZombiePig::new, "guidebook.section.mob.zombie_pigman.name");
    public final EntityFactory<MobCreeper> FACTORY_CREEPER = this.addMapping(MobCreeper.class, NamespaceID.fromPool("minecraft", "creeper"), MobCreeper::new, "guidebook.section.mob.creeper.name");
    public final EntityFactory<MobSkeleton> FACTORY_SKELETON = this.addMapping(MobSkeleton.class, NamespaceID.fromPool("minecraft", "skeleton"), MobSkeleton::new, "guidebook.section.mob.skeleton.name");
    public final EntityFactory<MobSpider> FACTORY_SPIDER = this.addMapping(MobSpider.class, NamespaceID.fromPool("minecraft", "spider"), MobSpider::new, "guidebook.section.mob.spider.name");
    public final EntityFactory<MobGiant> FACTORY_GIANT = this.addMapping(MobGiant.class, NamespaceID.fromPool("minecraft", "giant"), MobGiant::new);
    public final EntityFactory<MobSlime> FACTORY_SLIME = this.addMapping(MobSlime.class, NamespaceID.fromPool("minecraft", "slime"), MobSlime::new, "guidebook.section.mob.slime.name");
    public final EntityFactory<MobGhast> FACTORY_GHAST = this.addMapping(MobGhast.class, NamespaceID.fromPool("minecraft", "ghast"), MobGhast::new, "guidebook.section.mob.ghast.name");
    public final EntityFactory<MobSnowman> FACTORY_SNOWMAN = this.addMapping(MobSnowman.class, NamespaceID.fromPool("minecraft", "snowman"), MobSnowman::new, "guidebook.section.mob.snowman.name");
    public final EntityFactory<MobScorpion> FACTORY_SCORPION = this.addMapping(MobScorpion.class, NamespaceID.fromPool("minecraft", "scorpion"), MobScorpion::new);
    public final EntityFactory<MobPig> FACTORY_PIG = this.addMapping(MobPig.class, NamespaceID.fromPool("minecraft", "pig"), MobPig::new, "guidebook.section.mob.pig.name");
    public final EntityFactory<MobSheep> FACTORY_SHEEP = this.addMapping(MobSheep.class, NamespaceID.fromPool("minecraft", "sheep"), MobSheep::new, "guidebook.section.mob.sheep.name");
    public final EntityFactory<MobCow> FACTORY_COW = this.addMapping(MobCow.class, NamespaceID.fromPool("minecraft", "cow"), MobCow::new, "guidebook.section.mob.cow.name");
    public final EntityFactory<MobChicken> FACTORY_CHICKEN = this.addMapping(MobChicken.class, NamespaceID.fromPool("minecraft", "chicken"), MobChicken::new, "guidebook.section.mob.chicken.name");
    public final EntityFactory<MobSquid> FACTORY_SQUID = this.addMapping(MobSquid.class, NamespaceID.fromPool("minecraft", "squid"), MobSquid::new, "guidebook.section.mob.squid.name");
    public final EntityFactory<MobWolf> FACTORY_WOLF = this.addMapping(MobWolf.class, NamespaceID.fromPool("minecraft", "wolf"), MobWolf::new, "guidebook.section.mob.wolf.name");
    public final EntityFactory<MobFireflyCluster> FACTORY_FIREFLY_CLUSTER = this.addMapping(MobFireflyCluster.class, NamespaceID.fromPool("minecraft", "firefly_cluster"), MobFireflyCluster::new, "guidebook.section.mob.firefly_cluster.name");
    public final EntityFactory<MobButterfly> FACTORY_BUTTERFLY = this.addMapping(MobButterfly.class, NamespaceID.fromPool("minecraft", "butterfly"), MobButterfly::new, "guidebook.section.mob.butterfly.name");
    public final EntityFactory<MobDeer> FACTORY_DEER = this.addMapping(MobDeer.class, NamespaceID.fromPool("minecraft", "deer"), MobDeer::new, "guidebook.section.mob.deer.name");

    @NotNull
    public static EntityDispatcher getInstance() {
        return INSTANCE;
    }

    private EntityDispatcher() {
    }

    @NotNull
    public <T extends Entity> EntityFactory<T> addMapping(@NotNull Class<T> entityClass, @NotNull NamespaceID namespaceID, @NotNull EntityFactory<T> factory) {
        return this.addMapping(entityClass, namespaceID, factory, null);
    }

    @NotNull
    public <T extends Entity> EntityFactory<T> addMapping(@NotNull Class<T> entityClass, @NotNull NamespaceID namespaceID, @NotNull EntityFactory<T> factory, @Nullable String nameKey) {
        if (this.classToEntryMap.containsKey(entityClass)) {
            throw new IllegalArgumentException("EntityDispatcher already contains an assignment for class " + entityClass.getSimpleName() + " with namespace " + this.classToEntryMap.get(entityClass).namespaceID + "!");
        }
        @NotNull NamespaceID unpooledNamespaceID = (NamespaceID)namespaceID.copyUnpooled();
        int numericId = this.mappingCount++;
        EntityDispatcherEntry<T> entry = new EntityDispatcherEntry<T>(namespaceID, numericId, entityClass, factory, nameKey);
        this.entries.add(entry);
        this.idToEntryMap.put(entry.namespaceID, entry);
        this.stringIdToEntryMap.put(entry.stringID, entry);
        this.classToEntryMap.put(entry.entityClass, entry);
        this.numericIdToEntryMap.put(entry.numericID, (EntityDispatcherEntry<?>)entry);
        this.numericIdToStringIdMap.put(entry.numericID, entry.stringID);
        return factory;
    }

    public void setNumericIds(@NotNull Int2ObjectMap<String> mapping) {
        this.numericIdToEntryMap.clear();
        this.numericIdToStringIdMap.clear();
        for (Int2ObjectMap.Entry entry : mapping.int2ObjectEntrySet()) {
            EntityDispatcherEntry<?> e = this.stringIdToEntryMap.get(entry.getValue());
            if (e == null) {
                LOGGER.error("Could not find entity dispatcher entry assigned to namespace id {}! Skipping!", entry.getValue());
                continue;
            }
            e.updateID(entry.getIntKey());
            this.numericIdToEntryMap.put(entry.getIntKey(), e);
            this.numericIdToStringIdMap.put(entry.getIntKey(), (String)entry.getValue());
            if (entry.getIntKey() < this.mappingCount) continue;
            this.mappingCount = entry.getIntKey() + 1;
        }
    }

    @Nullable
    public EntityDispatcherEntry<?> entryForId(@NotNull NamespaceID id) {
        return this.idToEntryMap.get(id);
    }

    @Nullable
    public EntityDispatcherEntry<?> entryForId(@NotNull String id) {
        return this.stringIdToEntryMap.get(id);
    }

    @Nullable
    public EntityDispatcherEntry<?> entryForNumericId(int id) {
        return (EntityDispatcherEntry)this.numericIdToEntryMap.get(id);
    }

    @Nullable
    public <T extends Entity> EntityDispatcherEntry<T> entryForClass(@Nullable Class<T> entityClass) {
        return this.classToEntryMap.get(entityClass);
    }

    @NotNull
    public Int2ObjectMap<String> getEntityIds() {
        return this.numericIdToStringIdMap;
    }

    @Nullable
    public Entity createEntityInWorld(@Nullable String id, @NotNull World world) {
        if (id == null) {
            return null;
        }
        if (Legacy.isLegacyKey(id)) {
            EntityDispatcherEntry<? extends Entity> entry = this.entryForClass(Legacy.getClassFromEncodeID(id));
            if (entry != null) {
                return entry.factory.createEntity(world);
            }
            LOGGER.warn("EntityDispatcher could not find entity class for id '{}'!", (Object)id);
            return null;
        }
        EntityDispatcherEntry<?> entry = this.entryForId(id);
        if (entry != null) {
            return entry.factory.createEntity(world);
        }
        LOGGER.warn("EntityDispatcher could not find entity class for id '{}'!", (Object)id);
        return null;
    }

    @Nullable
    public Entity createEntityInWorld(@NotNull NamespaceID id, @NotNull World world) {
        EntityDispatcherEntry<?> entry = this.entryForId(id);
        if (entry != null) {
            return entry.factory.createEntity(world);
        }
        LOGGER.warn("EntityDispatcher could not find entity class for id '{}'!", (Object)id);
        return null;
    }

    @Nullable
    public <T extends Entity> T createEntityInWorld(@NotNull Class<T> entityClass, @NotNull World world) {
        EntityDispatcherEntry<T> entry = this.entryForClass(entityClass);
        if (entry != null) {
            return entry.factory.createEntity(world);
        }
        LOGGER.warn("EntityDispatcher could not find entity class for class '{}'!", (Object)entityClass.getSimpleName());
        return null;
    }

    @Nullable
    public Entity createEntityFromNBT(@NotNull CompoundTag compoundTag, @NotNull World world) {
        String id = compoundTag.getStringOrDefault("id", "UNKNOWN");
        Entity entity = this.createEntityInWorld(id, world);
        if (entity != null) {
            entity.load(compoundTag);
        } else {
            LOGGER.warn("Skipping Entity with id {}", (Object)compoundTag.getStringOrDefault("id", "UNKNOWN"));
        }
        return entity;
    }

    @Nullable
    public Entity createEntity(int id, @NotNull World world) {
        EntityDispatcherEntry<?> entry = this.entryForNumericId(id);
        if (entry != null) {
            return entry.factory.createEntity(world);
        }
        LOGGER.error("No entity class assign to id {}!", (Object)id);
        return null;
    }

    public static void init() {
    }

    public static class EntityDispatcherEntry<T extends Entity> {
        @NotNull
        public final NamespaceID namespaceID;
        @NotNull
        public final String stringID;
        public int numericID;
        @NotNull
        public final EntityFactory<T> factory;
        @NotNull
        public final Class<T> entityClass;
        @Nullable
        public final String nameKey;

        public EntityDispatcherEntry(@NotNull NamespaceID namespaceID, int numericID, @NotNull Class<T> entityClass, @NotNull EntityFactory<T> factory, @Nullable String nameKey) {
            this.namespaceID = namespaceID;
            this.stringID = namespaceID.toString();
            this.numericID = numericID;
            this.factory = factory;
            this.entityClass = entityClass;
            this.nameKey = nameKey;
        }

        public void updateID(int newNumericID) {
            this.numericID = newNumericID;
        }
    }

    @Deprecated
    public static class Legacy {
        public static final Map<String, Class<? extends Entity>> keyToClassMap = new HashMap<String, Class<? extends Entity>>();
        public static final Map<Class<? extends Entity>, String> classToKeyMap = new HashMap<Class<? extends Entity>, String>();
        private static final Int2ObjectMap<Class<? extends Entity>> idToClassMap = new Int2ObjectArrayMap<Class<? extends Entity>>();
        private static final Object2IntMap<Class<? extends Entity>> classToIdMap = new Object2IntArrayMap<Class<? extends Entity>>();
        private static int maxIdSize = 0;

        @Deprecated
        public static void addMapping(Class<? extends Entity> clazz, String key, int id) {
            keyToClassMap.put(key, clazz);
            classToKeyMap.put(clazz, key);
            idToClassMap.put(id, clazz);
            classToIdMap.put(clazz, id);
            if (key.length() > maxIdSize) {
                maxIdSize = key.length();
            }
        }

        @Deprecated
        public static int getEntityID(Entity entity) {
            return Legacy.getEntityID(entity.getClass());
        }

        @Deprecated
        public static int getEntityID(Class<? extends Entity> entityClass) {
            return classToIdMap.get(entityClass);
        }

        @Deprecated
        public static String getEncodeId(Entity entity) {
            return classToKeyMap.get(entity.getClass());
        }

        @Deprecated
        public static String getEncodeId(Class<? extends Entity> clazz) {
            return classToKeyMap.get(clazz);
        }

        @Deprecated
        public static Class<? extends Entity> getClassFromID(int id) {
            return (Class)idToClassMap.get(id);
        }

        @Deprecated
        public static Class<? extends Entity> getClassFromEncodeID(String encodeID) {
            return keyToClassMap.get(encodeID);
        }

        @Deprecated
        public static int getLargestIdSize() {
            return maxIdSize;
        }

        public static boolean isLegacyKey(String key) {
            return keyToClassMap.containsKey(key);
        }

        static {
            Legacy.addMapping(EntityItem.class, "Item", 1);
            Legacy.addMapping(EntityLightning.class, "Lightning", 8);
            Legacy.addMapping(EntityPainting.class, "Painting", 9);
            Legacy.addMapping(ProjectileArrow.class, "Arrow", 10);
            Legacy.addMapping(ProjectileSnowball.class, "Snowball", 11);
            Legacy.addMapping(ProjectileFireball.class, "Fireball", 12);
            Legacy.addMapping(EntityPrimedTNT.class, "PrimedTnt", 20);
            Legacy.addMapping(EntityFallingBlock.class, "FallingSand", 21);
            Legacy.addMapping(EntityMinecart.class, "Minecart", 40);
            Legacy.addMapping(EntityBoat.class, "Boat", 41);
            Legacy.addMapping(MobZombieArmored.class, "ArmouredZombie", 42);
            Legacy.addMapping(ProjectileArrowGolden.class, "ArrowGolden", 43);
            Legacy.addMapping(ProjectileCannonball.class, "Cannonball", 44);
            Legacy.addMapping(ProjectileArrowPurple.class, "ArrowPurple", 45);
            Legacy.addMapping(ProjectilePebble.class, "Pebble", 46);
            Legacy.addMapping(MobFireflyCluster.class, "FireflyCluster", 47);
            Legacy.addMapping(Mob.class, "Mob", 48);
            Legacy.addMapping(MobHuman.class, "MobMonster", 49);
            Legacy.addMapping(MobCreeper.class, "Creeper", 50);
            Legacy.addMapping(MobSkeleton.class, "Skeleton", 51);
            Legacy.addMapping(MobSpider.class, "Spider", 52);
            Legacy.addMapping(MobGiant.class, "Giant", 53);
            Legacy.addMapping(MobZombie.class, "Zombie", 54);
            Legacy.addMapping(MobSlime.class, "Slime", 55);
            Legacy.addMapping(MobGhast.class, "Ghast", 56);
            Legacy.addMapping(MobZombiePig.class, "PigZombie", 57);
            Legacy.addMapping(MobSnowman.class, "Snowman", 58);
            Legacy.addMapping(MobScorpion.class, "Scorpion", 59);
            Legacy.addMapping(MobPig.class, "Pig", 90);
            Legacy.addMapping(MobSheep.class, "Sheep", 91);
            Legacy.addMapping(MobCow.class, "Cow", 92);
            Legacy.addMapping(MobChicken.class, "Chicken", 93);
            Legacy.addMapping(MobSquid.class, "Squid", 94);
            Legacy.addMapping(MobWolf.class, "Wolf", 95);
        }
    }
}

