/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import com.mojang.nbt.tags.CompoundTag;
import java.util.function.Function;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemWandNBT
extends Item {
    public ItemWandNBT(String translationKey, String namespaceId, int id) {
        super(translationKey, namespaceId, id);
    }

    @Override
    public ItemStack onInventoryInteract(Player player, final Slot slot, ItemStack stackInSlot, boolean isItemGrabbed) {
        if (slot.getItemStack() != null) {
            player.displayNBTEditor(slot.getItemStack().writeToNBT(new CompoundTag()), new Function<CompoundTag, Void>(){

                @Override
                public Void apply(CompoundTag tag) {
                    slot.getItemStack().readFromNBT(tag);
                    return null;
                }
            });
        }
        return stackInSlot;
    }

    @Override
    public boolean hasInventoryInteraction() {
        return true;
    }

    @Override
    public boolean onUseItemOnBlock(@NotNull ItemStack itemstack, @Nullable Player player, @NotNull World world, int blockX, int blockY, int blockZ, @NotNull Side side, double xPlaced, double yPlaced) {
        final TileEntity te = world.getTileEntity(blockX, blockY, blockZ);
        if (te != null) {
            CompoundTag tag = new CompoundTag();
            te.writeToNBT(tag);
            player.displayNBTEditor(tag, new Function<CompoundTag, Void>(){

                @Override
                public Void apply(CompoundTag tag) {
                    te.readAdditionalData(tag);
                    return null;
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean useItemOnEntity(ItemStack itemstack, final Mob mob, Player player) {
        CompoundTag tag = new CompoundTag();
        mob.save(tag);
        player.displayNBTEditor(tag, new Function<CompoundTag, Void>(){

            @Override
            public Void apply(CompoundTag tag) {
                mob.load(tag);
                return null;
            }
        });
        return true;
    }
}

