/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.generate.LargeFeature;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;

public class NetherBonesLargeFeature
extends LargeFeature {
    private final int minY;
    private final int maxY;

    public NetherBonesLargeFeature() {
        this.minY = 0;
        this.maxY = 256;
    }

    public NetherBonesLargeFeature(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
    }

    protected void generateHubRoom(long seed, int baseChunkX, int baseChunkZ, ChunkGeneratorResult result, double blockX, double blockY, double blockZ) {
        this.generateCave(seed, baseChunkX, baseChunkZ, result, blockX, blockY, blockZ, 1.0f + rand.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    protected void generateCave(long seed, int baseChunkX, int baseChunkZ, ChunkGeneratorResult result, double blockX, double blockY, double blockZ, float initialRadius, float yRot, float xRot, int startPos, int endPos, double heightMod) {
        double chunkMiddleX = baseChunkX * 16 + 8;
        double chunkMiddleZ = baseChunkZ * 16 + 8;
        float rotHorOffset = 0.0f;
        float rotVerOffset = 0.0f;
        Random random = new Random(seed);
        if (endPos <= 0) {
            int maxLength = this.radiusChunk * 16 - 16;
            endPos = maxLength - random.nextInt(maxLength / 4);
        }
        boolean noBranches = false;
        if (startPos == -1) {
            startPos = endPos / 2;
            noBranches = true;
        }
        boolean reversed = random.nextBoolean();
        int branchPos = random.nextInt(endPos / 2) + endPos / 4;
        while (startPos < endPos) {
            double width = 1.5 + (double)(MathHelper.sin((float)startPos * (float)Math.PI / (float)endPos) * initialRadius * 1.0f);
            double height = width * heightMod;
            float xzScale = MathHelper.cos(xRot);
            float xOffset = MathHelper.sin(xRot);
            blockX += (double)xOffset;
            blockY -= (double)(MathHelper.cos(yRot) * xzScale);
            blockZ = reversed ? (blockZ -= (double)(MathHelper.sin(yRot) * xzScale)) : (blockZ += (double)(MathHelper.sin(yRot) * xzScale));
            yRot *= 0.92f;
            xRot += rotVerOffset * 0.1f;
            yRot += rotHorOffset * 0.1f;
            rotVerOffset *= 0.75f;
            rotHorOffset *= 0.9f;
            double dxFromMiddle = blockX - chunkMiddleX;
            double dzFromMiddle = blockZ - chunkMiddleZ;
            double length = endPos - startPos;
            double maxRadius = initialRadius + 2.0f + 16.0f;
            if (dxFromMiddle * dxFromMiddle + dzFromMiddle * dzFromMiddle - length * length > maxRadius * maxRadius) {
                return;
            }
            if (!(blockX < chunkMiddleX - 16.0 - width * 2.0 || blockZ < chunkMiddleZ - 16.0 - width * 2.0 || blockX > chunkMiddleX + 16.0 + width * 2.0 || blockZ > chunkMiddleZ + 16.0 + width * 2.0)) {
                int minX = MathHelper.floor(blockX - width) - baseChunkX * 16 - 1;
                int maxX = MathHelper.floor(blockX + width) - baseChunkX * 16 + 1;
                int minY = MathHelper.floor(blockY - height) - 1;
                int maxY = MathHelper.floor(blockY + height) + 1;
                int minZ = MathHelper.floor(blockZ - width) - baseChunkZ * 16 - 1;
                int maxZ = MathHelper.floor(blockZ + width) - baseChunkZ * 16 + 1;
                if (minX < 0) {
                    minX = 0;
                }
                if (maxX > 16) {
                    maxX = 16;
                }
                if (minY < this.minY + 1) {
                    minY = this.minY + 1;
                }
                if (maxY > this.maxY - 8) {
                    maxY = this.maxY - 8;
                }
                if (minZ < 0) {
                    minZ = 0;
                }
                if (maxZ > 16) {
                    maxZ = 16;
                }
                for (int x = minX; x < maxX; ++x) {
                    double xPercentage = ((double)(x + baseChunkX * 16) + 0.5 - blockX) / width;
                    for (int z = minZ; z < maxZ; ++z) {
                        double zPercentage = ((double)(z + baseChunkZ * 16) + 0.5 - blockZ) / width;
                        int yIndex = maxY;
                        if (xPercentage * xPercentage + zPercentage * zPercentage >= 1.0) continue;
                        for (int y = maxY - 1; y >= minY; --y) {
                            int blockId;
                            double yPercentage = ((double)y + 0.5 - blockY) / height;
                            if (yPercentage > -0.7 && xPercentage * xPercentage + yPercentage * yPercentage + zPercentage * zPercentage < 1.0 && (blockId = result.getBlock(x, yIndex, z)) == 0) {
                                result.setBlock(x, yIndex, z, Blocks.BONESHALE.id());
                            }
                            --yIndex;
                        }
                    }
                }
                if (noBranches) break;
            }
            ++startPos;
        }
    }

    @Override
    protected void doGeneration(World world, int chunkX, int chunkZ, int baseChunkX, int baseChunkZ, ChunkGeneratorResult result) {
        if (world.getBlockBiome(chunkX * 16, 0, chunkZ * 16) != Biomes.NETHER_BONEYARD) {
            return;
        }
        int cavesToGenerate = rand.nextInt(rand.nextInt(rand.nextInt(10) + 1) + 1);
        int yRange = this.maxY - this.minY;
        for (int i = 0; i < cavesToGenerate; ++i) {
            double blockX = chunkX * 16 + rand.nextInt(16);
            double blockY = this.minY + rand.nextInt(rand.nextInt(yRange - 8) + 8);
            double blockZ = chunkZ * 16 + rand.nextInt(16);
            float yRot = rand.nextFloat() * (float)Math.PI * 2.0f;
            float xRot = (rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
            float initialRadius = rand.nextFloat() + rand.nextFloat();
            this.generateCave(rand.nextLong(), baseChunkX, baseChunkZ, result, blockX, blockY, blockZ, initialRadius, yRot, xRot, 0, 0, 1.0);
        }
    }
}

