/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenConnecting;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.ServerAddress;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;

public class ScreenConnectToIp
extends Screen {
    private TextFieldElement textField;

    public ScreenConnectToIp(Screen parent) {
        super(parent);
    }

    @Override
    public void tick() {
        this.textField.updateCursorCounter();
    }

    @Override
    public void init() {
        I18n stringtranslate = I18n.getInstance();
        Keyboard.enableRepeatEvents(true);
        this.buttons.clear();
        this.buttons.add(new ButtonElement(0, this.width / 2 - 100, this.height / 4 + 96 + 12, stringtranslate.translateKey("gui.connect_to_ip.button.connect")));
        this.buttons.add(new ButtonElement(1, this.width / 2 - 100, this.height / 4 + 120 + 12, stringtranslate.translateKey("gui.connect_to_ip.button.cancel")));
        String s = ((String)this.mc.gameSettings.lastServer.value).replaceAll("_", ":");
        ((ButtonElement)this.buttons.get((int)0)).enabled = s.length() > 0;
        this.textField = new TextFieldElement(this, this.fontRenderer, this.width / 2 - 100, this.height / 4 - 10 + 50 + 18, 200, 20, s, "");
        this.textField.isFocused = true;
        this.textField.setMaxStringLength(128);
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents(false);
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 1) {
            this.mc.displayScreen(this.parentScreen);
        } else if (button.id == 0) {
            String serverUrl = this.textField.getText().trim();
            this.mc.gameSettings.lastServer.value = serverUrl.replaceAll(":", "_");
            this.mc.gameSettings.saveOptions();
            ServerAddress address = ServerAddress.resolveServerIP(serverUrl);
            this.mc.displayScreen(new ScreenConnecting(this.mc, address.getIP(), address.getPort()));
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey != Keyboard.KEY_BACK) {
            super.keyPressed(eventCharacter, eventKey, mx, my);
        }
        this.textField.textboxKeyTyped(eventCharacter, eventKey);
        if (eventCharacter == '\r') {
            this.buttonClicked((ButtonElement)this.buttons.get(0));
        }
        ((ButtonElement)this.buttons.get((int)0)).enabled = this.textField.getText().length() > 0;
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        this.textField.mouseClicked(mx, my, buttonNum);
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        I18n i18n = I18n.getInstance();
        this.renderBackground();
        this.drawStringCenteredShadow(this.fontRenderer, i18n.translateKey("gui.connect_to_ip.label.title"), this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawStringShadow(this.fontRenderer, i18n.translateKey("gui.connect_to_ip.label.enter_ip"), this.width / 2 - 140, this.height / 4 - 60 + 60 + 36, 0xA0A0A0);
        this.textField.drawTextBox();
        this.textField.updateCursor(this.mc, mx, my);
        super.render(mx, my, partialTick);
    }
}

