/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.animal.MobCow;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBucketEmpty
extends Item {
    public ItemBucketEmpty(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 64;
    }

    @Override
    @Nullable
    public ItemStack onUseItem(@NotNull ItemStack itemstack, @NotNull World world, @NotNull Player entityplayer) {
        double reachDistance = entityplayer.getGamemode().getBlockReachDistance();
        HitResult hitResult = entityplayer.rayTrace(reachDistance, 1.0f, true, false, false);
        if (hitResult == null) {
            return itemstack;
        }
        if (hitResult.hitType == HitResult.HitType.TILE) {
            int i = hitResult.x;
            int j = hitResult.y;
            int k = hitResult.z;
            if (!world.canMineBlock(entityplayer, i, j, k)) {
                return itemstack;
            }
            if (world.getBlockMaterial(i, j, k) == Material.water && world.getBlockMetadata(i, j, k) == 0) {
                if (ItemBucketEmpty.useBucket(entityplayer, new ItemStack(Items.BUCKET_WATER))) {
                    world.setBlockWithNotify(i, j, k, 0);
                    entityplayer.swingItem();
                }
            } else if (world.getBlockMaterial(i, j, k) == Material.lava && world.getBlockMetadata(i, j, k) == 0 && ItemBucketEmpty.useBucket(entityplayer, new ItemStack(Items.BUCKET_LAVA))) {
                world.setBlockWithNotify(i, j, k, 0);
                entityplayer.swingItem();
            }
        }
        return itemstack;
    }

    @Override
    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        int z;
        int y;
        if (itemStack.stackSize > 1) {
            return;
        }
        int x = blockX + direction.getOffsetX();
        if (world.getBlockMaterial(x, y = blockY + direction.getOffsetY(), z = blockZ + direction.getOffsetZ()) == Material.water && world.getBlockMetadata(x, y, z) == 0) {
            world.setBlockWithNotify(x, y, z, 0);
            itemStack.itemID = Items.BUCKET_WATER.id;
            return;
        }
        if (world.getBlockMaterial(x, y, z) == Material.lava && world.getBlockMetadata(x, y, z) == 0) {
            world.setBlockWithNotify(x, y, z, 0);
            itemStack.itemID = Items.BUCKET_LAVA.id;
            return;
        }
        AABB box = AABB.fromPool(x, y, z, x + 1, y + 1, z + 1);
        List<MobCow> entities = world.getEntitiesWithinAABB(MobCow.class, box);
        if (!entities.isEmpty()) {
            itemStack.itemID = Items.BUCKET_MILK.id;
            return;
        }
    }

    public static boolean useBucket(Player player, ItemStack itemToGive) {
        if (player.inventory.getCurrentItem().stackSize <= 1) {
            player.inventory.setItem(player.inventory.getCurrentItemIndex(), itemToGive);
            return true;
        }
        player.inventory.insertItem(itemToGive, true);
        if (itemToGive.stackSize < 1) {
            player.inventory.getCurrentItem().consumeItem(player);
            return true;
        }
        return false;
    }
}

