/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import java.util.List;
import net.minecraft.client.render.font.Alignment;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.font.RenderDoubleBase;
import net.minecraft.client.render.font.RenderDoubleConstrainedBase;
import net.minecraft.client.render.font.RenderIntegerBase;
import net.minecraft.client.render.font.RenderIntegerConstrainedBase;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FontRenderer {
    protected static final long CONFIG_DEFAULT = 0xFFFFFFFFL;
    @NotNull
    protected static final String NULL_STRING = String.valueOf(null);
    private static final RenderIntegerBase method_render = new RenderIntegerBase(){

        @Override
        public void call() {
            this.fontRenderer.renderImpl(this.font, this.tessellator, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderDoubleBase method_renderDouble = new RenderDoubleBase(){

        @Override
        public void call() {
            this.fontRenderer.renderDoubleImpl(this.font, this.tessellator, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderIntegerBase method_renderCentered = new RenderIntegerBase(){

        @Override
        public void call() {
            this.fontRenderer.renderCenteredImpl(this.font, this.tessellator, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderDoubleBase method_renderCenteredDouble = new RenderDoubleBase(){

        @Override
        public void call() {
            this.fontRenderer.renderCenteredDoubleImpl(this.font, this.tessellator, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderIntegerConstrainedBase method_renderWidthConstrained = new RenderIntegerConstrainedBase(){

        @Override
        public void call() {
            this.fontRenderer.renderWidthConstrainedImpl(this.font, this.tessellator, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.maxWidth, this.alignment, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderDoubleConstrainedBase method_renderWidthConstrainedDouble = new RenderDoubleConstrainedBase(){

        @Override
        public void call() {
            this.fontRenderer.renderWidthConstrainedDoubleImpl(this.font, this.tessellator, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.maxWidth, this.alignment, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderIntegerConstrainedBase method_renderConstrained = new RenderIntegerConstrainedBase(){

        @Override
        public void call() {
            this.fontRenderer.renderConstrainedImpl(this.font, this.tessellator, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.maxWidth, this.maxHeight, this.alignment, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderDoubleConstrainedBase method_renderConstrainedDouble = new RenderDoubleConstrainedBase(){

        @Override
        public void call() {
            this.fontRenderer.renderConstrainedDoubleImpl(this.font, this.tessellator, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.maxWidth, this.maxHeight, this.alignment, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private final double @NotNull [] xPosBuffer = new double[1];
    private final double @NotNull [] yPosBuffer = new double[1];
    private final long @NotNull [] configBuffer = new long[1];

    abstract void renderImpl(@NotNull Font var1, @NotNull Tessellator var2, @NotNull CharSequence var3, int var4, int var5, double var6, boolean var8, long var9, double @Nullable [] var11, double @Nullable [] var12, long @Nullable [] var13);

    @NotNull
    public final RenderIntegerBase render(@NotNull Tessellator tessellator, @Nullable Object o, int x, int y) {
        return this.render(tessellator, String.valueOf(o), x, y);
    }

    @NotNull
    public final RenderIntegerBase render(@NotNull Tessellator tessellator, boolean b, int x, int y) {
        return method_render.init(this, tessellator, Boolean.toString(b), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(@NotNull Tessellator tessellator, int i, int x, int y) {
        return method_render.init(this, tessellator, Integer.toString(i), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(@NotNull Tessellator tessellator, long l, int x, int y) {
        return method_render.init(this, tessellator, Long.toString(l), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(@NotNull Tessellator tessellator, char c, int x, int y) {
        return method_render.init(this, tessellator, String.valueOf(c), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(@NotNull Tessellator tessellator, float f, int x, int y) {
        return method_render.init(this, tessellator, Float.toString(f), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(@NotNull Tessellator tessellator, double d, int x, int y) {
        return method_render.init(this, tessellator, Double.toString(d), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(@NotNull Tessellator tessellator, char @Nullable [] cArr, int x, int y) {
        return method_render.init(this, tessellator, cArr == null ? NULL_STRING : new String(cArr), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(@NotNull Tessellator tessellator, @Nullable CharSequence chars, int x, int y) {
        return method_render.init(this, tessellator, chars == null ? NULL_STRING : chars, x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderDoubleImpl(@NotNull Font var1, @NotNull Tessellator var2, @NotNull CharSequence var3, double var4, double var6, double var8, boolean var10, long var11, double @Nullable [] var13, double @Nullable [] var14, long @Nullable [] var15);

    @NotNull
    public final RenderDoubleBase renderDouble(@NotNull Tessellator tessellator, @Nullable Object o, double x, double y) {
        return this.renderDouble(tessellator, String.valueOf(o), x, y);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(@NotNull Tessellator tessellator, boolean b, double x, double y) {
        return method_renderDouble.init(this, tessellator, Boolean.toString(b), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(@NotNull Tessellator tessellator, int i, double x, double y) {
        return method_renderDouble.init(this, tessellator, Integer.toString(i), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(@NotNull Tessellator tessellator, long l, double x, double y) {
        return method_renderDouble.init(this, tessellator, Long.toString(l), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(@NotNull Tessellator tessellator, char c, double x, double y) {
        return method_renderDouble.init(this, tessellator, String.valueOf(c), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(@NotNull Tessellator tessellator, float f, double x, double y) {
        return method_renderDouble.init(this, tessellator, Float.toString(f), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(@NotNull Tessellator tessellator, double d, double x, double y) {
        return method_renderDouble.init(this, tessellator, Double.toString(d), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(@NotNull Tessellator tessellator, char @Nullable [] cArr, double x, double y) {
        return method_renderDouble.init(this, tessellator, cArr == null ? NULL_STRING : new String(cArr), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(@NotNull Tessellator tessellator, @Nullable CharSequence chars, double x, double y) {
        return method_renderDouble.init(this, tessellator, chars == null ? NULL_STRING : chars, x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderCenteredImpl(@NotNull Font var1, @NotNull Tessellator var2, @NotNull CharSequence var3, int var4, int var5, double var6, boolean var8, long var9, double @Nullable [] var11, double @Nullable [] var12, long @Nullable [] var13);

    @NotNull
    public final RenderIntegerBase renderCentered(@NotNull Tessellator tessellator, @Nullable Object o, int x, int y) {
        return this.renderCentered(tessellator, String.valueOf(o), x, y);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(@NotNull Tessellator tessellator, boolean b, int x, int y) {
        return method_renderCentered.init(this, tessellator, Boolean.toString(b), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(@NotNull Tessellator tessellator, int i, int x, int y) {
        return method_renderCentered.init(this, tessellator, Integer.toString(i), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(@NotNull Tessellator tessellator, long l, int x, int y) {
        return method_renderCentered.init(this, tessellator, Long.toString(l), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(@NotNull Tessellator tessellator, char c, int x, int y) {
        return method_renderCentered.init(this, tessellator, String.valueOf(c), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(@NotNull Tessellator tessellator, float f, int x, int y) {
        return method_renderCentered.init(this, tessellator, Float.toString(f), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(@NotNull Tessellator tessellator, double d, int x, int y) {
        return method_renderCentered.init(this, tessellator, Double.toString(d), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(@NotNull Tessellator tessellator, char @Nullable [] cArr, int x, int y) {
        return method_renderCentered.init(this, tessellator, cArr == null ? NULL_STRING : new String(cArr), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(@NotNull Tessellator tessellator, @Nullable CharSequence chars, int x, int y) {
        return method_renderCentered.init(this, tessellator, chars == null ? NULL_STRING : chars, x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderCenteredDoubleImpl(@NotNull Font var1, @NotNull Tessellator var2, @NotNull CharSequence var3, double var4, double var6, double var8, boolean var10, long var11, double @Nullable [] var13, double @Nullable [] var14, long @Nullable [] var15);

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(@NotNull Tessellator tessellator, @Nullable Object o, double x, double y) {
        return this.renderCenteredDouble(tessellator, String.valueOf(o), x, y);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(@NotNull Tessellator tessellator, boolean b, double x, double y) {
        return method_renderCenteredDouble.init(this, tessellator, Boolean.toString(b), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(@NotNull Tessellator tessellator, int i, double x, double y) {
        return method_renderCenteredDouble.init(this, tessellator, Integer.toString(i), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(@NotNull Tessellator tessellator, long l, double x, double y) {
        return method_renderCenteredDouble.init(this, tessellator, Long.toString(l), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(@NotNull Tessellator tessellator, char c, double x, double y) {
        return method_renderCenteredDouble.init(this, tessellator, String.valueOf(c), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(@NotNull Tessellator tessellator, float f, double x, double y) {
        return method_renderCenteredDouble.init(this, tessellator, Float.toString(f), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(@NotNull Tessellator tessellator, double d, double x, double y) {
        return method_renderCenteredDouble.init(this, tessellator, Double.toString(d), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(@NotNull Tessellator tessellator, char @Nullable [] cArr, double x, double y) {
        return method_renderCenteredDouble.init(this, tessellator, cArr == null ? NULL_STRING : new String(cArr), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(@NotNull Tessellator tessellator, @Nullable CharSequence chars, double x, double y) {
        return method_renderCenteredDouble.init(this, tessellator, chars == null ? NULL_STRING : chars, x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderWidthConstrainedImpl(@NotNull Font var1, @NotNull Tessellator var2, @NotNull CharSequence var3, int var4, int var5, double var6, boolean var8, long var9, int var11, @NotNull Alignment var12, double @Nullable [] var13, double @Nullable [] var14, long @Nullable [] var15);

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(@NotNull Tessellator tessellator, @Nullable Object o, int x, int y, int maxWidth) {
        return this.renderWidthConstrained(tessellator, String.valueOf(o), x, y, maxWidth);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(@NotNull Tessellator tessellator, boolean b, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, tessellator, Boolean.toString(b), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(@NotNull Tessellator tessellator, int i, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, tessellator, Integer.toString(i), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(@NotNull Tessellator tessellator, long l, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, tessellator, Long.toString(l), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(@NotNull Tessellator tessellator, char c, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, tessellator, String.valueOf(c), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(@NotNull Tessellator tessellator, float f, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, tessellator, Float.toString(f), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(@NotNull Tessellator tessellator, double d, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, tessellator, Double.toString(d), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(@NotNull Tessellator tessellator, char @Nullable [] cArr, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, tessellator, cArr == null ? NULL_STRING : new String(cArr), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(@NotNull Tessellator tessellator, @Nullable CharSequence chars, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, tessellator, chars == null ? NULL_STRING : chars, x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderWidthConstrainedDoubleImpl(@NotNull Font var1, @NotNull Tessellator var2, @NotNull CharSequence var3, double var4, double var6, double var8, boolean var10, long var11, double var13, @NotNull Alignment var15, double @Nullable [] var16, double @Nullable [] var17, long @Nullable [] var18);

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(@NotNull Tessellator tessellator, @Nullable Object o, double x, double y, double maxWidth) {
        return this.renderWidthConstrainedDouble(tessellator, String.valueOf(o), x, y, maxWidth);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(@NotNull Tessellator tessellator, boolean b, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, tessellator, Boolean.toString(b), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(@NotNull Tessellator tessellator, int i, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, tessellator, Integer.toString(i), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(@NotNull Tessellator tessellator, long l, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, tessellator, Long.toString(l), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(@NotNull Tessellator tessellator, char c, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, tessellator, String.valueOf(c), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(@NotNull Tessellator tessellator, float f, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, tessellator, Float.toString(f), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(@NotNull Tessellator tessellator, double d, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, tessellator, Double.toString(d), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(@NotNull Tessellator tessellator, char @Nullable [] cArr, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, tessellator, cArr == null ? NULL_STRING : new String(cArr), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(@NotNull Tessellator tessellator, @Nullable CharSequence chars, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, tessellator, chars == null ? NULL_STRING : chars, x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderConstrainedImpl(@NotNull Font var1, @NotNull Tessellator var2, @NotNull CharSequence var3, int var4, int var5, double var6, boolean var8, long var9, int var11, int var12, @NotNull Alignment var13, double @Nullable [] var14, double @Nullable [] var15, long @Nullable [] var16);

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(@NotNull Tessellator tessellator, @Nullable Object o, int x, int y, int maxWidth, int maxHeight) {
        return this.renderConstrained(tessellator, String.valueOf(o), x, y, maxWidth, maxHeight);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(@NotNull Tessellator tessellator, boolean b, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, tessellator, Boolean.toString(b), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(@NotNull Tessellator tessellator, int i, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, tessellator, Integer.toString(i), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(@NotNull Tessellator tessellator, long l, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, tessellator, Long.toString(l), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(@NotNull Tessellator tessellator, char c, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, tessellator, String.valueOf(c), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(@NotNull Tessellator tessellator, float f, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, tessellator, Float.toString(f), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(@NotNull Tessellator tessellator, double d, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, tessellator, Double.toString(d), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(@NotNull Tessellator tessellator, char @Nullable [] cArr, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, tessellator, cArr == null ? NULL_STRING : new String(cArr), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(@NotNull Tessellator tessellator, @Nullable CharSequence chars, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, tessellator, chars == null ? NULL_STRING : chars, x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderConstrainedDoubleImpl(@NotNull Font var1, @NotNull Tessellator var2, @NotNull CharSequence var3, double var4, double var6, double var8, boolean var10, long var11, double var13, double var15, @NotNull Alignment var17, double @Nullable [] var18, double @Nullable [] var19, long @Nullable [] var20);

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(@NotNull Tessellator tessellator, @Nullable Object o, double x, double y, double maxWidth, double maxHeight) {
        return this.renderConstrainedDouble(tessellator, String.valueOf(o), x, y, maxWidth, maxHeight);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(@NotNull Tessellator tessellator, boolean b, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, tessellator, Boolean.toString(b), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(@NotNull Tessellator tessellator, int i, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, tessellator, Integer.toString(i), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(@NotNull Tessellator tessellator, long l, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, tessellator, Long.toString(l), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(@NotNull Tessellator tessellator, char c, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, tessellator, String.valueOf(c), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(@NotNull Tessellator tessellator, float f, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, tessellator, Float.toString(f), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(@NotNull Tessellator tessellator, double d, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, tessellator, Double.toString(d), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(@NotNull Tessellator tessellator, char @Nullable [] cArr, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, tessellator, cArr == null ? NULL_STRING : new String(cArr), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(@NotNull Tessellator tessellator, @Nullable CharSequence chars, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, tessellator, chars == null ? NULL_STRING : chars, x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    public final int getLastEndingX() {
        return MathHelper.ceil(this.xPosBuffer[0]);
    }

    public final double getLastEndingXDouble() {
        return this.xPosBuffer[0];
    }

    public final int getLastEndingY() {
        return MathHelper.ceil(this.yPosBuffer[0]);
    }

    public final double getLastEndingYDouble() {
        return this.yPosBuffer[0];
    }

    public final long getLastConfig() {
        return this.configBuffer[0];
    }

    @NotNull
    public abstract List<String> splitCharsIntoLines(@NotNull Font var1, @NotNull CharSequence var2, double var3, @Nullable List<String> var5);

    @NotNull
    public List<String> splitCharsIntoLines(@NotNull CharSequence chars, double maxWidth, @Nullable List<String> output) {
        return this.splitCharsIntoLines(this.getFont(), chars, maxWidth, output);
    }

    @NotNull
    public abstract List<String> splitLinesIntoConstrainedLines(@NotNull Font var1, @NotNull List<String> var2, double var3, @Nullable List<String> var5);

    @NotNull
    public List<String> splitLinesIntoConstrainedLines(@NotNull List<String> lines, double maxWidth, @Nullable List<String> output) {
        return this.splitLinesIntoConstrainedLines(this.getFont(), lines, maxWidth, output);
    }

    public abstract double heightOfConstrainedChars(@NotNull Font var1, @NotNull CharSequence var2, double var3);

    public double heightOfConstrainedChars(@NotNull CharSequence chars, double maxWidth) {
        return this.heightOfConstrainedChars(this.getFont(), chars, maxWidth);
    }

    public abstract double heightOfLines(@NotNull Font var1, @NotNull List<String> var2, double var3);

    public double heightOfLines(@NotNull List<String> lines, double maxWidth) {
        return this.heightOfLines(this.getFont(), lines, maxWidth);
    }

    @NotNull
    public abstract Font getFont();

    public abstract double stringWidthDouble(@NotNull Font var1, @NotNull CharSequence var2);

    public int stringWidth(@NotNull Font font, @NotNull CharSequence chars) {
        return MathHelper.ceil(this.stringWidthDouble(font, chars));
    }

    public double stringWidthDouble(@NotNull CharSequence chars) {
        return this.stringWidthDouble(this.getFont(), chars);
    }

    public int stringWidth(@NotNull CharSequence chars) {
        return this.stringWidth(this.getFont(), chars);
    }
}

