/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.helper;

import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Direction;
import org.jetbrains.annotations.NotNull;

public enum Side {
    TOP(Axis.Y, 0, 1, 0, "top"),
    BOTTOM(Axis.Y, 0, -1, 0, "bottom"),
    NORTH(Axis.Z, 0, 0, -1, "north"),
    EAST(Axis.X, 1, 0, 0, "east"),
    SOUTH(Axis.Z, 0, 0, 1, "south"),
    WEST(Axis.X, -1, 0, 0, "west"),
    NONE(Axis.NONE, 0, 0, 0, "none");

    public static final Side posX;
    public static final Side negX;
    public static final Side posY;
    public static final Side negY;
    public static final Side posZ;
    public static final Side negZ;
    public static final Side[] sides;
    private final Axis axis;
    private int id;
    private Side opposite;
    private Direction direction;
    private final int offsetX;
    private final int offsetY;
    private final int offsetZ;
    private final String translationKey;

    private static void setId(Side side, int id) {
        Side.sides[id] = side;
        side.id = id;
    }

    private static void setOpposites(Side side1, Side side2) {
        side1.opposite = side2;
        side2.opposite = side1;
    }

    public static Side getSideById(int i) {
        if (i >= 0 && i < sides.length) {
            return sides[i];
        }
        return NONE;
    }

    private Side(Axis axis, int offsetX, int offsetY, int offsetZ, String translationKey) {
        this.axis = axis;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.translationKey = translationKey;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    @NotNull
    public Side getOpposite() {
        return this.opposite;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public int getId() {
        return this.id;
    }

    public boolean isVertical() {
        return this.getAxis().isVertical();
    }

    public boolean isHorizontal() {
        return !this.isVertical();
    }

    static {
        posX = EAST;
        negX = WEST;
        posY = TOP;
        negY = BOTTOM;
        posZ = SOUTH;
        negZ = NORTH;
        sides = new Side[6];
        Side.setId(BOTTOM, 0);
        Side.setId(TOP, 1);
        Side.setId(NORTH, 2);
        Side.setId(SOUTH, 3);
        Side.setId(WEST, 4);
        Side.setId(EAST, 5);
        Side.NONE.id = -1;
        Side.setOpposites(EAST, WEST);
        Side.setOpposites(TOP, BOTTOM);
        Side.setOpposites(NORTH, SOUTH);
        Side.NONE.opposite = NONE;
        Side.TOP.direction = Direction.UP;
        Side.BOTTOM.direction = Direction.DOWN;
        Side.NORTH.direction = Direction.NORTH;
        Side.EAST.direction = Direction.EAST;
        Side.SOUTH.direction = Direction.SOUTH;
        Side.WEST.direction = Direction.WEST;
        Side.NONE.direction = Direction.NONE;
    }
}

