/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityFlowerJar;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererFlowerJar
extends TileEntityRenderer<TileEntityFlowerJar> {
    @Override
    public void doRender(Tessellator tessellator, TileEntityFlowerJar tileEntity, double x, double y, double z, float renderPartialTicks) {
        GL11.glPushMatrix();
        Block<?> block = Blocks.getBlock(tileEntity.flowerInPot);
        if (block != null) {
            GL11.glTranslatef((float)x, (float)y, (float)z);
            TextureRegistry.blockAtlas.bind();
            float scaleValue = 0.75f;
            GL11.glScalef(scaleValue, scaleValue, scaleValue);
            GL11.glTranslatef(0.66f, 0.75f, 0.66f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            Lighting.disable();
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderStandalone(tessellator, tileEntity.flowerData, this.getBlockBrightness(tileEntity.worldObj, tileEntity.x, tileEntity.y, tileEntity.z), 1.0f, tileEntity.worldObj.getLightmapCoord(tileEntity.x, tileEntity.y, tileEntity.z, Minecraft.getMinecraft().isFullbrightEnabled() ? 15 : 0));
            Lighting.enableLight();
            GL11.glDisable(3042);
        }
        GL11.glPopMatrix();
    }

    public float getBlockBrightness(WorldSource blockAccess, int x, int y, int z) {
        if (Minecraft.getMinecraft().fullbright || LightmapHelper.isLightmapEnabled()) {
            return 1.0f;
        }
        return blockAccess.getBrightness(x, y, z, 0);
    }
}

