/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockLogicTorch
extends BlockLogic
implements ISupportable {
    public static final int MASK_DIRECTION = 7;
    public static final int SIDE_NONE = 0;
    public static final int SIDE_WEST = 1;
    public static final int SIDE_EAST = 2;
    public static final int SIDE_NORTH = 3;
    public static final int SIDE_SOUTH = 4;
    public static final int SIDE_BOTTOM = 5;
    public static final int SIDE_TOP = 6;

    public BlockLogicTorch(Block<?> block) {
        super(block, Material.decoration);
        block.setTicking(true);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        float f = 0.15f;
        int side = world.getBlockMetadata(x, y, z) & 7;
        switch (side) {
            case 1: {
                return AABB.fromPool(0.0, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
            }
            case 2: {
                return AABB.fromPool(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0, 0.8f, 0.5f + f);
            }
            case 3: {
                return AABB.fromPool(0.5f - f, 0.2f, 0.0, 0.5f + f, 0.8f, f * 2.0f);
            }
            case 4: {
                return AABB.fromPool(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0);
            }
        }
        float f1 = 0.1f;
        return AABB.fromPool(0.4f, 0.0, 0.4f, 0.6f, 0.6f, 0.6f);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return this.isSupported(world, x, y, z, Side.BOTTOM) || this.isSupported(world, x, y, z, Side.NORTH) || this.isSupported(world, x, y, z, Side.SOUTH) || this.isSupported(world, x, y, z, Side.WEST) || this.isSupported(world, x, y, z, Side.EAST);
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        if (side.isHorizontal()) {
            side = side.getOpposite();
        }
        this.onBlockPlacedOnSide(world, x, y, z, side, xPlaced, yPlaced);
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        int orientation = 0;
        if (side.isHorizontal()) {
            side = side.getOpposite();
        }
        switch (side) {
            case TOP: {
                if (!this.isSupported(world, x, y, z, Side.BOTTOM)) break;
                orientation = 5;
                break;
            }
            case NORTH: {
                if (!this.isSupported(world, x, y, z, Side.SOUTH)) break;
                orientation = 4;
                break;
            }
            case SOUTH: {
                if (!this.isSupported(world, x, y, z, Side.NORTH)) break;
                orientation = 3;
                break;
            }
            case WEST: {
                if (!this.isSupported(world, x, y, z, Side.EAST)) break;
                orientation = 2;
                break;
            }
            case EAST: {
                if (!this.isSupported(world, x, y, z, Side.WEST)) break;
                orientation = 1;
            }
        }
        if (orientation == 0) {
            orientation = this.getDefaultOrientation(world, x, y, z);
        }
        world.setBlockMetadataWithNotify(x, y, z, orientation);
        this.dropTorchIfCantStay(world, x, y, z);
    }

    public int getDefaultOrientation(World world, int x, int y, int z) {
        if (this.isSupported(world, x, y, z, Side.BOTTOM)) {
            return 5;
        }
        if (this.isSupported(world, x, y, z, Side.WEST)) {
            return 1;
        }
        if (this.isSupported(world, x, y, z, Side.EAST)) {
            return 2;
        }
        if (this.isSupported(world, x, y, z, Side.NORTH)) {
            return 3;
        }
        if (this.isSupported(world, x, y, z, Side.SOUTH)) {
            return 4;
        }
        return 0;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand, boolean isRandomTick) {
        super.updateTick(world, x, y, z, rand, isRandomTick);
        if (world.getBlockMetadata(x, y, z) == 0) {
            this.onBlockPlacedByWorld(world, x, y, z);
        }
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        int orientation = this.getDefaultOrientation(world, x, y, z);
        if (orientation != 0) {
            world.setBlockMetadataWithNotify(x, y, z, orientation);
        }
        this.dropTorchIfCantStay(world, x, y, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean invalid;
        int side = world.getBlockMetadata(x, y, z) & 7;
        switch (side) {
            case 1: {
                invalid = !this.isSupported(world, x, y, z, Side.WEST);
                break;
            }
            case 2: {
                invalid = !this.isSupported(world, x, y, z, Side.EAST);
                break;
            }
            case 3: {
                invalid = !this.isSupported(world, x, y, z, Side.NORTH);
                break;
            }
            case 4: {
                invalid = !this.isSupported(world, x, y, z, Side.SOUTH);
                break;
            }
            case 5: {
                invalid = !this.isSupported(world, x, y, z, Side.BOTTOM);
                break;
            }
            default: {
                invalid = true;
            }
        }
        if (invalid) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, side, null, null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    private void dropTorchIfCantStay(World world, int x, int y, int z) {
        if (!this.canPlaceBlockAt(world, x, y, z)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        double xPos = (double)x + 0.5;
        double yPos = (double)y + 0.7;
        double zPos = (double)z + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        int side = world.getBlockMetadata(x, y, z) & 7;
        switch (side) {
            case 1: {
                world.spawnParticle("smoke", xPos - d4, yPos + d3, zPos, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", xPos - d4, yPos + d3, zPos, 0.0, 0.0, 0.0, 0);
                break;
            }
            case 2: {
                world.spawnParticle("smoke", xPos + d4, yPos + d3, zPos, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", xPos + d4, yPos + d3, zPos, 0.0, 0.0, 0.0, 0);
                break;
            }
            case 3: {
                world.spawnParticle("smoke", xPos, yPos + d3, zPos - d4, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", xPos, yPos + d3, zPos - d4, 0.0, 0.0, 0.0, 0);
                break;
            }
            case 4: {
                world.spawnParticle("smoke", xPos, yPos + d3, zPos + d4, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", xPos, yPos + d3, zPos + d4, 0.0, 0.0, 0.0, 0);
                break;
            }
            case 5: {
                world.spawnParticle("smoke", xPos, yPos, zPos, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", xPos, yPos, zPos, 0.0, 0.0, 0.0, 0);
            }
        }
    }

    @Override
    public int getLightmapCoord(WorldSource blockAccess, int x, int y, int z) {
        return blockAccess.getLightmapCoord(x, y, z, this.block.emission > 0 ? 15 : 0);
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        switch (side) {
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: 
            case BOTTOM: {
                return PartialSupport.INSTANCE.center();
            }
        }
        return PartialSupport.INSTANCE;
    }
}

