/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.paged;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.paged.Page;
import net.minecraft.client.gui.paged.PageComponent;
import net.minecraft.client.gui.paged.PageRegistry;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ScreenPaged
extends Screen {
    private static final int TOP_SPACING = 24;
    private static final int BUTTON_SPACING = 4;
    private static final int SEPARATOR_WIDTH = 8;
    private static final int PADDING = 8;
    private static final int PAGE_BUTTON_HEIGHT = 20;
    @NotNull
    private final String titleTranslationKey;
    @NotNull
    private final @NotNull String @NotNull [] buttonTranslationKeys;
    private float rightScrollAmount = 0.0f;
    private float leftScrollAmount = 0.0f;
    private int top;
    private int bottom;
    private int rightScrollRegionHeight;
    private int leftScrollRegionHeight;
    private int pageWidth;
    private int leftWidth;
    @Nullable
    private Float oldRightScrollAmount = null;
    @Nullable
    private Float oldLeftScrollAmount = null;
    @Nullable
    private Integer clickX;
    @Nullable
    private Integer clickY;
    @NotNull
    private Page selectedPage;
    @Nullable
    private PageComponent clickedComponent;
    private int clickedComponentY;
    @Nullable
    private ItemElement renderItem = null;
    @NotNull
    private final PageRegistry pageRegistry;

    public ScreenPaged(@Nullable Screen parent, @NotNull PageRegistry pageRegistry, @Nullable Page selectedPage, @NotNull String titleTranslationKey, @NotNull @NotNull String @NotNull [] buttonTranslationKeys) {
        super(parent);
        this.pageRegistry = pageRegistry;
        this.selectedPage = selectedPage == null ? pageRegistry.getPages().get(0) : selectedPage;
        this.titleTranslationKey = titleTranslationKey;
        this.buttonTranslationKeys = buttonTranslationKeys;
    }

    @Override
    public void init() {
        super.init();
        int buttonWidth = 200 - (this.buttonTranslationKeys.length - 1) * 40;
        int totalButtonsWidth = this.buttonTranslationKeys.length * (buttonWidth + 4) - 4;
        for (int i = 0; i < this.buttonTranslationKeys.length; ++i) {
            String buttonTranslationKey = this.buttonTranslationKeys[i];
            this.buttons.add(new ButtonElement(i, this.width / 2 - totalButtonsWidth / 2 + (buttonWidth + 4) * i, this.height - 24, buttonWidth, 20, I18n.getInstance().translateKey(buttonTranslationKey)));
        }
        this.top = 24;
        this.bottom = this.height - 28;
        this.rightScrollRegionHeight = this.bottom - this.top;
        this.leftScrollRegionHeight = this.bottom - this.top;
        this.renderItem = new ItemElement(this.mc);
        this.selectedPage.initComponents(this.mc);
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.mc.displayScreen(this.getParentScreen());
        } else {
            for (PageComponent component : this.selectedPage.getComponents()) {
                component.onKeyPress(eventKey, eventCharacter);
            }
        }
    }

    private void drawPageItems(int x, int y, int width, int mouseX, int mouseY) {
        int y2 = y;
        for (PageComponent component : this.selectedPage.getComponents()) {
            component.render(x, y2, width, mouseX - x, mouseY - y2);
            y2 += component.getHeight();
        }
    }

    private void drawPagesListItems(int x, int y, int width, int mouseX, int mouseY) {
        int y2 = y;
        for (Page page : this.pageRegistry.getPages()) {
            String translated = I18n.getInstance().translateKey(page.getTranslationKey());
            int textColor = -8421505;
            if (page == this.selectedPage) {
                textColor = -1;
            }
            if (mouseX >= x && mouseX < x + width && mouseY >= y2 && mouseY < y2 + 20) {
                textColor = -96;
            }
            assert (this.renderItem != null);
            this.renderItem.render(page.getIcon(), x, y2 + 10 - 9);
            this.drawStringShadow(this.fontRenderer, translated, x + 19, y2 + 10 - 4, textColor);
            y2 += 20;
        }
    }

    @Override
    public void tick() {
        for (PageComponent component : this.selectedPage.getComponents()) {
            component.tick();
        }
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        super.buttonClicked(button);
        if (button.id == 0) {
            this.mc.displayScreen(this.getParentScreen());
            this.mc.texturePackList.refreshIfReady();
        }
    }

    private void scrollRightPanel(float amount) {
        if (amount == 0.0f) {
            return;
        }
        this.rightScrollAmount += amount;
        this.onScrollRightPanel();
    }

    private void onScrollRightPanel() {
        int totalRightPanelHeight = this.getTotalRightPanelHeight();
        if (this.rightScrollAmount < 0.0f || this.rightScrollRegionHeight > totalRightPanelHeight) {
            this.rightScrollAmount = 0.0f;
        } else if (this.rightScrollAmount > (float)(totalRightPanelHeight - this.rightScrollRegionHeight)) {
            this.rightScrollAmount = totalRightPanelHeight - this.rightScrollRegionHeight;
        }
    }

    private void scrollLeftPanel(float amount) {
        if (amount == 0.0f) {
            return;
        }
        this.leftScrollAmount += amount;
        this.onScrollLeftPanel();
    }

    private void onScrollLeftPanel() {
        int totalLeftPanelHeight = this.getTotalLeftPanelHeight();
        if (this.leftScrollAmount < 0.0f || this.leftScrollRegionHeight > totalLeftPanelHeight) {
            this.leftScrollAmount = 0.0f;
        } else if (this.leftScrollAmount > (float)(totalLeftPanelHeight - this.leftScrollRegionHeight)) {
            this.leftScrollAmount = totalLeftPanelHeight - this.leftScrollRegionHeight;
        }
    }

    private int getTotalRightPanelHeight() {
        int totalPageHeight = 0;
        for (PageComponent component : this.selectedPage.getComponents()) {
            totalPageHeight += component.getHeight();
        }
        return totalPageHeight;
    }

    private int getTotalLeftPanelHeight() {
        return 20 * this.pageRegistry.getPages().size();
    }

    @Override
    public void render(int mx, int my, float renderPartialTicks) {
        if (mx > this.leftWidth + 8 + 8 && mx < this.width) {
            if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL)) {
                this.scrollRightPanel((float)Mouse.getDWheel() / -0.01f);
            } else {
                this.scrollRightPanel((float)Mouse.getDWheel() / -0.05f);
            }
            this.onScrollRightPanel();
        } else if (mx >= 0 && mx <= this.leftWidth) {
            if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL)) {
                this.scrollLeftPanel((float)Mouse.getDWheel() / -0.01f);
            } else {
                this.scrollLeftPanel((float)Mouse.getDWheel() / -0.05f);
            }
            this.onScrollLeftPanel();
        }
        this.leftWidth = (int)((float)this.width * 0.25f);
        this.pageWidth = this.width - (this.leftWidth + 8 + 16);
        @NotNull I18n i18n = I18n.getInstance();
        this.renderBackground();
        this.overlayBackground(0, this.width, 0, this.top);
        this.overlayBackground(0, this.width, this.bottom, this.height);
        Scissor.enable(0, this.top, this.width, this.bottom - this.top);
        if (my >= this.top && my <= this.bottom) {
            this.drawPageItems(this.leftWidth + 8 + 8, this.top - (int)this.rightScrollAmount, this.pageWidth - 8, mx, my);
        } else {
            this.drawPageItems(this.leftWidth + 8 + 8, this.top - (int)this.rightScrollAmount, this.pageWidth - 8, -1, -1);
        }
        Scissor.disable();
        Scissor.enable(0, this.top, this.leftWidth, this.bottom - this.top);
        int pagesListHeight = this.getTotalLeftPanelHeight();
        int pagesListY = this.top - (int)this.leftScrollAmount;
        if (pagesListHeight < this.bottom - this.top) {
            pagesListY = this.top + (this.bottom - this.top - pagesListHeight) / 2;
        }
        if (my >= this.top && my <= this.bottom) {
            this.drawPagesListItems(4, pagesListY, this.leftWidth - 8, mx, my);
        } else {
            this.drawPagesListItems(4, pagesListY, this.leftWidth - 8, -1, -1);
        }
        Scissor.disable();
        if (this.mc.currentWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            GL11.glDisable(2929);
            int shadowSize = 4;
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3008);
            GL11.glShadeModel(7425);
            GL11.glDisable(3553);
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0, 0);
            tessellator.addVertexWithUV(0.0, this.top + 4, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.width, this.top + 4, 0.0, 1.0, 1.0);
            tessellator.setColorRGBA_I(0, 255);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0, 255);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, 1.0, 1.0);
            tessellator.setColorRGBA_I(0, 0);
            tessellator.addVertexWithUV(this.width, this.bottom - 4, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0.0, this.bottom - 4, 0.0, 0.0, 0.0);
            tessellator.draw();
            GL11.glEnable(3553);
            GL11.glShadeModel(7424);
            GL11.glEnable(3008);
            GL11.glDisable(3042);
        }
        this.overlayBackground(this.leftWidth, this.leftWidth + 8, this.top, this.bottom);
        this.drawStringCenteredShadow(this.fontRenderer, i18n.translateKey(this.titleTranslationKey), this.width / 2, 5, 0xFFFFFF);
        this.drawRightPanelScrollBar(mx, my);
        this.drawLeftPanelScrollBar(mx, my);
        super.render(mx, my, renderPartialTicks);
    }

    protected void drawRightPanelScrollBar(int mouseX, int mouseY) {
        float totalPageHeight = this.getTotalRightPanelHeight();
        float scrollBarHeightPercent = (float)this.rightScrollRegionHeight / totalPageHeight;
        if (scrollBarHeightPercent > 1.0f) {
            return;
        }
        GL11.glDisable(3553);
        int scrollBarX = this.width - 6;
        int scrollBarHeightPx = (int)(scrollBarHeightPercent * (float)this.rightScrollRegionHeight);
        if (scrollBarHeightPx < 32) {
            scrollBarHeightPx = 32;
        }
        float scrollPercent = this.rightScrollAmount / (totalPageHeight - (float)this.rightScrollRegionHeight);
        int scrollBarY = (int)((float)this.top + (float)(this.rightScrollRegionHeight - scrollBarHeightPx) * scrollPercent);
        @NotNull Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.setColorOpaque(0, 0, 0);
        t.drawRectangle(scrollBarX, this.top, 6, this.rightScrollRegionHeight);
        t.setColorRGBA_I(0x808080, 255);
        t.drawRectangle(scrollBarX, scrollBarY, 6, scrollBarHeightPx);
        t.setColorRGBA_I(0xC0C0C0, 255);
        t.drawRectangle(scrollBarX + 1, scrollBarY, 5, scrollBarHeightPx - 1);
        t.draw();
        GL11.glEnable(3553);
        if (this.clickX != null && this.clickY != null) {
            if (this.clickX >= scrollBarX && this.clickY >= this.top && this.clickX <= scrollBarX + 6 && this.clickY < this.bottom) {
                if (this.oldRightScrollAmount == null) {
                    this.oldRightScrollAmount = Float.valueOf(this.rightScrollAmount);
                }
                this.rightScrollAmount = this.oldRightScrollAmount.floatValue() + (float)(this.clickY - mouseY) * (1.0f / scrollBarHeightPercent) * -1.0f;
                this.onScrollRightPanel();
            }
        } else {
            this.oldRightScrollAmount = null;
        }
    }

    protected void drawLeftPanelScrollBar(int mouseX, int mouseY) {
        float totalPagesListHeight = this.getTotalLeftPanelHeight();
        float scrollBarHeightPercent = (float)this.leftScrollRegionHeight / totalPagesListHeight;
        if (scrollBarHeightPercent > 1.0f) {
            return;
        }
        GL11.glDisable(3553);
        int scrollBarX = this.leftWidth - 6;
        int scrollBarHeightPx = (int)(scrollBarHeightPercent * (float)this.leftScrollRegionHeight);
        if (scrollBarHeightPx < 32) {
            scrollBarHeightPx = 32;
        }
        float scrollPercent = this.leftScrollAmount / (totalPagesListHeight - (float)this.leftScrollRegionHeight);
        int scrollBarY = (int)((float)this.top + (float)(this.leftScrollRegionHeight - scrollBarHeightPx) * scrollPercent);
        @NotNull Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.setColorOpaque(0, 0, 0);
        t.drawRectangle(scrollBarX, this.top, 6, this.leftScrollRegionHeight);
        t.setColorRGBA_I(0x808080, 255);
        t.drawRectangle(scrollBarX, scrollBarY, 6, scrollBarHeightPx);
        t.setColorRGBA_I(0xC0C0C0, 255);
        t.drawRectangle(scrollBarX + 1, scrollBarY, 5, scrollBarHeightPx - 1);
        t.draw();
        GL11.glEnable(3553);
        if (this.clickX != null && this.clickY != null) {
            if (this.clickX >= scrollBarX && this.clickY >= this.top && this.clickX <= scrollBarX + 6 && this.clickY < this.bottom) {
                if (this.oldLeftScrollAmount == null) {
                    this.oldLeftScrollAmount = Float.valueOf(this.leftScrollAmount);
                }
                this.leftScrollAmount = this.oldLeftScrollAmount.floatValue() + (float)(this.clickY - mouseY) * (1.0f / scrollBarHeightPercent) * -1.0f;
                this.onScrollRightPanel();
            }
        } else {
            this.oldLeftScrollAmount = null;
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        int left = this.leftWidth + 8 + 8;
        if (mx >= this.leftWidth + 8 && my >= this.top && my <= this.bottom) {
            int componentY = this.top - (int)this.rightScrollAmount;
            for (PageComponent component : this.selectedPage.getComponents()) {
                if (mx >= left && mx <= left + this.pageWidth - 8 && my >= componentY && my <= componentY + component.getHeight()) {
                    component.onMouseClick(buttonNum, left, componentY, this.pageWidth - 8, mx - left, my - componentY);
                    this.clickedComponent = component;
                    this.clickedComponentY = componentY;
                    break;
                }
                componentY += component.getHeight();
            }
        } else if (mx >= 0 && mx <= this.leftWidth && my >= this.top && my <= this.bottom) {
            int pagesListHeight = this.getTotalLeftPanelHeight();
            int pagesListY = this.top - (int)this.leftScrollAmount;
            if (pagesListHeight < this.bottom - this.top) {
                pagesListY = this.top + (this.bottom - this.top - pagesListHeight) / 2;
            }
            for (Page page : this.pageRegistry.getPages()) {
                if (mx >= 0 && mx <= this.leftWidth && my >= pagesListY && my <= pagesListY + 20) {
                    this.rightScrollAmount = 0.0f;
                    this.selectedPage = page;
                    this.selectedPage.initComponents(this.mc);
                    this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                    this.mc.texturePackList.refreshIfReady();
                    break;
                }
                pagesListY += 20;
            }
        }
        this.clickX = mx;
        this.clickY = my;
    }

    @Override
    public void mouseReleased(int mx, int my, int buttonNum) {
        super.mouseReleased(mx, my, buttonNum);
        int left = this.leftWidth + 8 + 8;
        if (my >= this.top && my <= this.bottom && this.clickedComponent != null) {
            if (buttonNum >= 0) {
                this.clickedComponent.onMouseRelease(buttonNum, left, this.clickedComponentY, this.pageWidth, mx - left, my - this.clickedComponentY);
                this.clickedComponent = null;
            } else {
                this.clickedComponent.onMouseMove(left, this.clickedComponentY, this.pageWidth, mx - left, my - this.clickedComponentY);
            }
        }
        if (buttonNum >= 0) {
            this.clickX = null;
            this.clickY = null;
        }
    }

    @Override
    public void renderBackground() {
        super.renderBackground();
        if (this.mc.currentWorld == null) {
            @NotNull Tessellator tessellator = Tessellator.instance;
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x202020);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, (float)(this.bottom + (int)this.rightScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, (float)this.width / 32.0f, (float)(this.bottom + (int)this.rightScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, (float)this.width / 32.0f, (float)(this.top + (int)this.rightScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, (float)(this.top + (int)this.rightScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, (float)(this.bottom + (int)this.leftScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(this.leftWidth, this.bottom, 0.0, (float)this.leftWidth / 32.0f, (float)(this.bottom + (int)this.leftScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(this.leftWidth, this.top, 0.0, (float)this.leftWidth / 32.0f, (float)(this.top + (int)this.leftScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, (float)(this.top + (int)this.leftScrollAmount) / 32.0f);
            tessellator.draw();
        } else {
            this.drawRect(0, 0, this.width, this.top, 0x5F000000);
            this.drawRect(0, this.bottom, this.width, this.height, 0x5F000000);
            this.drawRect(this.leftWidth, this.top, this.leftWidth + 8, this.bottom, 0x5F000000);
        }
    }

    private void overlayBackground(int minX, int maxX, int minY, int maxY) {
        if (this.mc.currentWorld == null) {
            @NotNull Tessellator tessellator = Tessellator.instance;
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x404040);
            tessellator.addVertexWithUV(minX, maxY, 0.0, (float)minX / 32.0f, (float)maxY / 32.0f);
            tessellator.addVertexWithUV(maxX, maxY, 0.0, (float)maxX / 32.0f, (float)maxY / 32.0f);
            tessellator.setColorOpaque_I(0x404040);
            tessellator.addVertexWithUV(maxX, minY, 0.0, (float)maxX / 32.0f, (float)minY / 32.0f);
            tessellator.addVertexWithUV(minX, minY, 0.0, (float)minX / 32.0f, (float)minY / 32.0f);
            tessellator.draw();
        }
    }
}

