/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemFireStriker;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class BlockLogicBrazier
extends BlockLogic {
    private final boolean burning;

    public BlockLogicBrazier(Block<?> block, boolean burning) {
        super(block, Material.metal);
        this.burning = burning;
    }

    public boolean isBurning() {
        return this.burning;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        return side == Side.BOTTOM ? FullSupport.INSTANCE : PartialSupport.INSTANCE;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Blocks.BRAZIER_INACTIVE, 1)};
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        ItemStack heldItem = player.getHeldItem();
        if (heldItem != null && heldItem.getItem() instanceof ItemFireStriker && !this.burning) {
            Block<?> b = world.getBlock(x + 1, y, z);
            if (b != null && b.getLogic() instanceof BlockLogicFluid || (b = world.getBlock(x - 1, y, z)) != null && b.getLogic() instanceof BlockLogicFluid || (b = world.getBlock(x, y, z + 1)) != null && b.getLogic() instanceof BlockLogicFluid || (b = world.getBlock(x, y, z - 1)) != null && b.getLogic() instanceof BlockLogicFluid) {
                return false;
            }
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.BRAZIER_ACTIVE.id(), 0);
            heldItem.damageItem(1, player);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        if (heldItem == null && this.burning) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.BRAZIER_INACTIVE.id(), 0);
            return true;
        }
        return false;
    }

    @Override
    public void onActivatorInteract(World world, int x, int y, int z, TileEntityActivator activator, Direction direction) {
        if (this.burning) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.BRAZIER_INACTIVE.id(), 0);
        }
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (this.burning) {
            Blocks.FIRE.onBlockRemoved(world, x, y, z, data);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!this.burning) {
            return;
        }
        Block<?> block = Blocks.blocksList[blockId];
        if (block != null && block.getLogic() instanceof BlockLogicFluid) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.BRAZIER_INACTIVE.id(), 0);
        }
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (this.burning) {
            Blocks.FIRE.animationTick(world, x, y, z, rand);
        }
    }
}

