/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.current.wire;

import net.minecraft.core.current.util.BlockPos;
import net.minecraft.core.current.util.BlockState;
import net.minecraft.core.world.World;

class WorldHelper {
    private static final int Y_MIN = 0;

    WorldHelper() {
    }

    static BlockState getBlockState(World world, BlockPos pos) {
        if (pos.y < 0 || pos.y >= world.getHeightBlocks()) {
            return BlockState.AIR;
        }
        int blockId = world.getBlockId(pos.x, pos.y, pos.z);
        if (blockId == 0) {
            return BlockState.AIR;
        }
        return new BlockState(blockId, world.getBlockMetadata(pos.x, pos.y, pos.z));
    }

    static boolean setWireState(World world, BlockPos pos, BlockState state) {
        int prevMetadata;
        int prevBlockId;
        if (pos.y < 0 || pos.y >= world.getHeightBlocks()) {
            return false;
        }
        int blockId = state.getBlockId();
        if (blockId != (prevBlockId = world.getBlockId(pos.x, pos.y, pos.z))) {
            return false;
        }
        int metadata = state.get();
        if (metadata == (prevMetadata = world.getBlockMetadata(pos.x, pos.y, pos.z))) {
            return false;
        }
        world.setBlockMetadata(pos.x, pos.y, pos.z, metadata);
        world.notifyBlockChange(pos.x, pos.y, pos.z, blockId);
        world.markBlockDirty(pos.x, pos.y, pos.z);
        return true;
    }
}

