/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pos;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.pos.ChunkTilePos;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public final class ChunkPos {
    public int x;
    public int z;

    public ChunkPos(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public ChunkPos(@NotNull TilePos tilePos) {
        this(MathHelper.floorIntDiv(tilePos.x, 16), MathHelper.floorIntDiv(tilePos.z, 16));
    }

    public ChunkPos(@NotNull Entity entity) {
        this(MathHelper.floor(entity.x / 16.0), MathHelper.floor(entity.z / 16.0));
    }

    @NotNull
    public TilePos toTilePos(@NotNull ChunkTilePos chunkTilePos) {
        return new TilePos(this, chunkTilePos);
    }

    @NotNull
    public ChunkPos add(int x, int z) {
        return new ChunkPos(this.x + x, this.z + z);
    }

    @NotNull
    public ChunkPos add(@NotNull ChunkPos other) {
        return new ChunkPos(this.x + other.x, this.z + other.z);
    }

    @NotNull
    public ChunkPos add(@NotNull Direction direction, int distance) {
        return new ChunkPos(this.x + direction.getOffsetX() * distance, this.z + direction.getOffsetZ() * distance);
    }

    @NotNull
    public ChunkPos add(@NotNull Direction direction) {
        return this.add(direction, 1);
    }

    @NotNull
    public ChunkPos sub(int x, int z) {
        return new ChunkPos(this.x - x, this.z - z);
    }

    @NotNull
    public ChunkPos sub(@NotNull ChunkPos other) {
        return new ChunkPos(this.x - other.x, this.z - other.z);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChunkPos)) {
            return false;
        }
        @NotNull ChunkPos other = (ChunkPos)obj;
        return this.x == other.x && this.z == other.z;
    }

    public int hashCode() {
        return MathHelper.cantor(this.x, this.z);
    }
}

