/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pos;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkTilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TilePos {
    public int x;
    public int y;
    public int z;

    public TilePos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public TilePos(float x, float y, float z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public TilePos(double x, double y, double z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public TilePos(@NotNull ChunkPos chunkPos, @NotNull ChunkTilePos chunkTilePos) {
        this(chunkPos.x * 16 + chunkTilePos.x, chunkTilePos.y, chunkPos.z * 16 + chunkTilePos.z);
    }

    public TilePos(@NotNull Vec3 vec) {
        this(vec.x, vec.y, vec.z);
    }

    public TilePos(@NotNull Entity entity) {
        this(entity.x, entity.y, entity.z);
    }

    @NotNull
    public ChunkPos toChunkPos() {
        return new ChunkPos(this);
    }

    @NotNull
    public ChunkTilePos toChunkTilePos() {
        return new ChunkTilePos(this);
    }

    @NotNull
    public TilePos add(int x, int y, int z) {
        return new TilePos(this.x + x, this.y + y, this.z + z);
    }

    @NotNull
    public TilePos add(@NotNull TilePos other) {
        return new TilePos(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    @NotNull
    public TilePos add(@NotNull Direction direction, int distance) {
        return new TilePos(this.x + direction.getOffsetX() * distance, this.y + direction.getOffsetY() * distance, this.z + direction.getOffsetZ() * distance);
    }

    @NotNull
    public TilePos add(@NotNull Direction direction) {
        return this.add(direction, 1);
    }

    @NotNull
    public TilePos sub(int x, int y, int z) {
        return new TilePos(this.x - x, this.y - y, this.z - z);
    }

    @NotNull
    public TilePos sub(@NotNull TilePos other) {
        return new TilePos(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TilePos)) {
            return false;
        }
        @NotNull TilePos other = (TilePos)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return MathHelper.cantor(MathHelper.cantor(this.x, this.y), this.z);
    }
}

