/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockModelCrystallineNetherrack<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected IconCoordinate overlay = TextureRegistry.getTexture("minecraft:block/nether_crystal/overlay");

    public BlockModelCrystallineNetherrack(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        AABB bounds = this.block.getBlockBoundsFromState(worldSource, x, y, z);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z, 1.0f, 1.0f, 1.0f);
        BlockModelCrystallineNetherrack.renderBlocks.overrideBlockTexture = this.overlay;
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        BlockModelCrystallineNetherrack.renderBlocks.overrideBlockTexture = null;
        return true;
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        BlockModelCrystallineNetherrack.renderBlocks.useInventoryTint = false;
        super.renderStandalone(tessellator, metadata, brightness, alpha, lightmapCoordinate);
        BlockModelCrystallineNetherrack.renderBlocks.useInventoryTint = true;
        GL11.glTranslatef(-0.5f, -0.5f, -0.5f);
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f(r * brightness, g * brightness, b * brightness, alpha);
        AABB bounds = this.block.getBounds();
        IconCoordinate coord = this.overlay;
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, coord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, coord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, coord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, coord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, coord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, coord);
        tessellator.draw();
        GL11.glTranslatef(0.5f, 0.5f, 0.5f);
    }
}

