/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player.controller;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicDoor;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerController {
    protected float currentDamage;
    protected float previousDamage;
    protected int soundDelay;
    protected int swingCooldown = 0;
    protected int blockHitDelay;
    protected Integer miningX;
    protected Integer miningY;
    protected Integer miningZ;
    protected final Minecraft mc;

    public PlayerController(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void startDestroyBlock(int x, int y, int z, Side side, double xHit, double yHit, boolean repeat) {
        float mineStrength;
        if (this.mc.thePlayer.getHeldObject() != null) {
            return;
        }
        if (!this.mc.thePlayer.getGamemode().canInteract()) {
            return;
        }
        if (!this.mc.thePlayer.getGamemode().doBlockBreakingAnim()) {
            this.swingItem(true);
            ItemStack heldItem = this.mc.thePlayer.getCurrentEquippedItem();
            if (heldItem != null && heldItem.getItem().hasTag(ItemTags.PREVENT_CREATIVE_MINING)) {
                return;
            }
            this.destroyBlock(x, y, z, side, this.mc.thePlayer);
            this.sendStartDigPacket(x, y, z, side, xHit, yHit);
            return;
        }
        Block<?> mineBlock = Blocks.getBlock(this.mc.currentWorld.getBlockId(x, y, z));
        if (mineBlock != null && (mineStrength = mineBlock.blockStrength(this.mc.currentWorld, x, y, z, side, this.mc.thePlayer)) < 1.0f && !repeat) {
            this.sendStartDigPacket(x, y, z, side, xHit, yHit);
            this.hitBlock(x, y, z, side, xHit, yHit);
            this.setMineBlock(x, y, z);
        }
    }

    public void continueDestroyBlock(int x, int y, int z, Side side, double xHit, double yHit) {
        if (!this.mc.thePlayer.getGamemode().doBlockBreakingAnim() || !this.mc.thePlayer.getGamemode().canInteract() || this.mc.thePlayer.getHeldObject() != null) {
            return;
        }
        this.swingItem(false);
        if (this.blockHitDelay > 0) {
            --this.blockHitDelay;
            return;
        }
        Block<?> mineBlock = Blocks.getBlock(this.mc.currentWorld.getBlockId(x, y, z));
        if (mineBlock != null) {
            this.syncCurrentPlayItem();
            float mineStrength = mineBlock.blockStrength(this.mc.currentWorld, x, y, z, side, this.mc.thePlayer);
            if (mineStrength >= 1.0f) {
                this.setMineBlock(x, y, z);
                this.destroyBlock(x, y, z, side, this.mc.thePlayer);
                this.sendStartDigPacket(x, y, z, side, xHit, yHit);
                this.currentDamage = 0.0f;
                this.previousDamage = 0.0f;
                this.soundDelay = 0;
                this.blockHitDelay = 1;
            } else {
                if (!this.isMiningBlock(x, y, z)) {
                    this.sendStartDigPacket(x, y, z, side, xHit, yHit);
                    if (this.mc.currentWorld.getBlockLogic(x, y, z, BlockLogicDoor.class) == null) {
                        this.hitBlock(x, y, z, side, xHit, yHit);
                    }
                    this.currentDamage = 0.0f;
                    this.previousDamage = 0.0f;
                    this.setMineBlock(x, y, z);
                }
                this.mc.particleEngine.crack(x, y, z, side);
                this.playDigSound(mineBlock, x, y, z);
                this.currentDamage += mineStrength;
                if (this.currentDamage > 1.0f) {
                    this.destroyBlock(x, y, z, side, this.mc.thePlayer);
                    this.sendDestroyBlockPacket(x, y, z, side, xHit, yHit);
                    this.setMineBlock(null, null, null);
                    this.currentDamage = 0.0f;
                    this.previousDamage = 0.0f;
                    this.soundDelay = 0;
                    int newBlockHitDelay = mineStrength > 0.5f ? 2 : (mineStrength > 0.4f ? 3 : (mineStrength > 0.3f ? 4 : 5));
                    this.blockHitDelay = newBlockHitDelay;
                }
            }
        } else {
            this.currentDamage = 0.0f;
            this.previousDamage = 0.0f;
            this.soundDelay = 0;
        }
    }

    public boolean swingItem(boolean force) {
        if (this.swingCooldown == 0 || force) {
            this.mc.thePlayer.swingItem();
            this.swingCooldown = 5;
            return true;
        }
        return false;
    }

    public boolean destroyBlock(int x, int y, int z, Side side, Player player) {
        if (!player.getGamemode().canInteract() || this.mc.thePlayer.getHeldObject() != null) {
            return false;
        }
        this.setMineBlock(null, null, null);
        WorldClient world = this.mc.currentWorld;
        Block<?> block = Blocks.getBlock(world.getBlockId(x, y, z));
        if (block == null) {
            return false;
        }
        Item heldItem = null;
        ItemStack heldItemStack = player.getCurrentEquippedItem();
        if (heldItemStack != null) {
            if (!heldItemStack.beforeDestroyBlock(world, block.id(), x, y, z, side, player)) {
                return false;
            }
            heldItem = heldItemStack.getItem();
        }
        world.playBlockEvent(2001, x, y, z, block.id());
        int meta = world.getBlockMetadata(x, y, z);
        boolean removed = world.setBlockWithNotify(x, y, z, 0);
        if (removed) {
            block.onBlockDestroyedByPlayer(world, x, y, z, side, meta, player, heldItem);
        }
        return removed;
    }

    public void stopDestroyBlock(boolean leftClickDown) {
        this.currentDamage = 0.0f;
        this.previousDamage = 0.0f;
        this.soundDelay = 0;
        if (this.blockHitDelay > 0) {
            --this.blockHitDelay;
        }
    }

    protected void hitBlock(int x, int y, int z, Side side, double xHit, double yHit) {
        if (!this.mc.thePlayer.getGamemode().canInteract() || this.mc.thePlayer.getHeldObject() != null) {
            return;
        }
        this.mc.currentWorld.onBlockHit(this.mc.thePlayer, x, y, z, side);
        Block<?> block = Blocks.getBlock(this.mc.currentWorld.getBlockId(x, y, z));
        if (block != null) {
            block.onBlockLeftClicked(this.mc.currentWorld, x, y, z, this.mc.thePlayer, side, xHit, yHit);
        }
    }

    private boolean isMiningBlock(int x, int y, int z) {
        return this.miningX != null && this.miningX == x && this.miningY != null && this.miningY == y && this.miningZ != null && this.miningZ == z;
    }

    private void setMineBlock(Integer x, Integer y, Integer z) {
        this.miningX = x;
        this.miningY = y;
        this.miningZ = z;
    }

    public void render(float f) {
        if (this.currentDamage <= 0.0f) {
            this.mc.hudIngame.damageGuiPartialTime = 0.0f;
            this.mc.renderGlobal.destroyProgress = 0.0f;
        } else {
            float f1;
            this.mc.hudIngame.damageGuiPartialTime = f1 = this.previousDamage + (this.currentDamage - this.previousDamage) * f;
            this.mc.renderGlobal.destroyProgress = f1;
        }
    }

    public float getBlockReachDistance() {
        return this.mc.thePlayer.getGamemode().getBlockReachDistance();
    }

    public float getEntityReachDistance() {
        return this.mc.thePlayer.getGamemode().getEntityReachDistance();
    }

    public void initPlayer(Player player) {
        player.yRot = -180.0f;
    }

    public void tick() {
        if (this.swingCooldown > 0) {
            --this.swingCooldown;
        }
        this.syncCurrentPlayItem();
        this.previousDamage = this.currentDamage;
        this.mc.sndManager.tick();
    }

    public boolean canHurtPlayer() {
        return true;
    }

    public void adjustPlayer(Player player) {
    }

    public boolean useOrPlaceItemStackOnTile(@NotNull Player player, @NotNull World world, @Nullable ItemStack itemstack, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (!player.getGamemode().canInteract()) {
            return false;
        }
        int blockId = world.getBlockId(blockX, blockY, blockZ);
        if (player.getHeldObject() == null) {
            TileEntity tileEntity;
            if (player.isSneaking() && itemstack == null && (tileEntity = world.getTileEntity(blockX, blockY, blockZ)) != null && tileEntity.canBeCarried(world, player)) {
                player.setHeldObject(tileEntity.pickup(world, player));
                return true;
            }
            if ((!player.isSneaking() || itemstack == null) && blockId > 0 && Blocks.blocksList[blockId].onBlockRightClicked(world, blockX, blockY, blockZ, player, side, xPlaced, yPlaced)) {
                return true;
            }
            if (itemstack == null) {
                return false;
            }
            return itemstack.useItem(player, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
        }
        if (!player.isSneaking() && blockId > 0 && Blocks.blocksList[blockId].onBlockRightClicked(world, blockX, blockY, blockZ, player, side, xPlaced, yPlaced)) {
            return true;
        }
        boolean didPlace = player.getHeldObject().tryPlace(world, player, blockX, blockY, blockZ, side, xPlaced, yPlaced);
        if (didPlace) {
            player.setHeldObject(null);
        }
        return didPlace;
    }

    public boolean useItemStackOnNothing(Player player, World world, ItemStack stack) {
        if (!player.getGamemode().canInteract()) {
            return false;
        }
        int prevStackSize = stack.stackSize;
        ItemStack newItemStack = stack.useItemRightClick(world, player);
        if (newItemStack != stack || newItemStack.stackSize != prevStackSize) {
            player.inventory.mainInventory[player.inventory.getCurrentItemIndex()] = newItemStack;
            if (newItemStack == null || newItemStack.stackSize <= 0) {
                player.inventory.mainInventory[player.inventory.getCurrentItemIndex()] = null;
            }
            return true;
        }
        return false;
    }

    public boolean placeItemStackOnTile(@NotNull Player player, @NotNull World world, @Nullable ItemStack itemstack, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (!player.getGamemode().canInteract()) {
            return false;
        }
        if (player.getHeldObject() == null) {
            if (itemstack == null) {
                return false;
            }
            return itemstack.useItem(player, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
        }
        return false;
    }

    public Player createPlayer(World world) {
        return new PlayerLocal(this.mc, world, this.mc.session, world.dimension.id);
    }

    public boolean interact(Player player, Entity entity) {
        if (!player.getGamemode().canInteract()) {
            return false;
        }
        return player.useCurrentItemOnEntity(entity);
    }

    public void attack(Player player, Entity entity) {
        if (!player.getGamemode().canInteract()) {
            return;
        }
        player.attackTargetEntityWithCurrentItem(entity);
    }

    public ItemStack handleInventoryMouseClick(int windowId, InventoryAction action, int[] args, Player player) {
        return player.craftingInventory.clicked(action, args, player);
    }

    public void handleCloseInventory(int i, Player player) {
        player.craftingInventory.onCraftGuiClosed(player);
        player.craftingInventory = player.inventorySlots;
    }

    public void playDigSound(Block<?> block, int x, int y, int z) {
        if (this.soundDelay <= 0) {
            this.mc.currentWorld.playBlockSoundEffect(null, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, block, EnumBlockSoundEffectType.DIG);
            this.soundDelay = 3;
        } else {
            --this.soundDelay;
        }
    }

    protected void syncCurrentPlayItem() {
    }

    public void sendStartDigPacket(int x, int y, int z, Side side, double xHit, double yHit) {
    }

    public void sendDestroyBlockPacket(int x, int y, int z, Side side, double xHit, double yHit) {
    }

    public void initWorld(World world) {
    }

    public void setPaintingType(ArtType art) {
        this.mc.thePlayer.setSelectedArt(art);
    }
}

