/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.pool;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.util.pool.Poolable;
import org.jetbrains.annotations.NotNull;

public class ObjectPool<T extends Poolable<T>> {
    @NotNull
    private static final List<ObjectPool<?>> ALL_POOLS = new ArrayList();
    @NotNull
    private final PooledObjectFactory<T> factory;
    private final List<T> pool = new ArrayList<T>();
    private int poolPointer = 0;

    public static void resetAllPools() {
        for (ObjectPool<?> pool : ALL_POOLS) {
            pool.reset();
        }
    }

    public static void freeAllPools() {
        for (ObjectPool<?> pool : ALL_POOLS) {
            pool.free();
        }
    }

    public ObjectPool(@NotNull PooledObjectFactory<T> factory) {
        this.factory = factory;
        ALL_POOLS.add(this);
    }

    @NotNull
    public T get() {
        return this.getUnpooled();
    }

    @NotNull
    T getUnpooled() {
        return (T)((Poolable)this.factory.createDefault());
    }

    public void reset() {
        this.poolPointer = 0;
    }

    public void free() {
        this.pool.clear();
        this.poolPointer = 0;
    }

    public static interface PooledObjectFactory<T> {
        @NotNull
        public T createDefault();
    }
}

