/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import java.util.Random;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.IVehicle;
import org.lwjgl.opengl.GL11;

public class HudComponentVehicleHealthBar
extends HudComponentMovable {
    private final Random random = new Random();

    public HudComponentVehicleHealthBar(String key, Layout layout) {
        super(key, 81, 10, layout);
    }

    @Override
    public boolean isVisible() {
        return HudComponentVehicleHealthBar.mc.thePlayer.vehicle instanceof Mob && HudComponentVehicleHealthBar.mc.gameSettings.immersiveMode.drawHotbar();
    }

    @Override
    public void render(HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        IVehicle iVehicle = HudComponentVehicleHealthBar.mc.thePlayer.vehicle;
        if (iVehicle instanceof Mob) {
            boolean heartsFlash;
            Mob mobVehicle = (Mob)iVehicle;
            int x = this.getLayout().getComponentX(this, xSizeScreen);
            int y = this.getLayout().getComponentY(this, ySizeScreen);
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GL11.glDisable(3042);
            boolean bl = heartsFlash = mobVehicle.heartsFlashTime / 3 % 2 == 1;
            if (mobVehicle.heartsFlashTime < 10) {
                heartsFlash = false;
            }
            int health = mobVehicle.getHealth();
            int prevHealth = mobVehicle.prevHealth;
            this.random.setSeed((long)hud.updateCounter * 312871L);
            int hearts = MathHelper.ceil((float)mobVehicle.getMaxHealth() / 2.0f);
            for (int i = 0; i < hearts; ++i) {
                boolean heartOffset = false;
                if (heartsFlash) {
                    heartOffset = true;
                }
                int xHeart = x + 72 - i * 8;
                int yHeart = y;
                if (health <= 4) {
                    yHeart += this.random.nextInt(2);
                }
                hud.drawGuiIcon(xHeart, yHeart, 9, 9, !heartOffset ? TextureRegistry.getTexture("minecraft:gui/hud/heart/pig/container") : TextureRegistry.getTexture("minecraft:gui/hud/heart/pig/container_blinking"));
                if (heartsFlash) {
                    if (i * 2 + 1 < prevHealth) {
                        hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/pig/full_blinking"));
                    }
                    if (i * 2 + 1 == prevHealth) {
                        hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/pig/half_blinking"));
                    }
                }
                if (i * 2 + 1 < health) {
                    hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/pig/full"));
                }
                if (i * 2 + 1 != health) continue;
                hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/pig/half"));
            }
        }
    }

    @Override
    public void renderPreview(Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(this, xSizeScreen);
        int y = layout.getComponentY(this, ySizeScreen);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
        int health = 11;
        for (int i = 0; i < 10; ++i) {
            int xHeart = x + i * 8;
            gui.drawGuiIcon(xHeart, y, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/pig/container"));
            if (i * 2 + 1 < health) {
                gui.drawGuiIcon(xHeart, y, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/pig/full"));
            }
            if (i * 2 + 1 != health) continue;
            gui.drawGuiIcon(xHeart, y, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/pig/half"));
        }
    }
}

