/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.Comparator;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.terrain.ChunkRenderer;

public class DirtyChunkRendererSorter
implements Comparator<ChunkRenderer> {
    private final ICamera activeCamera;

    public DirtyChunkRendererSorter(ICamera activeCamera) {
        this.activeCamera = activeCamera;
    }

    @Override
    public int compare(ChunkRenderer cr1, ChunkRenderer cr2) {
        double cr2Distance;
        boolean cr1InFrustum = cr1.visible;
        boolean cr2InFrustum = cr2.visible;
        if (cr1.equals(cr2)) {
            return 0;
        }
        if (cr1InFrustum && !cr2InFrustum) {
            return 1;
        }
        if (cr2InFrustum && !cr1InFrustum) {
            return -1;
        }
        double cr1Distance = cr1.distanceToCameraSquared(this.activeCamera);
        if (cr1Distance < (cr2Distance = (double)cr2.distanceToCameraSquared(this.activeCamera))) {
            return 1;
        }
        if (cr1Distance > cr2Distance) {
            return -1;
        }
        return cr1.id >= cr2.id ? -1 : 1;
    }
}

