/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.AgedMob;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.MobAge;
import net.minecraft.core.entity.animal.MobAnimal;
import net.minecraft.core.entity.monster.MobZombiePig;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class MobPig
extends MobAnimal
implements AgedMob {
    public static final int DATA_SADDLE_ID = 16;
    public List<WeightedRandomLootObject> burningMobDrops = new ArrayList<WeightedRandomLootObject>();
    @NotNull
    private final MobAge age;
    protected float speedProgress = 0.0f;

    public MobPig(World world) {
        super(world);
        this.setTextureIdentifier("minecraft", "pig");
        this.setSize(0.9f, 0.9f);
        this.mobDrops.add(new WeightedRandomLootObject(Items.FOOD_PORKCHOP_RAW.getDefaultStack(), 1, 2));
        this.burningMobDrops.add(new WeightedRandomLootObject(Items.FOOD_PORKCHOP_COOKED.getDefaultStack(), 1, 2));
        this.age = MobAge.newRandom(this, 224, 14, 168);
    }

    @Override
    @NotNull
    public MobAge getMobAge() {
        return this.age;
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(16, (byte)0, Byte.class);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Saddle", this.getSaddled());
        this.age.writeTag(tag);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSaddled(tag.getBoolean("Saddle"));
        this.age.readTag(tag);
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.age.tick(this.world);
    }

    @Override
    protected void updateAI() {
        if (this.passenger instanceof Player) {
            this.target = null;
            this.pathToEntity = null;
            this.moveForward = 0.0f;
            this.moveStrafing = 0.0f;
            float accel = MathHelper.lerp(3.0f, 10.0f, this.speedProgress) * (!this.onGround ? 0.25f : 1.0f) * (this.isInWater() ? 0.5f : 1.0f);
            float maxSpeed = MathHelper.lerp(3.0f, 10.0f, this.speedProgress) * (!this.onGround && !(this.yd < 0.0) ? 0.25f : 1.0f) * (this.isInWater() ? 0.5f : 1.0f);
            double pXd = MathHelper.clamp(this.passenger.xd, -0.02, 0.02);
            double pZd = MathHelper.clamp(this.passenger.zd, -0.02, 0.02);
            this.xd += pXd * (double)accel;
            this.zd += pZd * (double)accel;
            this.xd = MathHelper.clamp(this.xd, (double)(-maxSpeed), (double)maxSpeed);
            this.zd = MathHelper.clamp(this.zd, (double)(-maxSpeed), (double)maxSpeed);
            this.xRot = this.passenger.xRot;
            this.yRot = this.passenger.yRot;
            this.yBodyRot = this.passenger.yRot;
            boolean bl = this.isJumping = this.isInWater() || ((Player)this.passenger).isJumping();
            if ((this.onGround || this.yd < 0.0) && !this.isInWater() && !this.isJumping) {
                if (pXd * pXd + pZd * pZd > (double)5.0E-6f) {
                    this.speedProgress += 0.005f;
                    this.speedProgress *= 1.025f;
                } else {
                    this.speedProgress *= 0.9f;
                }
                this.speedProgress = MathHelper.clamp(this.speedProgress, 0.0f, 1.0f);
            } else {
                this.speedProgress = 0.0f;
            }
        } else {
            this.footSize = 0.5f;
            super.updateAI();
        }
    }

    @Override
    public void positionRider() {
        super.positionRider();
        if (this.passenger instanceof Player) {
            ((Player)this.passenger).yBodyRotO = this.yBodyRotO;
            ((Player)this.passenger).yBodyRot = this.yBodyRot;
            this.passenger.walkDist = this.walkDist;
            this.passenger.walkDistO = this.walkDistO;
            double velocity = MathHelper.sqrt(this.xd * this.xd + this.zd * this.zd);
            double pitch = (float)Math.atan(-this.yd * 0.2) * 15.0f;
            if (velocity > (double)0.1f) {
                velocity = 0.1f;
            }
            if (!this.onGround || this.getHealth() <= 0) {
                velocity = 0.0;
            }
            if (this.onGround || this.getHealth() <= 0) {
                pitch = 0.0;
            }
            ((Player)this.passenger).cameraVelocity += (float)((velocity - (double)((Player)this.passenger).cameraVelocity) * (double)0.4f);
            ((Player)this.passenger).cameraPitch += (float)((pitch - (double)this.cameraPitch) * (double)0.8f);
        }
    }

    @Override
    public String getLivingSound() {
        return "mob.pig";
    }

    @Override
    protected String getHurtSound() {
        return "mob.pig";
    }

    @Override
    protected String getDeathSound() {
        return "mob.pigdeath";
    }

    @Override
    public boolean interact(@NotNull Player player) {
        if (super.interact(player)) {
            return true;
        }
        ItemStack heldItem = player.getHeldItem();
        if (heldItem != null && (heldItem.itemID == Blocks.MUSHROOM_BROWN.id() || heldItem.itemID == Blocks.MUSHROOM_RED.id()) && heldItem.consumeItem(player)) {
            this.heal(4);
            return true;
        }
        if (!this.world.isClientSide && this.getSaddled()) {
            if (player.isSneaking() && this.passenger == null) {
                this.setSaddled(false);
                ItemStack toInsert = new ItemStack(Items.SADDLE);
                player.inventory.insertItem(toInsert, true);
                if (toInsert.stackSize > 0) {
                    this.dropItem(toInsert, 0.0f);
                }
                return true;
            }
            if (this.passenger == null || this.passenger == player) {
                player.startRiding(this);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean canDespawn() {
        return super.canDespawn() && !this.getSaddled();
    }

    @Override
    protected void dropDeathItems() {
        if (this.getSaddled()) {
            this.dropItem(Items.SADDLE.id, 1);
        }
        super.dropDeathItems();
    }

    @Override
    protected List<WeightedRandomLootObject> getMobDrops() {
        if (this.remainingFireTicks > 0) {
            return this.burningMobDrops;
        }
        return this.mobDrops;
    }

    public boolean getSaddled() {
        return (this.entityData.getByte(16) & 1) != 0;
    }

    public void setSaddled(boolean flag) {
        if (flag) {
            this.entityData.set(16, (byte)1);
        } else {
            this.entityData.set(16, (byte)0);
        }
    }

    @Override
    public void thunderHit(EntityLightning bolt) {
        if (!this.world.isClientSide) {
            MobZombiePig pigZombie = new MobZombiePig(this.world);
            pigZombie.moveTo(this.x, this.y, this.z, this.yRot, this.xRot);
            this.world.entityJoinedWorld(pigZombie);
            this.remove();
            if (this.passenger != null) {
                this.passenger.startRiding(pigZombie);
            }
        }
    }

    @Override
    protected void causeFallDamage(float distance) {
        super.causeFallDamage(distance);
        if (distance > 5.0f && this.passenger instanceof Player) {
            ((Player)this.passenger).triggerAchievement(Achievements.FLY_PIG);
        }
    }

    @Override
    public boolean isFavouriteItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.itemID >= Blocks.blocksList.length) {
            return false;
        }
        return Blocks.blocksList[itemStack.itemID].hasTag(BlockTags.PIGS_FAVOURITE_BLOCK);
    }
}

