/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.gui.components;

import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.minecraft.core.Global;
import org.slf4j.Logger;
import org.useless.seedviewer.gui.SeedViewer;

public class InputPanel
extends JPanel {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private final SeedViewer seedViewer;
    public JLabel titleLabel;
    public JCheckBox slimeChunksBox;
    public JCheckBox showBordersBox;
    public JCheckBox showBiomesBox;
    public JCheckBox showTerrainBox;
    public JCheckBox showCrosshairBox;
    public JTextField seedInputBox;
    public JButton screenshot;
    public JButton openWorld;
    public JButton closeWorld;
    private final List<Component> resizeList = new ArrayList<Component>();

    public InputPanel(SeedViewer seedViewer) {
        this.seedViewer = seedViewer;
        this.setLayout(null);
        this.setBorder(new LineBorder(Color.BLACK, 1));
    }

    public void setup() {
        int boxHeight = 15;
        int textHeight = 15;
        int textFieldHeight = 30;
        int button = 30;
        this.titleLabel = new JLabel("User Controls: ");
        this.titleLabel.setSize(0, 15);
        this.add(this.titleLabel);
        this.slimeChunksBox = new JCheckBox("Slime Chunks");
        this.slimeChunksBox.setSize(0, 15);
        this.slimeChunksBox.setSelected(this.seedViewer.viewport.showSlimeChunks.get());
        this.slimeChunksBox.addChangeListener(e -> this.seedViewer.viewport.showSlimeChunks.set(this.slimeChunksBox.isSelected()));
        this.slimeChunksBox.addChangeListener(e -> this.seedViewer.viewport.repaint());
        this.showBordersBox = new JCheckBox("Chunk Borders");
        this.showBordersBox.setSize(0, 15);
        this.showBordersBox.setSelected(this.seedViewer.viewport.showChunkBorders.get());
        this.showBordersBox.addChangeListener(e -> this.seedViewer.viewport.showChunkBorders.set(this.showBordersBox.isSelected()));
        this.showBordersBox.addChangeListener(e -> this.seedViewer.viewport.repaint());
        this.showBiomesBox = new JCheckBox("Show Biomes");
        this.showBiomesBox.setSize(0, 15);
        this.showBiomesBox.setSelected(this.seedViewer.viewport.showBiomes.get());
        this.showBiomesBox.addChangeListener(e -> this.seedViewer.viewport.showBiomes.set(this.showBiomesBox.isSelected()));
        this.showBiomesBox.addChangeListener(e -> this.seedViewer.viewport.repaint());
        this.showTerrainBox = new JCheckBox("Show Terrain");
        this.showTerrainBox.setSize(0, 15);
        this.showTerrainBox.setSelected(this.seedViewer.viewport.showTerrain.get());
        this.showTerrainBox.addChangeListener(e -> this.seedViewer.viewport.showTerrain.set(this.showTerrainBox.isSelected()));
        this.showTerrainBox.addChangeListener(e -> this.seedViewer.viewport.repaint());
        this.showCrosshairBox = new JCheckBox("Enable Cross-hair");
        this.showCrosshairBox.setSize(0, 15);
        this.showCrosshairBox.setSelected(this.seedViewer.viewport.showCrosshair.get());
        this.showCrosshairBox.addChangeListener(e -> this.seedViewer.viewport.showCrosshair.set(this.showCrosshairBox.isSelected()));
        this.showCrosshairBox.addChangeListener(e -> this.seedViewer.viewport.repaint());
        this.addManaged(this.slimeChunksBox);
        this.addManaged(this.showBordersBox);
        this.addManaged(this.showBiomesBox);
        this.addManaged(this.showTerrainBox);
        this.addManaged(this.showCrosshairBox);
        this.seedInputBox = new JTextField(this.seedViewer.viewport.seed.toString());
        this.seedInputBox.setSize(0, 30);
        this.seedInputBox.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long boxSeed;
                try {
                    boxSeed = Long.parseLong(InputPanel.this.seedInputBox.getText());
                }
                catch (NumberFormatException exception) {
                    boxSeed = InputPanel.this.seedInputBox.getText().hashCode();
                }
                if (boxSeed != InputPanel.this.seedViewer.viewport.seed.get()) {
                    InputPanel.this.seedViewer.viewport.setSeed(boxSeed);
                }
            }
        });
        this.addManaged(this.seedInputBox);
        this.screenshot = new JButton("Save Screenshot");
        this.screenshot.setSize(0, 30);
        this.screenshot.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File defaultFile;
                File screenShotFolder = new File(Global.accessor.getMinecraftDir(), "screenshots");
                screenShotFolder.mkdirs();
                JFileChooser screenShotSelect = new JFileChooser(screenShotFolder);
                String name = "Seed-Viewer-" + dateFormat.format(new Date());
                int k = 1;
                while ((defaultFile = new File(screenShotFolder, name + (String)(k != 1 ? "_" + k : "") + ".png")).exists()) {
                    ++k;
                }
                screenShotSelect.setSelectedFile(defaultFile);
                screenShotSelect.setDialogTitle("Save Screenshot");
                screenShotSelect.setApproveButtonText("Save");
                screenShotSelect.setFileSelectionMode(0);
                screenShotSelect.addChoosableFileFilter(new FileNameExtensionFilter("Image (*.png)", "png"));
                screenShotSelect.setAcceptAllFileFilterUsed(true);
                int result = screenShotSelect.showOpenDialog(InputPanel.this.seedViewer);
                if (result == 0) {
                    File destFile = screenShotSelect.getSelectedFile();
                    LOGGER.info("Selected file: {}", (Object)destFile.getAbsolutePath());
                    BufferedImage viewportImage = new BufferedImage(InputPanel.this.seedViewer.viewport.getWidth(), InputPanel.this.seedViewer.viewport.getHeight(), 2);
                    Graphics g = viewportImage.getGraphics();
                    InputPanel.this.seedViewer.viewport.paintToGraphics(g);
                    g.dispose();
                    LOGGER.info("Attempting to save screenshot to '{}'!", (Object)destFile);
                    try {
                        destFile.createNewFile();
                        String[] dotSep = destFile.getName().split("\\.");
                        ImageIO.write((RenderedImage)viewportImage, dotSep[dotSep.length - 1], destFile);
                    }
                    catch (IOException ex) {
                        LOGGER.error("Failed to save screenshot to '{}'!", (Object)destFile, (Object)ex);
                    }
                }
            }
        });
        this.addManaged(this.screenshot);
        this.openWorld = new JButton("Open World");
        this.openWorld.setSize(0, 30);
        this.openWorld.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser worldSelector = new JFileChooser(new File(Global.accessor.getMinecraftDir(), "saves/"));
                worldSelector.setDialogTitle("Select World");
                worldSelector.setFileSelectionMode(1);
                worldSelector.setAcceptAllFileFilterUsed(false);
                int result = worldSelector.showOpenDialog(InputPanel.this.seedViewer);
                if (result == 0) {
                    File selectedFile = worldSelector.getSelectedFile();
                    LOGGER.info("Selected file: {}", (Object)selectedFile.getAbsolutePath());
                    InputPanel.this.seedViewer.viewport.setWorld(selectedFile);
                } else {
                    InputPanel.this.seedViewer.viewport.setWorld(null);
                }
            }
        });
        this.seedViewer.viewport.world.addChangeListener(newValue -> {
            if (newValue != null) {
                this.onWorldOpen();
                this.seedViewer.queueResize();
            } else {
                this.onWorldClose();
                this.seedViewer.queueResize();
            }
        });
        this.addManaged(this.openWorld);
        this.closeWorld = new JButton("Close World");
        this.closeWorld.setSize(0, 30);
        this.closeWorld.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputPanel.this.seedViewer.viewport.setWorld(null);
            }
        });
        this.addManaged(this.closeWorld);
        if (this.seedViewer.viewport.world.get() == null) {
            this.onWorldClose();
        } else {
            this.onWorldOpen();
        }
    }

    public void onWorldOpen() {
        this.seedInputBox.setEnabled(false);
        this.seedInputBox.setVisible(false);
        this.closeWorld.setEnabled(true);
        this.closeWorld.setVisible(true);
        this.showTerrainBox.setEnabled(true);
        this.showTerrainBox.setVisible(true);
    }

    public void onWorldClose() {
        this.seedInputBox.setEnabled(true);
        this.seedInputBox.setVisible(true);
        this.closeWorld.setEnabled(false);
        this.closeWorld.setVisible(false);
        this.showTerrainBox.setEnabled(false);
        this.showTerrainBox.setVisible(false);
    }

    public void addManaged(Component c) {
        this.add(c);
        this.resizeList.add(c);
    }

    public void onResize(Rectangle newDimensions) {
        this.setBounds(newDimensions.x, newDimensions.y, newDimensions.width, newDimensions.height);
        int edgePad = 5;
        int elementPad = 2;
        this.titleLabel.setBounds(5, 5, newDimensions.width - 10, this.titleLabel.getHeight());
        int lastY = this.titleLabel.getY() + this.titleLabel.getHeight() + 10;
        for (Component c : this.resizeList) {
            if (!c.isVisible()) continue;
            c.setBounds(5, lastY, newDimensions.width - 10, c.getHeight());
            lastY += c.getHeight() + 2;
        }
    }
}

