/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.paged;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.paged.PageComponent;
import net.minecraft.core.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Page {
    private static final int COMPONENT_SPACING = 4;
    @NotNull
    private final String translationKey;
    @NotNull
    private final @NotNull List<@NotNull PageComponent> components = new ArrayList<PageComponent>();
    @NotNull
    private final ItemStack icon;

    public Page(@NotNull String translationKey, @NotNull ItemStack icon) {
        this.translationKey = translationKey;
        this.icon = icon;
    }

    @NotNull
    public Page withComponent(@NotNull PageComponent component) {
        this.components.add(component);
        return this;
    }

    @NotNull
    public String getTranslationKey() {
        return this.translationKey;
    }

    @NotNull
    public @NotNull List<@NotNull PageComponent> getComponents() {
        return this.components;
    }

    public void initComponents(@NotNull Minecraft mc) {
        for (PageComponent component : this.components) {
            component.init(mc);
        }
    }

    public int getHeight() {
        int height = 0;
        for (PageComponent component : this.components) {
            height += component.getHeight() + 4;
        }
        return height -= 4;
    }

    @NotNull
    public ItemStack getIcon() {
        return this.icon;
    }
}

