/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.input.InputDevice;
import net.minecraft.client.option.GameSettings;
import net.minecraft.core.lang.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyBinding {
    private static Map<Character, InputDevice> charToInputDeviceMap = new HashMap<Character, InputDevice>();
    private static Map<InputDevice, Character> inputDeviceToCharMap = new HashMap<InputDevice, Character>();
    private final String id;
    @Nullable
    private InputDevice inputDevice;
    private int keyCode = -1;
    @Nullable
    private InputDevice defaultInputDevice = null;
    private int defaultKeyCode = -1;

    public static void addInputDevice(char c, InputDevice inputDevice) {
        if (charToInputDeviceMap.containsKey(Character.valueOf(c))) {
            inputDeviceToCharMap.remove(charToInputDeviceMap.get(Character.valueOf(c)));
        }
        if (inputDeviceToCharMap.containsKey(inputDevice)) {
            charToInputDeviceMap.remove(inputDeviceToCharMap.get(inputDevice));
        }
        charToInputDeviceMap.put(Character.valueOf(c), inputDevice);
        inputDeviceToCharMap.put(inputDevice, Character.valueOf(c));
    }

    public KeyBinding(String id) {
        this.id = id;
        this.inputDevice = null;
        this.keyCode = -1;
        GameSettings.keys.add(this);
    }

    @NotNull
    public KeyBinding setDefault(@Nullable InputDevice device, int keyCode) {
        if (device != null && !device.isKeyCodeValid(keyCode)) {
            throw new RuntimeException("Key code " + keyCode + " is not valid for input device " + String.valueOf(device));
        }
        this.defaultInputDevice = device;
        this.defaultKeyCode = keyCode;
        return this.bind(device, keyCode);
    }

    @NotNull
    public KeyBinding bind(@Nullable InputDevice device, int keyCode) {
        if (device != null && device.isKeyCodeValid(keyCode)) {
            this.keyCode = keyCode;
            this.inputDevice = device;
        } else {
            this.unbind();
        }
        return this;
    }

    @NotNull
    public KeyBinding unbind() {
        this.keyCode = -1;
        this.inputDevice = null;
        return this;
    }

    @NotNull
    public KeyBinding resetToDefault() {
        this.keyCode = this.defaultKeyCode;
        this.inputDevice = this.defaultInputDevice;
        return this;
    }

    public boolean isDefault() {
        return this.keyCode == this.defaultKeyCode && this.inputDevice == this.defaultInputDevice;
    }

    public String getId() {
        return this.id;
    }

    public InputDevice getInputDevice() {
        return this.inputDevice;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public InputDevice getDefaultInputDevice() {
        return this.defaultInputDevice;
    }

    public int getDefaultKeyCode() {
        return this.defaultKeyCode;
    }

    public boolean isPressed() {
        if (this.inputDevice != null) {
            return this.inputDevice.isPressed(this.keyCode);
        }
        return false;
    }

    public boolean isPressEvent(InputDevice eventInputDevice) {
        if (this.inputDevice == eventInputDevice) {
            return this.inputDevice.isPressEvent(this.keyCode);
        }
        return false;
    }

    public boolean isPressEvent() {
        if (this.inputDevice != null) {
            return this.inputDevice.isPressEvent(this.keyCode);
        }
        return false;
    }

    public boolean isReleaseEvent(InputDevice eventInputDevice) {
        if (this.inputDevice == eventInputDevice) {
            return this.inputDevice.isReleaseEvent(this.keyCode);
        }
        return false;
    }

    public boolean isReleaseEvent() {
        if (this.inputDevice != null) {
            return this.inputDevice.isReleaseEvent(this.keyCode);
        }
        return false;
    }

    public void fromOptionsString(String value) {
        int code;
        InputDevice inputDevice;
        if (value.length() == 0) {
            this.unbind();
            return;
        }
        char c = value.charAt(0);
        if (c >= '0' && c <= '9') {
            inputDevice = InputDevice.keyboard;
            code = Integer.parseInt(value);
        } else {
            inputDevice = charToInputDeviceMap.get(Character.valueOf(c));
            code = Integer.parseInt(value.substring(1));
        }
        if (inputDevice == null) {
            this.unbind();
            return;
        }
        this.bind(inputDevice, code);
    }

    public String toOptionsString() {
        Character c = inputDeviceToCharMap.get(this.inputDevice);
        if (c != null) {
            return String.valueOf(c) + this.keyCode;
        }
        return "";
    }

    public boolean isKeyboardKey(int key) {
        if (this.inputDevice == InputDevice.keyboard) {
            return this.keyCode == key;
        }
        return false;
    }

    public boolean isMouseButton(int button) {
        if (this.inputDevice == InputDevice.mouse) {
            return this.keyCode == button;
        }
        return false;
    }

    public boolean isKeyOrMouse(int key, int button) {
        return this.isKeyboardKey(key) || this.isMouseButton(button);
    }

    public boolean isBound() {
        return this.inputDevice != null;
    }

    public String getKeyName() {
        if (this.inputDevice == null) {
            return I18n.getInstance().translateKey("key.disabled");
        }
        String keyName = this.inputDevice.getKeyName(this.keyCode);
        if (keyName == null) {
            keyName = String.valueOf(this.keyCode);
        } else if ("LCONTROL".equals(keyName)) {
            keyName = "LCTRL";
        } else if ("RCONTROL".equals(keyName)) {
            keyName = "RCTRL";
        }
        return keyName;
    }

    static {
        KeyBinding.addInputDevice('m', InputDevice.mouse);
        KeyBinding.addInputDevice('k', InputDevice.keyboard);
    }
}

