/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.keyboard.ScreenKeyboard;
import net.minecraft.client.gui.text.ITextField;
import net.minecraft.client.gui.text.TextFieldEditor;
import net.minecraft.client.input.InputType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.PacketSetItemName;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ScreenLabelEditor
extends Screen
implements ITextField {
    protected String screenTitle = I18n.getInstance().translateKey("gui.edit_label.label.title");
    protected ItemStack item;
    protected String text;
    protected TextFieldEditor editor;
    protected byte color;
    protected int xSize;
    protected int ySize;
    protected int slot;
    protected int cursorCounter;

    public ScreenLabelEditor(ItemStack item, int slot) {
        this.item = item;
        this.text = item.hasCustomName() ? item.getCustomName() : "";
        this.editor = new TextFieldEditor(this);
        this.color = item.getDisplayColor();
        this.xSize = 176;
        this.ySize = 166;
        this.slot = slot;
    }

    @Override
    public void tick() {
        ++this.cursorCounter;
        if ((((Boolean)this.mc.gameSettings.forceOnscreenKeyboard.value).booleanValue() || this.mc.inputType == InputType.CONTROLLER) && !(this.mc.currentScreen instanceof ScreenKeyboard)) {
            this.buttonClicked((ButtonElement)this.buttons.get(0));
        }
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.item.setCustomName(this.text);
            this.mc.displayScreen(null);
            if (this.mc.currentWorld.isClientSide) {
                this.mc.getSendQueue().addToSendQueue(new PacketSetItemName(this.slot, this.text));
            }
        }
    }

    @Override
    public void render(int mx, int my, float f) {
        boolean drawCursor;
        this.renderBackground();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/scroll.png").bind();
        int widthBG = this.width / 2 - 56;
        int heightBG = 89;
        this.drawTexturedModalRect(widthBG, 89, 0, 0, 113, 34);
        this.drawStringCenteredShadow(this.fontRenderer, this.screenTitle, this.width / 2, 40, 0xFFFFFF);
        this.drawStringCenteredShadow(this.fontRenderer, String.valueOf(TextFormatting.get(this.color)) + "> " + this.text + " <", this.width / 2, 100, 0xFFFFFF);
        boolean bl = drawCursor = !this.text.isEmpty() && this.cursorCounter / 6 % 2 == 0;
        if (drawCursor) {
            int width = MathHelper.ceil(this.fontRenderer.stringWidthDouble(this.editor.getText()));
            if (this.editor.getCursor() < this.editor.getText().length()) {
                width = MathHelper.ceil(this.fontRenderer.stringWidthDouble(this.editor.getText().substring(0, this.editor.getCursor())));
            }
            this.drawStringShadow(this.fontRenderer, "_", MathHelper.ceil((double)this.width - this.fontRenderer.stringWidthDouble(this.editor.getText()) / 2.0) + width, 101, 0xFFFFFF);
        }
        super.render(mx, my, f);
    }

    @Override
    public void init() {
        this.buttons.clear();
        Keyboard.enableRepeatEvents(true);
        this.buttons.add(new ButtonElement(0, this.width / 2 - 100, this.height / 4 + 120, I18n.getInstance().translateKey("gui.edit_label.button.done")));
        if (((Boolean)this.mc.gameSettings.forceOnscreenKeyboard.value).booleanValue() || this.mc.inputType == InputType.CONTROLLER) {
            this.mc.displayScreen(new ScreenKeyboard(this, this.editor, s -> {}, (c, k, s) -> {}, s -> {}));
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_RETURN || eventKey == Keyboard.KEY_NUMPADENTER || eventKey == Keyboard.KEY_ESCAPE) {
            this.buttonClicked((ButtonElement)this.buttons.get(0));
            return;
        }
        this.editor.handleInput(eventKey, eventCharacter);
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents(false);
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int maxLength() {
        return 16;
    }
}

