/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.awt.Color;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.entity.particle.ParticleDispatcher;
import net.minecraft.client.entity.particle.ParticleLambda;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.render.CameraSorter;
import net.minecraft.client.render.DirtyChunkRendererSorter;
import net.minecraft.client.render.DisplayList;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelLeaves;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.client.render.worldtype.WorldTypeFXDispatcher;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemDiscMusic;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.BoundingVolume;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.AuroraProvider;
import net.minecraft.core.world.LevelListener;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.GL11;

public class RenderGlobal
implements LevelListener {
    public static IconCoordinate[] breakingAnimation = new IconCoordinate[10];
    public static final int RENDER_CHUNK_SIZE = 16;
    public static final int MAX_VISIBLE_REBUILDS_PER_FRAME = 2;
    public static final int MAX_INVISIBLE_REBUILDS_PER_FRAME = 1;
    public static final int RENDER_LIST_BASE_WIDTH = 48;
    public List<TileEntity> renderableTileEntities = new ArrayList<TileEntity>();
    private WorldClient world;
    private final TextureManager textureManager;
    private final List<ChunkRenderer> dirtyChunks = new ArrayList<ChunkRenderer>();
    private ChunkRenderer[] sortedChunkRenderers;
    private ChunkRenderer[] chunkRenderers;
    private int xChunks;
    private int yChunks;
    private int zChunks;
    private int chunkLists;
    private final Minecraft mc;
    private IntBuffer occlusionCheckIds;
    private boolean occlusionCheck = false;
    private float lastCloudOffsetX = 0.0f;
    private float lastCloudOffsetZ = 0.0f;
    private float cloudOffsetX = 0.0f;
    private float cloudOffsetZ = 0.0f;
    private float cloudVelocityX;
    private float cloudVelocityZ;
    private int ticks;
    private final int starList;
    private final int skyList;
    private int xMinChunk;
    private int yMinChunk;
    private int zMinChunk;
    private int xMaxChunk;
    private int yMaxChunk;
    private int zMaxChunk;
    private Integer renderDistance = null;
    private int noEntityRenderFrames = 2;
    private int totalEntities;
    private int renderedEntities;
    private int culledEntities;
    IntBuffer resultBuffer = GLAllocation.createDirectIntBuffer(64);
    private int totalChunks;
    private int offscreenChunks;
    private int occludedChunks;
    private int renderedChunks;
    private int emptyChunks;
    private int chunkFixOffs;
    private final List<ChunkRenderer> renderChunks = new ArrayList<ChunkRenderer>();
    private final DisplayList[] renderLists = new DisplayList[]{new DisplayList(), new DisplayList(), new DisplayList(), new DisplayList()};
    double xOld = -9999.0;
    double yOld = -9999.0;
    double zOld = -9999.0;
    public float destroyProgress;
    int cullStep = 0;
    private double auroraBrightness = 0.0;
    private double targetAuroraBrightness = Double.NaN;
    private double auroraBrightnessDelta = Double.NaN;
    private double rainbowBrightness = 0.0;
    private double targetRainbowBrightness = Double.NaN;
    private double rainbowBrightnessDelta = Double.NaN;

    public RenderGlobal(Minecraft mc, TextureManager textureManager) {
        this.mc = mc;
        this.textureManager = textureManager;
        this.chunkLists = GLAllocation.generateDisplayLists(221184);
        this.occlusionCheck = OpenGLHelper.enableOcclusionCheck;
        if (this.occlusionCheck) {
            this.resultBuffer.clear();
            this.occlusionCheckIds = GLAllocation.createDirectIntBuffer(110592);
            this.occlusionCheckIds.clear();
            this.occlusionCheckIds.position(0);
            this.occlusionCheckIds.limit(110592);
            ARBOcclusionQuery.glGenQueriesARB(this.occlusionCheckIds);
        }
        this.starList = GLAllocation.generateDisplayLists(3);
        this.updateStars();
        Tessellator t = Tessellator.instance;
        this.skyList = this.starList + 1;
        GL11.glNewList(this.skyList, 4864);
        int s = 64;
        int d = 256 / s + 2;
        float yy = 16.0f;
        for (int xx = -s * d; xx <= s * d; xx += s) {
            for (int zz = -s * d; zz <= s * d; zz += s) {
                t.startDrawingQuads();
                t.addVertex(xx, yy, zz);
                t.addVertex(xx + s, yy, zz);
                t.addVertex(xx + s, yy, zz + s);
                t.addVertex(xx, yy, zz + s);
                t.draw();
            }
        }
        GL11.glEndList();
    }

    public void updateStars() {
        GL11.glPushMatrix();
        GL11.glNewList(this.starList, 4864);
        this.renderStars();
        GL11.glEndList();
        GL11.glPopMatrix();
    }

    private void renderStars() {
        Random random = new Random(10842L);
        Random colorRandom = new Random(10842L);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        for (int i = 0; i < 1500; ++i) {
            double d = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.25f + random.nextFloat() * 0.25f;
            double d4 = d * d + d1 * d1 + d2 * d2;
            if (d4 >= 1.0 || d4 <= 0.01) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double x = (d *= d4) * 100.0;
            double y = (d1 *= d4) * 100.0;
            double z = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d * d + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            double color = colorRandom.nextDouble();
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double yOff = d21 * d12 + d17 * d13;
                double d25 = d17 * d12 - d21 * d13;
                double xOff = d25 * d9 - d22 * d10;
                double zOff = d22 * d9 + d25 * d10;
                tessellator.addVertexWithUV(x + xOff, y + yOff, z + zOff, color, 0.0);
            }
        }
        tessellator.draw();
    }

    public void setWorld(WorldClient world) {
        if (this.world != null) {
            this.world.removeListener(this);
        }
        this.xOld = -9999.0;
        this.yOld = -9999.0;
        this.zOld = -9999.0;
        this.world = world;
        this.auroraBrightness = 0.0;
        this.targetAuroraBrightness = Double.NaN;
        if (world != null) {
            world.addListener(this);
            this.allChanged();
        }
    }

    public void allChanged() {
        ScreenOptions.queueReload = false;
        this.updateStars();
        this.deleteChunkLists();
        this.chunkLists = GLAllocation.generateDisplayLists(221184);
        BlockModelLeaves.setGraphicsLevel((Integer)this.mc.gameSettings.fancyGraphics.value == 1);
        this.renderDistance = (Integer)this.mc.gameSettings.renderDistance.value;
        if (this.world == null) {
            return;
        }
        if (this.chunkRenderers != null) {
            for (ChunkRenderer chunkRenderer : this.chunkRenderers) {
                chunkRenderer.delete();
            }
        }
        int dist = this.renderDistance * 16 * 2;
        this.xChunks = dist / 16 + 1;
        this.yChunks = this.world.getHeightBlocks() / 16;
        this.zChunks = dist / 16 + 1;
        this.chunkRenderers = new ChunkRenderer[this.xChunks * this.yChunks * this.zChunks];
        this.sortedChunkRenderers = new ChunkRenderer[this.xChunks * this.yChunks * this.zChunks];
        int id = 0;
        int count = 0;
        this.xMinChunk = 0;
        this.yMinChunk = 0;
        this.zMinChunk = 0;
        this.xMaxChunk = this.xChunks;
        this.yMaxChunk = this.yChunks;
        this.zMaxChunk = this.zChunks;
        for (ChunkRenderer cr : this.dirtyChunks) {
            cr.dirty = false;
        }
        this.dirtyChunks.clear();
        this.renderableTileEntities.clear();
        for (int x = 0; x < this.xChunks; ++x) {
            for (int y = 0; y < this.yChunks; ++y) {
                for (int z = 0; z < this.zChunks; ++z) {
                    int index = (z * this.yChunks + y) * this.xChunks + x;
                    this.chunkRenderers[index] = this.mc.terrainRenderer.createChunkRenderer(this.world, this.renderableTileEntities, x * 16, y * 16, z * 16, 16, this.chunkLists + id);
                    if (this.occlusionCheck) {
                        this.chunkRenderers[index].occlusionId = this.occlusionCheckIds.get(count);
                    }
                    this.chunkRenderers[index].occlusionQuerying = false;
                    this.chunkRenderers[index].occlusionVisible = true;
                    this.chunkRenderers[index].visible = true;
                    this.chunkRenderers[index].id = count++;
                    this.chunkRenderers[index].setDirty();
                    this.sortedChunkRenderers[index] = this.chunkRenderers[index];
                    this.dirtyChunks.add(this.chunkRenderers[index]);
                    id += 3;
                }
            }
        }
        if (this.world != null && this.mc.activeCamera != null) {
            this.resortChunks(MathHelper.floor(this.mc.activeCamera.getX()), MathHelper.floor(this.mc.activeCamera.getY()), MathHelper.floor(this.mc.activeCamera.getZ()));
            Arrays.sort(this.sortedChunkRenderers, new CameraSorter(this.mc.activeCamera));
        }
        this.noEntityRenderFrames = 2;
    }

    public void renderAurora(ICamera camera, float partialTick) {
        float celestialAngle = this.world.getCelestialAngle(partialTick);
        if (celestialAngle < 0.25f) {
            return;
        }
        double cameraX = camera.getX(partialTick);
        double cameraY = camera.getY(partialTick);
        double cameraZ = camera.getZ(partialTick);
        double cameraYaw = camera.getYRot(partialTick);
        double temperature = this.world.getBlockTemperature((int)cameraX, (int)cameraZ);
        float mult = 0.0f;
        if ((temperature <= (double)0.4f || this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER_ENDLESS) && this.world.isChunkLoaded((int)cameraX, (int)cameraZ)) {
            temperature /= (double)0.4f;
            temperature = -temperature + 1.0;
            mult = (float)((double)mult + temperature);
        }
        double altitude = this.world.getWorldType().getYPercentage((int)cameraY);
        if ((temperature <= (double)0.6f || this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER || this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER_ENDLESS) && altitude >= (double)0.8f) {
            if ((altitude -= (double)0.8f) > (double)0.1f) {
                altitude = 0.1f;
            }
            mult = (float)((double)mult + altitude);
        }
        if (mult < 0.0f) {
            mult = 0.0f;
        }
        if (mult > 1.0f) {
            mult = 1.0f;
        }
        if (Double.isNaN(this.targetAuroraBrightness)) {
            this.auroraBrightness = mult;
        }
        this.targetAuroraBrightness = mult;
        double totalDelta = this.targetAuroraBrightness - this.auroraBrightness;
        this.auroraBrightnessDelta = totalDelta / 100.0;
        this.auroraBrightness += this.auroraBrightnessDelta * (double)partialTick;
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glDisable(2896);
        GL11.glEnable(2929);
        GL11.glDepthFunc(519);
        GL11.glDisable(2912);
        GL11.glDisable(3008);
        double scale = 1.0;
        double auroraY = ((float)(this.world.getWorldType().getMinY() + this.world.getWorldType().getYRange()) + 64.0f) * 2.0f;
        double rotationX = Math.cos(cameraYaw * Math.PI / 180.0);
        double rotationZ = Math.sin(cameraYaw * Math.PI / 180.0);
        this.textureManager.bindTexture(this.textureManager.loadTexture("/assets/minecraft/textures/environment/aurora.png"));
        double time = (float)this.world.getWorldTime() + partialTick;
        AuroraProvider aurora = this.world.auroraProvider;
        double radius = 512.0;
        long worldTime = this.world.getWorldTime();
        Tessellator.instance.startDrawingQuads();
        for (double x = -radius; x < radius; x += 8.0) {
            for (double z = -radius; z < radius; z += 8.0) {
                double posX = cameraX + x;
                double posZ = cameraZ + z;
                double distanceSq = x * x + z + z;
                double distanceSqPercentage = distanceSq / (radius * radius + radius * radius);
                distanceSqPercentage = 1.0 - distanceSqPercentage;
                double sample = aurora.getAuroraPresence(posX, posZ, worldTime, celestialAngle) * this.auroraBrightness;
                if (sample * (double)0.3f * distanceSqPercentage < (double)0.01f) continue;
                this.renderAuroraBeam(x * 1.0, auroraY * 1.0 - cameraY * 1.0 + aurora.getAuroraHeightOffset(posX, posZ, time), z * 1.0, rotationX, rotationZ, aurora.getAuroraRedOffset(posX, posZ, time), aurora.getAuroraGreenOffset(posX, posZ, time), aurora.getAuroraBlueOffset(posX, posZ, time), 1.0, (float)(sample * (double)0.3f * distanceSqPercentage));
            }
        }
        Tessellator.instance.draw();
        GL11.glEnable(2912);
        GL11.glEnable(3008);
        GL11.glDepthFunc(515);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
        GL11.glDisable(2896);
    }

    private void renderAuroraBeam(double x, double y, double z, double xOffset, double zOffset, float redOffset, float greenOffset, float blueOffset, double scale, float transparency) {
        float width = 16.0f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.setColorRGBA_F(0.0f + redOffset, 1.0f + greenOffset, 0.49803922f + blueOffset, transparency);
        tessellator.addVertexWithUV(x - xOffset * scale * (double)width, y - scale * 256.0, z - zOffset * scale * (double)width, 1.0, 1.0);
        tessellator.addVertexWithUV(x - xOffset * scale * (double)width, y + scale, z - zOffset * scale * (double)width, 1.0, 0.0);
        tessellator.addVertexWithUV(x + xOffset * scale * (double)width, y + scale, z + zOffset * scale * (double)width, 0.0, 0.0);
        tessellator.addVertexWithUV(x + xOffset * scale * (double)width, y - scale * 256.0, z + zOffset * scale * (double)width, 0.0, 1.0);
    }

    public void renderEntities(ICamera camera, float partialTick) {
        Entity entity;
        int i;
        if (this.noEntityRenderFrames > 0) {
            --this.noEntityRenderFrames;
            return;
        }
        TileEntityRenderDispatcher.instance.cacheActiveRenderInfo(this.world, camera, partialTick);
        EntityRenderDispatcher.instance.cacheActiveRenderInfo(this.world, camera, partialTick);
        this.totalEntities = 0;
        this.renderedEntities = 0;
        this.culledEntities = 0;
        EntityRenderDispatcher.renderPosX = camera.getX(partialTick);
        EntityRenderDispatcher.renderPosY = camera.getY(partialTick);
        EntityRenderDispatcher.renderPosZ = camera.getZ(partialTick);
        TileEntityRenderDispatcher.renderPosX = camera.getX(partialTick);
        TileEntityRenderDispatcher.renderPosY = camera.getY(partialTick);
        TileEntityRenderDispatcher.renderPosZ = camera.getZ(partialTick);
        List<Entity> loadedEntities = this.world.getLoadedEntityList();
        this.totalEntities = loadedEntities.size();
        Tessellator tessellator = Tessellator.instance;
        for (i = 0; i < this.world.weatherEffects.size(); ++i) {
            entity = (Entity)this.world.weatherEffects.get(i);
            ++this.renderedEntities;
            if (!entity.shouldRender(camera.getPosition(partialTick), 1.0) && this.mc.thePlayer.vehicle != entity) continue;
            EntityRenderDispatcher.instance.renderEntity(tessellator, entity, partialTick);
        }
        for (i = 0; i < loadedEntities.size(); ++i) {
            entity = loadedEntities.get(i);
            if (this.mc.activeCamera != null && this.mc.activeCamera instanceof EntityCamera && ((EntityCamera)this.mc.activeCamera).mob == entity && !this.mc.activeCamera.showPlayer() || this.mc.thePlayer.vehicle != entity && (!entity.shouldRender(camera.getPosition(partialTick), 1.0) || !entity.ignoreFrustumCheck && !camera.getFrustum().isVisible(EntityRenderDispatcher.instance.getRenderer(entity).entityViewBox(entity), partialTick))) continue;
            int floorY = MathHelper.floor(entity.y);
            if (floorY < 0) {
                floorY = 0;
            }
            if (floorY >= this.world.getHeightBlocks()) {
                floorY = this.world.getHeightBlocks() - 1;
            }
            if (!this.world.isBlockLoaded(MathHelper.floor(entity.x), floorY, MathHelper.floor(entity.z)) && this.mc.thePlayer.vehicle != entity) continue;
            ++this.renderedEntities;
            EntityRenderDispatcher.instance.renderEntity(tessellator, entity, partialTick);
        }
        int tileEntitiesSize = this.renderableTileEntities.size();
        for (i = 0; i < tileEntitiesSize; ++i) {
            TileEntity tileEntity = this.renderableTileEntities.get(i);
            TileEntityRenderDispatcher.instance.renderTileEntity(tessellator, camera, tileEntity, partialTick);
        }
    }

    public String getRendererDebugInfo() {
        return "C: " + this.renderedChunks + "/" + this.totalChunks + ". F: " + this.offscreenChunks + ", O: " + this.occludedChunks + ", E: " + this.emptyChunks;
    }

    public String getEntityDebugInfo() {
        return "E: " + this.renderedEntities + "/" + this.totalEntities + ". B: " + this.culledEntities + ", I: " + (this.totalEntities - this.culledEntities - this.renderedEntities);
    }

    public void resortChunks(int xc, int yc, int zc) {
        xc -= 8;
        zc -= 8;
        this.xMinChunk = Integer.MAX_VALUE;
        this.yMinChunk = Integer.MAX_VALUE;
        this.zMinChunk = Integer.MAX_VALUE;
        this.xMaxChunk = Integer.MIN_VALUE;
        this.yMaxChunk = Integer.MIN_VALUE;
        this.zMaxChunk = Integer.MIN_VALUE;
        int s2 = this.xChunks * 16;
        int s1 = s2 / 2;
        for (int x = 0; x < this.xChunks; ++x) {
            int xx = x * 16;
            int xOff = xx + s1 - xc;
            if (xOff < 0) {
                xOff -= s2 - 1;
            }
            if ((xx -= (xOff /= s2) * s2) < this.xMinChunk) {
                this.xMinChunk = xx;
            }
            if (xx > this.xMaxChunk) {
                this.xMaxChunk = xx;
            }
            for (int z = 0; z < this.zChunks; ++z) {
                int zz = z * 16;
                int zOff = zz + s1 - zc;
                if (zOff < 0) {
                    zOff -= s2 - 1;
                }
                if ((zz -= (zOff /= s2) * s2) < this.zMinChunk) {
                    this.zMinChunk = zz;
                }
                if (zz > this.zMaxChunk) {
                    this.zMaxChunk = zz;
                }
                for (int y = 0; y < this.yChunks; ++y) {
                    int yy = y * 16;
                    if (yy < this.yMinChunk) {
                        this.yMinChunk = yy;
                    }
                    if (yy > this.yMaxChunk) {
                        this.yMaxChunk = yy;
                    }
                    ChunkRenderer renderer = this.chunkRenderers[(z * this.yChunks + y) * this.xChunks + x];
                    boolean wasDirty = renderer.dirty;
                    renderer.setPos(xx, yy, zz);
                    if (wasDirty || !renderer.dirty) continue;
                    this.dirtyChunks.add(renderer);
                }
            }
        }
    }

    public int render(ICamera camera, int renderPass, double partialTick) {
        double zd;
        double yd;
        for (int i = 0; i < 10; ++i) {
            this.chunkFixOffs = (this.chunkFixOffs + 1) % this.chunkRenderers.length;
            ChunkRenderer chunkRenderer = this.chunkRenderers[this.chunkFixOffs];
            if (!chunkRenderer.dirty || this.dirtyChunks.contains(chunkRenderer)) continue;
            this.dirtyChunks.add(chunkRenderer);
        }
        if (this.mc.gameSettings.renderDistance.value != this.renderDistance) {
            this.allChanged();
        }
        if (renderPass == 0) {
            this.totalChunks = 0;
            this.offscreenChunks = 0;
            this.occludedChunks = 0;
            this.renderedChunks = 0;
            this.emptyChunks = 0;
        }
        double xOff = camera.getX((float)partialTick);
        double yOff = camera.getY((float)partialTick);
        double zOff = camera.getZ((float)partialTick);
        double xd = camera.getX() - this.xOld;
        if (xd * xd + (yd = camera.getY() - this.yOld) * yd + (zd = camera.getZ() - this.zOld) * zd > 16.0) {
            this.xOld = camera.getX();
            this.yOld = camera.getY();
            this.zOld = camera.getZ();
            this.resortChunks(MathHelper.floor(camera.getX()), MathHelper.floor(camera.getY()), MathHelper.floor(camera.getZ()));
            Arrays.sort(this.sortedChunkRenderers, new CameraSorter(camera));
        }
        Lighting.disable();
        int count = 0;
        if (this.occlusionCheck && ((Boolean)this.mc.gameSettings.advancedOpenGL.value).booleanValue() && renderPass == 0) {
            int from = 0;
            int to = 16;
            this.checkQueryResults(from, to);
            for (int i = from; i < to; ++i) {
                this.sortedChunkRenderers[i].occlusionVisible = true;
            }
            count += this.renderChunks(from, to, renderPass, partialTick);
            do {
                from = to;
                if ((to *= 2) > this.sortedChunkRenderers.length) {
                    to = this.sortedChunkRenderers.length;
                }
                GL11.glDisable(3553);
                GL11.glDisable(2896);
                GL11.glDisable(3008);
                GL11.glDisable(2912);
                GL11.glColorMask(false, false, false, false);
                GL11.glDepthMask(false);
                this.checkQueryResults(from, to);
                GL11.glPushMatrix();
                float xo = 0.0f;
                float yo = 0.0f;
                float zo = 0.0f;
                for (int ix = from; ix < to; ++ix) {
                    float dist;
                    int frequency;
                    if (this.sortedChunkRenderers[ix].isEmpty()) {
                        this.sortedChunkRenderers[ix].visible = false;
                        continue;
                    }
                    if (!this.sortedChunkRenderers[ix].visible) {
                        this.sortedChunkRenderers[ix].occlusionVisible = true;
                    }
                    if (!this.sortedChunkRenderers[ix].visible || this.sortedChunkRenderers[ix].occlusionQuerying || this.ticks % (frequency = (int)(1.0f + (dist = MathHelper.sqrt_float(this.sortedChunkRenderers[ix].distanceToCameraSquared(camera))) / 128.0f)) != ix % frequency) continue;
                    ChunkRenderer chunkRenderer = this.sortedChunkRenderers[ix];
                    float xt = (float)((double)chunkRenderer.xRender - xOff);
                    float yt = (float)((double)chunkRenderer.yRender - yOff);
                    float zt = (float)((double)chunkRenderer.zRender - zOff);
                    float xdd = xt - xo;
                    float ydd = yt - yo;
                    float zdd = zt - zo;
                    if (xdd != 0.0f || ydd != 0.0f || zdd != 0.0f) {
                        GL11.glTranslatef(xdd, ydd, zdd);
                        xo += xdd;
                        yo += ydd;
                        zo += zdd;
                    }
                    ARBOcclusionQuery.glBeginQueryARB(35092, this.sortedChunkRenderers[ix].occlusionId);
                    this.sortedChunkRenderers[ix].renderBB();
                    ARBOcclusionQuery.glEndQueryARB(35092);
                    this.sortedChunkRenderers[ix].occlusionQuerying = true;
                }
                GL11.glPopMatrix();
                GL11.glColorMask(true, true, true, true);
                GL11.glDepthMask(true);
                GL11.glEnable(3553);
                GL11.glEnable(3008);
                GL11.glEnable(2912);
                count += this.renderChunks(from, to, renderPass, partialTick);
            } while (to < this.sortedChunkRenderers.length);
        } else {
            count += this.renderChunks(0, this.sortedChunkRenderers.length, renderPass, partialTick);
        }
        return count;
    }

    private void checkQueryResults(int from, int to) {
        for (int i = from; i < to; ++i) {
            if (!this.sortedChunkRenderers[i].occlusionQuerying) continue;
            this.resultBuffer.clear();
            ARBOcclusionQuery.glGetQueryObjectuivARB(this.sortedChunkRenderers[i].occlusionId, 34919, this.resultBuffer);
            if (this.resultBuffer.get(0) == 0) continue;
            this.sortedChunkRenderers[i].occlusionQuerying = false;
            this.resultBuffer.clear();
            ARBOcclusionQuery.glGetQueryObjectuivARB(this.sortedChunkRenderers[i].occlusionId, 34918, this.resultBuffer);
            this.sortedChunkRenderers[i].occlusionVisible = this.resultBuffer.get(0) != 0;
        }
    }

    private int renderChunks(int from, int to, int renderPass, double partialTick) {
        this.renderChunks.clear();
        int count = 0;
        for (int i = from; i < to; ++i) {
            int list;
            if (renderPass == 0) {
                ++this.totalChunks;
                if (this.sortedChunkRenderers[i].empty[renderPass]) {
                    ++this.emptyChunks;
                } else if (!this.sortedChunkRenderers[i].visible) {
                    ++this.offscreenChunks;
                } else if (this.occlusionCheck && !this.sortedChunkRenderers[i].occlusionVisible) {
                    ++this.occludedChunks;
                } else {
                    ++this.renderedChunks;
                }
            }
            if (this.sortedChunkRenderers[i].empty[renderPass] || !this.sortedChunkRenderers[i].visible || this.occlusionCheck && !this.sortedChunkRenderers[i].occlusionVisible || (list = this.sortedChunkRenderers[i].getList(renderPass)) < 0) continue;
            this.renderChunks.add(this.sortedChunkRenderers[i]);
            ++count;
        }
        double xOff = this.mc.activeCamera.getX((float)partialTick);
        double yOff = this.mc.activeCamera.getY((float)partialTick);
        double zOff = this.mc.activeCamera.getZ((float)partialTick);
        int lists = 0;
        for (DisplayList displayList : this.renderLists) {
            displayList.clear();
        }
        for (ChunkRenderer renderer : this.renderChunks) {
            int list = -1;
            for (int i = 0; i < lists; ++i) {
                if (!this.renderLists[i].isSetToPos(renderer.xRender, renderer.yRender, renderer.zRender)) continue;
                list = i;
            }
            if (list < 0) {
                list = lists++;
                this.renderLists[list].setToPos(renderer.xRender, renderer.yRender, renderer.zRender, xOff, yOff, zOff);
            }
            this.renderLists[list].addCallToList(renderer.getList(renderPass));
        }
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
            GL11.glDisable(2912);
        }
        this.renderSameAsLast(renderPass, partialTick);
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
            GL11.glEnable(2912);
        }
        return count;
    }

    public void renderSameAsLast(int renderPass, double partialTick) {
        for (DisplayList displayList : this.renderLists) {
            displayList.call();
        }
    }

    public void tick() {
        float windDirection = this.world.worldType.getWindManager().getWindDirection(this.world, 0.0f, 500.0f, 0.0f);
        float windIntensity = this.world.worldType.getWindManager().getWindIntensity(this.world, 0.0f, 500.0f, 0.0f);
        float dx = -((float)(Math.cos((double)windDirection * Math.PI * 2.0) * (double)windIntensity));
        float dz = -((float)(Math.sin((double)windDirection * Math.PI * 2.0) * (double)windIntensity));
        this.cloudVelocityX += dx;
        this.cloudVelocityZ += dz;
        float maxVel = 1.5f;
        if (this.cloudVelocityX > maxVel) {
            this.cloudVelocityX = maxVel;
        }
        if (this.cloudVelocityX < -maxVel) {
            this.cloudVelocityX = -maxVel;
        }
        if (this.cloudVelocityZ > maxVel) {
            this.cloudVelocityZ = maxVel;
        }
        if (this.cloudVelocityZ < -maxVel) {
            this.cloudVelocityZ = -maxVel;
        }
        this.lastCloudOffsetX = this.cloudOffsetX;
        this.lastCloudOffsetZ = this.cloudOffsetZ;
        this.cloudOffsetX += this.cloudVelocityX;
        this.cloudOffsetZ += this.cloudVelocityZ;
        ++this.ticks;
    }

    public void renderSky(float partialTick) {
        WorldTypeFX worldTypeFX = (WorldTypeFX)WorldTypeFXDispatcher.getInstance().getDispatch(this.mc.currentWorld.getWorldType());
        if (!worldTypeFX.hasSky() || this.mc.currentScreen instanceof ScreenModelViewer) {
            return;
        }
        float celestialAngle = this.world.getCelestialAngle(partialTick);
        GL11.glDisable(3553);
        Vec3 skyColor = this.world.getSkyColor(this.mc.activeCamera, partialTick);
        float r = (float)skyColor.x;
        float g = (float)skyColor.y;
        float b = (float)skyColor.z;
        GL11.glColor3f(r, g, b);
        Tessellator t = Tessellator.instance;
        GL11.glDepthMask(false);
        GL11.glEnable(2912);
        GL11.glColor3f(r, g, b);
        GL11.glCallList(this.skyList);
        GL11.glDisable(2912);
        GL11.glDisable(3008);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        Lighting.disable();
        float[] sunriseColor = worldTypeFX.getSunriseColor(celestialAngle, partialTick);
        if (sunriseColor != null) {
            GL11.glDisable(3553);
            GL11.glShadeModel(7425);
            GL11.glPushMatrix();
            GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(celestialAngle <= 0.5f ? 0.0f : 180.0f, 0.0f, 0.0f, 1.0f);
            float sr = sunriseColor[0];
            float sg = sunriseColor[1];
            float sb = sunriseColor[2];
            t.startDrawing(6);
            t.setColorRGBA_F(sr, sg, sb, sunriseColor[3]);
            t.addVertex(0.0, 100.0, 0.0);
            int numVertices = 16;
            t.setColorRGBA_F(sunriseColor[0], sunriseColor[1], sunriseColor[2], 0.0f);
            for (int i = 0; i <= numVertices; ++i) {
                float theta = (float)i * (float)Math.PI * 2.0f / (float)numVertices;
                float sunriseX = MathHelper.sin(theta);
                float sunriseYZ = MathHelper.cos(theta);
                t.addVertex(sunriseX * 120.0f, sunriseYZ * 120.0f, -sunriseYZ * 40.0f * sunriseColor[3]);
            }
            t.draw();
            GL11.glPopMatrix();
            GL11.glShadeModel(7424);
        }
        GL11.glEnable(3553);
        GL11.glBlendFunc(770, 1);
        GL11.glPushMatrix();
        float sunAlpha = 1.0f - (this.world.getCurrentWeather() != null && this.world.getCurrentWeather() != Weathers.OVERWORLD_CLEAR ? this.world.weatherManager.getWeatherIntensity() * this.world.weatherManager.getWeatherPower() * 1.5f : 0.0f);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        GL11.glTranslatef(x, y, z);
        GL11.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glRotatef(celestialAngle * 360.0f, 0.0f, 0.0f, 1.0f);
        float size = 30.0f;
        this.textureManager.loadTexture("/assets/minecraft/textures/terrain/sun.png").bind();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, sunAlpha);
        t.startDrawingQuads();
        t.addVertexWithUV(-size, 100.0, -size, 0.0, 0.0);
        t.addVertexWithUV(size, 100.0, -size, 1.0, 0.0);
        t.addVertexWithUV(size, 100.0, size, 1.0, 1.0);
        t.addVertexWithUV(-size, 100.0, size, 0.0, 1.0);
        t.draw();
        if (this.world.rainbowTicks > 0 || !Double.isNaN(this.rainbowBrightness) && this.rainbowBrightness > 0.0) {
            float timeScalar;
            float halfRainbowLength = (float)this.world.startingRainbowTicks / 2.0f;
            float rainbowTimeScalar = 1.0f - Math.abs((float)this.world.rainbowTicks + partialTick - halfRainbowLength) / halfRainbowLength;
            float angDeg = celestialAngle * 360.0f;
            if (angDeg >= 0.0f && angDeg < 180.0f) {
                angDiff = MathHelper.deltaAngle(angDeg, 80.0);
                timeScalar = 1.0f - (float)(Math.sqrt(angDiff * angDiff) / 90.0);
            } else {
                angDiff = MathHelper.deltaAngle(angDeg, 280.0);
                timeScalar = 1.0f - (float)(Math.sqrt(angDiff * angDiff) / 90.0);
            }
            float cutoff = 2.25f;
            timeScalar -= 0.5555556f;
            if (timeScalar < 0.0f) {
                timeScalar = 0.0f;
            }
            timeScalar *= 2.25f;
            timeScalar *= rainbowTimeScalar;
            Weather[] blocked = this.world.getBlockBiome((int)MathHelper.floor((double)this.mc.thePlayer.x), (int)MathHelper.floor((double)this.mc.thePlayer.y), (int)MathHelper.floor((double)this.mc.thePlayer.z)).blockedWeathers;
            boolean isWeatherBlocked = false;
            for (Weather w : blocked) {
                if (!w.equals(this.world.weatherManager.getLastWeather())) continue;
                isWeatherBlocked = true;
                break;
            }
            this.targetRainbowBrightness = isWeatherBlocked ? 0.0 : (double)timeScalar;
            if (Double.isNaN(this.rainbowBrightness)) {
                this.rainbowBrightness = this.targetRainbowBrightness;
            }
            double totalDelta = this.targetRainbowBrightness - this.rainbowBrightness;
            this.rainbowBrightnessDelta = totalDelta / 100.0;
            this.rainbowBrightness += this.rainbowBrightnessDelta * (double)partialTick;
            this.textureManager.loadTexture("/assets/minecraft/textures/terrain/rainbow.png").bind();
            t.startDrawingQuads();
            int iterations = 10;
            for (int i = 0; i < 10; ++i) {
                size = 200.0f - (float)(i * 4);
                int color = Color.HSBtoRGB((float)i / 10.0f, 1.0f, (float)((double)0.3f * this.rainbowBrightness));
                float colR = (float)(color >> 16 & 0xFF) / 255.0f;
                float colG = (float)(color >> 8 & 0xFF) / 255.0f;
                float colB = (float)(color >> 0 & 0xFF) / 255.0f;
                float rainbowAlpha = (float)((double)(0.35f - 0.15f * (float)Math.abs(i - 5) / 5.0f) * this.rainbowBrightness);
                t.setColorRGBA_F(colR, colG, colB, rainbowAlpha);
                t.addVertexWithUV(-size, -100.0, size, 1.0, 1.0);
                t.addVertexWithUV(size, -100.0, size, 0.0, 1.0);
                t.addVertexWithUV(size, -100.0, -size, 0.0, 0.0);
                t.addVertexWithUV(-size, -100.0, -size, 1.0, 0.0);
            }
            t.draw();
        } else {
            this.rainbowBrightness = 0.0;
            this.rainbowBrightnessDelta = 0.0;
            this.targetRainbowBrightness = 0.0;
        }
        size = 20.0f;
        this.textureManager.loadTexture("/assets/minecraft/textures/terrain/moon.png").bind();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, sunAlpha);
        t.startDrawingQuads();
        t.addVertexWithUV(-size, -100.0, size, 1.0, 1.0);
        t.addVertexWithUV(size, -100.0, size, 0.0, 1.0);
        t.addVertexWithUV(size, -100.0, -size, 0.0, 0.0);
        t.addVertexWithUV(-size, -100.0, -size, 1.0, 0.0);
        t.draw();
        float f17 = this.world.getStarBrightness(partialTick) * sunAlpha;
        if (f17 > 0.0f) {
            this.textureManager.loadTexture("/assets/minecraft/textures/colormap/stars/default.png").bind();
            GL11.glColor4f(f17, f17, f17, f17);
            GL11.glCallList(this.starList);
        }
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3553);
        GL11.glDisable(3042);
        GL11.glEnable(3008);
        GL11.glEnable(2912);
        GL11.glPopMatrix();
        if (worldTypeFX.hasGround()) {
            GL11.glColor3f(r * 0.2f + 0.04f, g * 0.2f + 0.04f, b * 0.6f + 0.1f);
        } else {
            GL11.glColor3f(r, g, b);
        }
        GL11.glEnable(3553);
        GL11.glDepthMask(true);
    }

    private float getCloudHeightModifier() {
        return ((Float)this.mc.gameSettings.cloudHeight.value).floatValue() * 128.0f;
    }

    public void renderClouds(float partialTick) {
        WorldTypeFX worldTypeFX = (WorldTypeFX)WorldTypeFXDispatcher.getInstance().getDispatch(this.mc.currentWorld.getWorldType());
        if (!worldTypeFX.hasClouds()) {
            return;
        }
        if (this.mc.currentScreen instanceof ScreenPhotoMode) {
            return;
        }
        if ((Integer)this.mc.gameSettings.fancyGraphics.value == 1) {
            this.renderCloudsFancy(partialTick);
            return;
        }
        GL11.glDisable(2884);
        float cameraY = (float)this.mc.activeCamera.getY(partialTick);
        int cloudRadius = 32;
        int i = 256 / cloudRadius;
        Tessellator tessellator = Tessellator.instance;
        this.textureManager.loadTexture("/assets/minecraft/textures/environment/clouds.png").bind();
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        Vec3 dimensionColor = this.world.getDimensionColor(this.mc.activeCamera, partialTick);
        float r = (float)dimensionColor.x;
        float g = (float)dimensionColor.y;
        float b = (float)dimensionColor.z;
        float f6 = 4.8828125E-4f;
        double posX = this.mc.activeCamera.getX(partialTick) + (double)((this.lastCloudOffsetX + (this.cloudOffsetX - this.lastCloudOffsetX) * partialTick) * 0.03f);
        double posZ = this.mc.activeCamera.getZ(partialTick) + (double)((this.lastCloudOffsetZ + (this.cloudOffsetZ - this.lastCloudOffsetZ) * partialTick) * 0.03f);
        int j = MathHelper.floor(posX / 2048.0);
        int k = MathHelper.floor(posZ / 2048.0);
        float cloudHeight = worldTypeFX.getCloudHeight() - cameraY + 0.33f + this.getCloudHeightModifier();
        float f10 = (float)((posX -= (double)(j * 2048)) * (double)f6);
        float f11 = (float)((posZ -= (double)(k * 2048)) * (double)f6);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(r, g, b, 0.8f);
        for (int cloudX = -cloudRadius * i; cloudX < cloudRadius * i; cloudX += cloudRadius) {
            for (int cloudZ = -cloudRadius * i; cloudZ < cloudRadius * i; cloudZ += cloudRadius) {
                tessellator.addVertexWithUV(cloudX, cloudHeight, cloudZ + cloudRadius, (float)cloudX * f6 + f10, (float)(cloudZ + cloudRadius) * f6 + f11);
                tessellator.addVertexWithUV(cloudX + cloudRadius, cloudHeight, cloudZ + cloudRadius, (float)(cloudX + cloudRadius) * f6 + f10, (float)(cloudZ + cloudRadius) * f6 + f11);
                tessellator.addVertexWithUV(cloudX + cloudRadius, cloudHeight, cloudZ, (float)(cloudX + cloudRadius) * f6 + f10, (float)cloudZ * f6 + f11);
                tessellator.addVertexWithUV(cloudX, cloudHeight, cloudZ, (float)cloudX * f6 + f10, (float)cloudZ * f6 + f11);
            }
        }
        tessellator.draw();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
        GL11.glEnable(2884);
    }

    public void renderCloudsFancy(float partialTick) {
        WorldTypeFX worldTypeFX = (WorldTypeFX)WorldTypeFXDispatcher.getInstance().getDispatch(this.mc.currentWorld.getWorldType());
        this.mc.renderer.beginRenderClouds(partialTick);
        float celestialAngle = this.world.getCelestialAngle(partialTick);
        float[] sunriseColor = worldTypeFX.getSunriseColor(celestialAngle, partialTick);
        float rSun = 0.0f;
        float gSun = 0.0f;
        float bSun = 0.0f;
        float aSun = 0.0f;
        if (sunriseColor != null) {
            rSun = sunriseColor[0];
            gSun = sunriseColor[1];
            bSun = sunriseColor[2];
            aSun = sunriseColor[3] / 2.0f;
        }
        Vec3 dimensionColor = this.world.getDimensionColor(this.mc.activeCamera, partialTick);
        float rDim = (float)dimensionColor.x;
        float gDim = (float)dimensionColor.y;
        float bDim = (float)dimensionColor.z;
        GL11.glDisable(2884);
        float cameraY = (float)this.mc.activeCamera.getY(partialTick);
        Tessellator tessellator = Tessellator.instance;
        float cloudWidth = 12.0f;
        float cloudThickness = 4.0f;
        double dx = (this.mc.activeCamera.getX(partialTick) + (double)((this.lastCloudOffsetX + (this.cloudOffsetX - this.lastCloudOffsetX) * partialTick) * 0.03f)) / (double)cloudWidth;
        double dz = (this.mc.activeCamera.getZ(partialTick) + (double)((this.lastCloudOffsetZ + (this.cloudOffsetZ - this.lastCloudOffsetZ) * partialTick) * 0.03f)) / (double)cloudWidth + 0.33;
        float dy = worldTypeFX.getCloudHeight() - cameraY + 0.33f + this.getCloudHeightModifier();
        int i = MathHelper.floor(dx / 2048.0);
        int j = MathHelper.floor(dz / 2048.0);
        dx -= (double)(i * 2048);
        dz -= (double)(j * 2048);
        this.textureManager.loadTexture("/assets/minecraft/textures/environment/clouds.png").bind();
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        float f13 = 0.00390625f;
        float f9 = (float)MathHelper.floor(dx) * f13;
        float f11 = (float)MathHelper.floor(dz) * f13;
        float f14 = (float)(dx - (double)MathHelper.floor(dx));
        float f15 = (float)(dz - (double)MathHelper.floor(dz));
        int cloudWidthScale = 8;
        int radius = 3;
        float f16 = 9.765625E-4f;
        GL11.glScalef(cloudWidth, 1.0f, cloudWidth);
        float red = rDim + (rSun - rDim) * aSun;
        float green = gDim + (gSun - gDim) * aSun;
        float blue = bDim + (bSun - bDim) * aSun;
        for (int l = 0; l < 2; ++l) {
            if (l == 0) {
                GL11.glColorMask(false, false, false, true);
            } else {
                GL11.glColorMask(true, true, true, true);
            }
            tessellator.startDrawingQuads();
            for (int ix = -radius - 1; ix <= radius; ++ix) {
                for (int iz = -radius - 1; iz <= radius; ++iz) {
                    float f17 = ix * cloudWidthScale;
                    float f18 = iz * cloudWidthScale;
                    float cloudX = f17 - f14;
                    float cloudZ = f18 - f15;
                    if (dy > -cloudThickness - 1.0f) {
                        tessellator.setColorRGBA_F(red * 0.7f, green * 0.7f, blue * 0.7f, 0.8f);
                        tessellator.setNormal(0.0f, -1.0f, 0.0f);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + (float)cloudWidthScale, (f17 + 0.0f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + 0.0f, cloudZ + (float)cloudWidthScale, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + 0.0f, cloudZ + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                    if (dy <= cloudThickness + 1.0f) {
                        tessellator.setColorRGBA_F(red, green, blue, 0.8f);
                        tessellator.setNormal(0.0f, 1.0f, 0.0f);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness - f16, cloudZ + (float)cloudWidthScale, (f17 + 0.0f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + cloudThickness - f16, cloudZ + (float)cloudWidthScale, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + cloudThickness - f16, cloudZ + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness - f16, cloudZ + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                    tessellator.setColorRGBA_F(red * 0.9f, green * 0.9f, blue * 0.9f, 0.8f);
                    if (ix > -1) {
                        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                        for (int k1 = 0; k1 < cloudWidthScale; ++k1) {
                            tessellator.addVertexWithUV(cloudX + (float)k1 + 0.0f, dy + 0.0f, cloudZ + (float)cloudWidthScale, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)k1 + 0.0f, dy + cloudThickness, cloudZ + (float)cloudWidthScale, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)k1 + 0.0f, dy + cloudThickness, cloudZ + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)k1 + 0.0f, dy + 0.0f, cloudZ + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        }
                    }
                    if (ix <= 1) {
                        tessellator.setNormal(1.0f, 0.0f, 0.0f);
                        for (int l1 = 0; l1 < cloudWidthScale; ++l1) {
                            tessellator.addVertexWithUV(cloudX + (float)l1 + 1.0f - f16, dy + 0.0f, cloudZ + (float)cloudWidthScale, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)l1 + 1.0f - f16, dy + cloudThickness, cloudZ + (float)cloudWidthScale, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)l1 + 1.0f - f16, dy + cloudThickness, cloudZ + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)l1 + 1.0f - f16, dy + 0.0f, cloudZ + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        }
                    }
                    tessellator.setColorRGBA_F(red * 0.8f, green * 0.8f, blue * 0.8f, 0.8f);
                    if (iz > -1) {
                        tessellator.setNormal(0.0f, 0.0f, -1.0f);
                        for (int i2 = 0; i2 < cloudWidthScale; ++i2) {
                            tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness, cloudZ + (float)i2 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + cloudThickness, cloudZ + (float)i2 + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + 0.0f, cloudZ + (float)i2 + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + (float)i2 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                        }
                    }
                    if (iz > 1) continue;
                    tessellator.setNormal(0.0f, 0.0f, 1.0f);
                    for (int j2 = 0; j2 < cloudWidthScale; ++j2) {
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness, cloudZ + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + cloudThickness, cloudZ + (float)j2 + 1.0f - f16, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + 0.0f, cloudZ + (float)j2 + 1.0f - f16, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                    }
                }
            }
            tessellator.draw();
        }
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
        GL11.glEnable(2884);
        this.mc.renderer.endRenderClouds(partialTick);
    }

    public boolean updateDirtyChunks(ICamera camera) {
        int cursor;
        DirtyChunkRendererSorter dirtyChunkRendererSorter = new DirtyChunkRendererSorter(camera);
        ChunkRenderer[] toAdd = new ChunkRenderer[2];
        ArrayList<ChunkRenderer> nearChunks = null;
        int pendingChunkSize = this.dirtyChunks.size();
        int pendingChunkRemoved = 0;
        for (int i = 0; i < pendingChunkSize; ++i) {
            ChunkRenderer renderer = this.dirtyChunks.get(i);
            if (renderer.distanceToCameraSquared(camera) > 1024.0f) {
                int index;
                for (index = 0; index < 2 && (toAdd[index] == null || dirtyChunkRendererSorter.compare(toAdd[index], renderer) <= 0); ++index) {
                }
                if (--index <= 0) continue;
                int x = index;
                while (--x != 0) {
                    toAdd[x - 1] = toAdd[x];
                }
                toAdd[index] = renderer;
                continue;
            }
            if (nearChunks == null) {
                nearChunks = new ArrayList<ChunkRenderer>();
            }
            ++pendingChunkRemoved;
            nearChunks.add(renderer);
            this.dirtyChunks.set(i, null);
        }
        if (nearChunks != null) {
            if (nearChunks.size() > 1) {
                nearChunks.sort(dirtyChunkRendererSorter);
            }
            for (ChunkRenderer renderer : nearChunks) {
                renderer.rebuild();
                renderer.dirty = false;
            }
        }
        int secondaryRemoved = 0;
        for (int i = 1; i >= 0; --i) {
            ChunkRenderer chunkx = toAdd[i];
            if (chunkx == null) continue;
            if (!chunkx.visible && i != 1) {
                toAdd[i] = null;
                break;
            }
            chunkx.rebuild();
            chunkx.dirty = false;
            ++secondaryRemoved;
        }
        int target = 0;
        int size = this.dirtyChunks.size();
        block5: for (cursor = 0; cursor != size; ++cursor) {
            ChunkRenderer renderer = this.dirtyChunks.get(cursor);
            if (renderer == null) continue;
            for (int i = 0; i < 2; ++i) {
                if (renderer == toAdd[i]) continue block5;
            }
            if (target != cursor) {
                this.dirtyChunks.set(target, renderer);
            }
            ++target;
        }
        while (--cursor >= target) {
            this.dirtyChunks.remove(cursor);
        }
        return pendingChunkSize == pendingChunkRemoved + secondaryRemoved;
    }

    public void drawBlockBreaking(ICamera camera, HitResult hitResult, float partialTick) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable(3042);
        GL11.glEnable(3008);
        GL11.glBlendFunc(770, 1);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, (MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.4f) * 0.5f);
        if (this.destroyProgress > 0.0f) {
            GL11.glBlendFunc(774, 768);
            TextureRegistry.blockAtlas.bind();
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.5f);
            GL11.glPushMatrix();
            int k = this.world.getBlockId(hitResult.x, hitResult.y, hitResult.z);
            Block<?> block = k <= 0 ? null : Blocks.blocksList[k];
            GL11.glDisable(3008);
            GL11.glPolygonOffset(-3.0f, -3.0f);
            GL11.glEnable(32823);
            double x = camera.getX(partialTick);
            double y = camera.getY(partialTick);
            double z = camera.getZ(partialTick);
            if (block == null) {
                block = Blocks.STONE;
            }
            GL11.glEnable(3008);
            tessellator.startDrawingQuads();
            tessellator.setTranslation(-x, -y, -z);
            tessellator.lockColor();
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 0));
            }
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderWithOverrideTexture(tessellator, this.world, hitResult.x, hitResult.y, hitResult.z, breakingAnimation[MathHelper.clamp((int)(this.destroyProgress * 10.0f), 0, breakingAnimation.length - 1)]);
            tessellator.draw();
            tessellator.setTranslation(0.0, 0.0, 0.0);
            GL11.glDisable(3008);
            GL11.glPolygonOffset(0.0f, 0.0f);
            GL11.glDisable(32823);
            GL11.glEnable(3008);
            GL11.glDepthMask(true);
            GL11.glPopMatrix();
        }
        GL11.glDisable(3042);
        GL11.glDisable(3008);
    }

    public void drawSelectionBox(ICamera camera, HitResult hitResult, float partialTick) {
        if (this.mc.gameSettings.immersiveMode.drawOutline() && ((Float)this.mc.gameSettings.blockOutlineWidth.value).floatValue() > 0.01f && !(this.mc.currentScreen instanceof ScreenModelViewer)) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            float w = this.mc.getOutlineWidth();
            GL11.glColor4f(0.0f, 0.0f, 0.0f, 0.35f + w * 0.3f);
            GL11.glLineWidth(Math.max(4.0f * w * 2.0f, 1.0f));
            GL11.glDisable(3553);
            GL11.glDepthMask(false);
            double offsetX = camera.getX(partialTick);
            double offsetY = camera.getY(partialTick);
            double offsetZ = camera.getZ(partialTick);
            if (hitResult.hitType == HitResult.HitType.TILE) {
                float expand = 0.002f;
                Block<?> block = this.world.getBlock(hitResult.x, hitResult.y, hitResult.z);
                if (block != null) {
                    BoundingVolume volume = block.getBoundingVolume(this.world, hitResult.x, hitResult.y, hitResult.z);
                    if (volume != null) {
                        this.drawOutlinedVolume(volume, (double)hitResult.x - offsetX, (double)hitResult.y - offsetY, (double)hitResult.z - offsetZ, expand);
                    } else {
                        this.drawOutlinedBoundingBox(block.getSelectedBoundingBoxFromPool(this.world, hitResult.x, hitResult.y, hitResult.z).grow(expand, expand, expand).cloneMove(-offsetX, -offsetY, -offsetZ));
                    }
                    if (((Boolean)this.mc.gameSettings.viewSupportMode.value).booleanValue()) {
                        Tessellator t = Tessellator.instance;
                        double x = (double)hitResult.x - offsetX;
                        double y = (double)hitResult.y - offsetY;
                        double z = (double)hitResult.z - offsetZ;
                        double oMin = -0.01;
                        double oMax = 1.01;
                        ISupport sBottom = block.getSupport(this.world, hitResult.x, hitResult.y, hitResult.z, Side.BOTTOM);
                        ISupport sTop = block.getSupport(this.world, hitResult.x, hitResult.y, hitResult.z, Side.TOP);
                        ISupport sNorth = block.getSupport(this.world, hitResult.x, hitResult.y, hitResult.z, Side.NORTH);
                        ISupport sSouth = block.getSupport(this.world, hitResult.x, hitResult.y, hitResult.z, Side.SOUTH);
                        ISupport sWest = block.getSupport(this.world, hitResult.x, hitResult.y, hitResult.z, Side.WEST);
                        ISupport sEast = block.getSupport(this.world, hitResult.x, hitResult.y, hitResult.z, Side.EAST);
                        t.startDrawingQuads();
                        if (sTop.canSupport(PartialSupport.INSTANCE.center(), Side.BOTTOM)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.0f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMax, z + oMin + 0.25);
                        t.addVertex(x + oMin + 0.25, y + oMax, z + oMax - 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMax, z + oMax - 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMax, z + oMin + 0.25);
                        if (sTop.canSupport(PartialSupport.INSTANCE.up(), Side.BOTTOM)) {
                            t.setColorRGBA_F(0.5f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMin);
                        t.addVertex(x + oMin + 0.25, y + oMax, z + oMin + 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMax, z + oMin + 0.25);
                        t.addVertex(x + oMax, y + oMax, z + oMin);
                        if (sTop.canSupport(PartialSupport.INSTANCE.down(), Side.BOTTOM)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMax);
                        t.addVertex(x + oMax, y + oMax, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMax, z + oMax - 0.25);
                        t.addVertex(x + oMin + 0.25, y + oMax, z + oMax - 0.25);
                        if (sTop.canSupport(PartialSupport.INSTANCE.left(), Side.BOTTOM)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMin);
                        t.addVertex(x + oMin, y + oMax, z + oMax);
                        t.addVertex(x + oMin + 0.25, y + oMax, z + oMax - 0.25);
                        t.addVertex(x + oMin + 0.25, y + oMax, z + oMin + 0.25);
                        if (sTop.canSupport(PartialSupport.INSTANCE.right(), Side.BOTTOM)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMax, z + oMin + 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMax, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMax, z + oMax);
                        if (sBottom.canSupport(PartialSupport.INSTANCE.center(), Side.TOP)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.0f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMin, z + oMin + 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMin, z + oMin + 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMin, z + oMax - 0.25);
                        t.addVertex(x + oMin + 0.25, y + oMin, z + oMax - 0.25);
                        if (sBottom.canSupport(PartialSupport.INSTANCE.up(), Side.TOP)) {
                            t.setColorRGBA_F(0.5f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMin, z + oMax - 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMin, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMin, z + oMax);
                        t.addVertex(x + oMin, y + oMin, z + oMax);
                        if (sBottom.canSupport(PartialSupport.INSTANCE.down(), Side.TOP)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMin, z + oMin + 0.25);
                        t.addVertex(x + oMin, y + oMin, z + oMin);
                        t.addVertex(x + oMax, y + oMin, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMin, z + oMin + 0.25);
                        if (sBottom.canSupport(PartialSupport.INSTANCE.left(), Side.TOP)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMin, z + oMin);
                        t.addVertex(x + oMax, y + oMin, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMin, z + oMax - 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMin, z + oMin + 0.25);
                        if (sBottom.canSupport(PartialSupport.INSTANCE.right(), Side.TOP)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMin, z + oMin);
                        t.addVertex(x + oMin + 0.25, y + oMin, z + oMin + 0.25);
                        t.addVertex(x + oMin + 0.25, y + oMin, z + oMax - 0.25);
                        t.addVertex(x + oMin, y + oMin, z + oMax);
                        if (sNorth.canSupport(PartialSupport.INSTANCE.center(), Side.SOUTH)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.0f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMax - 0.25, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMax - 0.25, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMin + 0.25, z + oMin);
                        t.addVertex(x + oMin + 0.25, y + oMin + 0.25, z + oMin);
                        if (sNorth.canSupport(PartialSupport.INSTANCE.up(), Side.SOUTH)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMin);
                        t.addVertex(x + oMax, y + oMax, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMax - 0.25, z + oMin);
                        t.addVertex(x + oMin + 0.25, y + oMax - 0.25, z + oMin);
                        if (sNorth.canSupport(PartialSupport.INSTANCE.down(), Side.SOUTH)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMin + 0.25, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMin + 0.25, z + oMin);
                        t.addVertex(x + oMax, y + oMin, z + oMin);
                        t.addVertex(x + oMin, y + oMin, z + oMin);
                        if (sNorth.canSupport(PartialSupport.INSTANCE.right(), Side.SOUTH)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMin);
                        t.addVertex(x + oMin + 0.25, y + oMax - 0.25, z + oMin);
                        t.addVertex(x + oMin + 0.25, y + oMin + 0.25, z + oMin);
                        t.addVertex(x + oMin, y + oMin, z + oMin);
                        if (sNorth.canSupport(PartialSupport.INSTANCE.left(), Side.SOUTH)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax, z + oMin);
                        t.addVertex(x + oMax, y + oMin, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMin + 0.25, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMax - 0.25, z + oMin);
                        if (sSouth.canSupport(PartialSupport.INSTANCE.center(), Side.NORTH)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.0f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMax - 0.25, z + oMax);
                        t.addVertex(x + oMin + 0.25, y + oMin + 0.25, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMin + 0.25, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMax - 0.25, z + oMax);
                        if (sSouth.canSupport(PartialSupport.INSTANCE.up(), Side.NORTH)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMax);
                        t.addVertex(x + oMin + 0.25, y + oMax - 0.25, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMax - 0.25, z + oMax);
                        t.addVertex(x + oMax, y + oMax, z + oMax);
                        if (sSouth.canSupport(PartialSupport.INSTANCE.down(), Side.NORTH)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMin + 0.25, z + oMax);
                        t.addVertex(x + oMin, y + oMin, z + oMax);
                        t.addVertex(x + oMax, y + oMin, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMin + 0.25, z + oMax);
                        if (sSouth.canSupport(PartialSupport.INSTANCE.right(), Side.NORTH)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMax - 0.25, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMin + 0.25, z + oMax);
                        t.addVertex(x + oMax, y + oMin, z + oMax);
                        if (sSouth.canSupport(PartialSupport.INSTANCE.left(), Side.NORTH)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMax);
                        t.addVertex(x + oMin, y + oMin, z + oMax);
                        t.addVertex(x + oMin + 0.25, y + oMin + 0.25, z + oMax);
                        t.addVertex(x + oMin + 0.25, y + oMax - 0.25, z + oMax);
                        if (sWest.canSupport(PartialSupport.INSTANCE.center(), Side.EAST)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax - 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMin, y + oMin + 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMin, y + oMin + 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMin, y + oMax - 0.25, z + oMax - 0.25);
                        if (sWest.canSupport(PartialSupport.INSTANCE.up(), Side.EAST)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMin);
                        t.addVertex(x + oMin, y + oMax - 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMin, y + oMax - 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMin, y + oMax, z + oMax);
                        if (sWest.canSupport(PartialSupport.INSTANCE.down(), Side.EAST)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMin, z + oMin);
                        t.addVertex(x + oMin, y + oMin, z + oMax);
                        t.addVertex(x + oMin, y + oMin + 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMin, y + oMin + 0.25, z + oMin + 0.25);
                        if (sWest.canSupport(PartialSupport.INSTANCE.left(), Side.EAST)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMin);
                        t.addVertex(x + oMin, y + oMin, z + oMin);
                        t.addVertex(x + oMin, y + oMin + 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMin, y + oMax - 0.25, z + oMin + 0.25);
                        if (sWest.canSupport(PartialSupport.INSTANCE.right(), Side.EAST)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax - 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMin, y + oMin + 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMin, y + oMin, z + oMax);
                        t.addVertex(x + oMin, y + oMax, z + oMax);
                        if (sEast.canSupport(PartialSupport.INSTANCE.center(), Side.WEST)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax - 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMax, y + oMax - 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMin + 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMin + 0.25, z + oMin + 0.25);
                        if (sEast.canSupport(PartialSupport.INSTANCE.up(), Side.WEST)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax, z + oMin);
                        t.addVertex(x + oMax, y + oMax, z + oMax);
                        t.addVertex(x + oMax, y + oMax - 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMax - 0.25, z + oMin + 0.25);
                        if (sEast.canSupport(PartialSupport.INSTANCE.down(), Side.WEST)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMin, z + oMin);
                        t.addVertex(x + oMax, y + oMin + 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMax, y + oMin + 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMin, z + oMax);
                        if (sEast.canSupport(PartialSupport.INSTANCE.left(), Side.WEST)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax - 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMax, z + oMax);
                        t.addVertex(x + oMax, y + oMin, z + oMax);
                        t.addVertex(x + oMax, y + oMin + 0.25, z + oMax - 0.25);
                        if (sEast.canSupport(PartialSupport.INSTANCE.right(), Side.WEST)) {
                            t.setColorRGBA_F(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColorRGBA_F(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax, z + oMin);
                        t.addVertex(x + oMax, y + oMax - 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMax, y + oMin + 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMax, y + oMin, z + oMin);
                        t.draw();
                    }
                }
            } else if (hitResult.hitType == HitResult.HitType.ENTITY && hitResult.entity.showBoundingBoxOnHover() && !((Boolean)this.mc.gameSettings.showCollisionBoxes.value).booleanValue()) {
                this.drawInterpolatedEntityBoundingBox(hitResult.entity, hitResult.entity.bb, camera, partialTick);
            }
            GL11.glDepthMask(true);
            GL11.glEnable(3553);
            GL11.glDisable(3042);
        }
    }

    public void drawDebugEntityOutlines(ICamera camera, float partialTicks) {
        GL11.glDisable(3553);
        GL11.glLineWidth(2.0f);
        double offsetX = camera.getX(partialTicks);
        double offsetY = camera.getY(partialTicks);
        double offsetZ = camera.getZ(partialTicks);
        float expand = 0.002f;
        List<AABB> collidingBoundingBoxes = this.world.getCubes(this.mc.thePlayer, this.mc.thePlayer.bb.grow(expand, expand, expand));
        GL11.glColor4f(0.0f, 0.0f, 1.0f, 1.0f);
        for (AABB aabb : collidingBoundingBoxes) {
            this.drawOutlinedBoundingBox(aabb.cloneMove(-offsetX, -offsetY, -offsetZ).grow(expand, expand, expand));
        }
        float entityRadius = 10.0f;
        if (this.mc.thePlayer.getGamemode() == Gamemode.creative) {
            entityRadius = 100.0f;
        }
        List<Entity> entitiesNearby = this.world.getEntitiesWithinAABBExcludingEntity(null, this.mc.thePlayer.bb.grow(entityRadius, entityRadius, entityRadius));
        for (Entity e : entitiesNearby) {
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.drawInterpolatedEntityBoundingBox(e, e.bb, camera, partialTicks);
            GL11.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
            AABB head = e.bb.copy();
            head.set(head.minX, e.y + (double)e.getHeadHeight() - 0.005, head.minZ, head.maxX, e.y + (double)e.getHeadHeight() + 0.005, head.maxZ);
            this.drawInterpolatedEntityBoundingBox(e, head, camera, partialTicks);
            GL11.glColor4f(1.0f, 0.0f, 1.0f, 1.0f);
            AABB feet = AABB.fromPool(e.bb.minX, e.y - 0.005, e.bb.minZ, e.bb.maxX, e.y + 0.005, e.bb.maxZ);
            this.drawInterpolatedEntityBoundingBox(e, feet, camera, partialTicks);
            GL11.glColor4f(0.75f, 0.75f, 1.0f, 1.0f);
            this.drawInterpolatedEntityBoundingBox(e, EntityRenderDispatcher.instance.getRenderer(e).entityViewBox(e), camera, partialTicks);
            double lerpOffsetX = MathHelper.lerp(e.xo, e.x, (double)partialTicks) - camera.getX(partialTicks);
            double lerpOffsetY = MathHelper.lerp(e.yo, e.y, (double)partialTicks) - camera.getY(partialTicks);
            double lerpOffsetZ = MathHelper.lerp(e.zo, e.z, (double)partialTicks) - camera.getZ(partialTicks);
            RenderGlobal.drawDebugVec(Tessellator.instance, Vec3.fromPool(lerpOffsetX, lerpOffsetY + (double)e.getHeadHeight(), lerpOffsetZ), e.getViewVector(partialTicks), 1.0, 0.0f, 1.0f, 0.0f, 1.0f);
            GL11.glDisable(3553);
            GL11.glLineWidth(2.0f);
        }
        GL11.glEnable(3553);
    }

    public static void drawDebugVec(Tessellator tessellator, Vec3 pos, Vec3 vec, double scale, float r, float g, float b, float a) {
        if (pos == null || vec == null) {
            return;
        }
        GL11.glLineWidth(10.0f);
        GL11.glDisable(3553);
        tessellator.startDrawing(1);
        tessellator.setColorRGBA_F(r, g, b, a);
        tessellator.addVertex(pos.x, pos.y, pos.z);
        tessellator.addVertex(pos.x + vec.x * scale, pos.y + vec.y * scale, pos.z + vec.z * scale);
        tessellator.draw();
        GL11.glEnable(3553);
    }

    public void drawInterpolatedEntityBoundingBox(Entity entity, AABB boundingBox, ICamera camera, float partialTicks) {
        double cameraX = camera.getX(partialTicks);
        double cameraY = camera.getY(partialTicks);
        double cameraZ = camera.getZ(partialTicks);
        float expand = 0.02f;
        double lerpOffsetX = entity.xo + (entity.x - entity.xo) * (double)partialTicks;
        double lerpOffsetY = entity.yo + (entity.y - entity.yo) * (double)partialTicks;
        double lerpOffsetZ = entity.zo + (entity.z - entity.zo) * (double)partialTicks;
        boundingBox = boundingBox.grow(expand, expand, expand);
        boundingBox = boundingBox.cloneMove(-entity.x, -entity.y, -entity.z);
        boundingBox = boundingBox.cloneMove(-cameraX, -cameraY, -cameraZ);
        boundingBox = boundingBox.cloneMove(lerpOffsetX, lerpOffsetY, lerpOffsetZ);
        this.drawOutlinedBoundingBox(boundingBox);
    }

    public void drawDebugChunkBorders(ICamera camera, float partialTicks) {
        int i;
        GL11.glDisable(3553);
        GL11.glDisable(2912);
        double offsetX = camera.getX(partialTicks);
        double offsetY = camera.getY(partialTicks);
        double offsetZ = camera.getZ(partialTicks);
        Tessellator tessellator = Tessellator.instance;
        tessellator.setTranslation(-offsetX, -offsetY, -offsetZ);
        int blockX = MathHelper.floor(this.mc.thePlayer.x);
        int blockZ = MathHelper.floor(this.mc.thePlayer.z);
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        int x0 = chunkX << 4;
        int z0 = chunkZ << 4;
        int x1 = x0 + 16;
        int z1 = z0 + 16;
        int worldHeight = this.mc.currentWorld.getHeightBlocks();
        GL11.glLineWidth(2.0f);
        GL11.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
        tessellator.startDrawing(1);
        for (i = -1; i <= 2; ++i) {
            for (int j = -1; j <= 2; ++j) {
                int x2 = chunkX + i << 4;
                int z2 = chunkZ + j << 4;
                tessellator.addVertex(x2, 0.0, z2);
                tessellator.addVertex(x2, worldHeight, z2);
            }
        }
        tessellator.draw();
        GL11.glLineWidth(1.0f);
        GL11.glColor4f(0.0f, 1.0f, 0.0f, 1.0f);
        tessellator.startDrawing(1);
        for (int y = 0; y <= worldHeight; ++y) {
            if (y % 2 == 1) continue;
            tessellator.addVertex(x0, y, z0);
            tessellator.addVertex(x1, y, z0);
            tessellator.addVertex(x0, y, z1);
            tessellator.addVertex(x1, y, z1);
            tessellator.addVertex(x0, y, z0);
            tessellator.addVertex(x0, y, z1);
            tessellator.addVertex(x1, y, z0);
            tessellator.addVertex(x1, y, z1);
        }
        for (i = 1; i < 16; ++i) {
            if (i % 2 == 1) continue;
            tessellator.addVertex(x0 + i, 0.0, z0);
            tessellator.addVertex(x0 + i, 256.0, z0);
            tessellator.addVertex(x0, 0.0, z0 + i);
            tessellator.addVertex(x0, 256.0, z0 + i);
            tessellator.addVertex(x0 + i, 0.0, z1);
            tessellator.addVertex(x0 + i, 256.0, z1);
            tessellator.addVertex(x1, 0.0, z0 + i);
            tessellator.addVertex(x1, 256.0, z0 + i);
        }
        tessellator.draw();
        tessellator.setTranslation(0.0, 0.0, 0.0);
        GL11.glEnable(3553);
        GL11.glEnable(2912);
    }

    public void drawOutlinedBoundingBox(AABB aabb) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(3);
        tessellator.addVertex(aabb.minX, aabb.minY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.minY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.minY, aabb.maxZ);
        tessellator.addVertex(aabb.minX, aabb.minY, aabb.maxZ);
        tessellator.addVertex(aabb.minX, aabb.minY, aabb.minZ);
        tessellator.draw();
        tessellator.startDrawing(3);
        tessellator.addVertex(aabb.minX, aabb.maxY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.maxY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.maxY, aabb.maxZ);
        tessellator.addVertex(aabb.minX, aabb.maxY, aabb.maxZ);
        tessellator.addVertex(aabb.minX, aabb.maxY, aabb.minZ);
        tessellator.draw();
        tessellator.startDrawing(1);
        tessellator.addVertex(aabb.minX, aabb.minY, aabb.minZ);
        tessellator.addVertex(aabb.minX, aabb.maxY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.minY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.maxY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.minY, aabb.maxZ);
        tessellator.addVertex(aabb.maxX, aabb.maxY, aabb.maxZ);
        tessellator.addVertex(aabb.minX, aabb.minY, aabb.maxZ);
        tessellator.addVertex(aabb.minX, aabb.maxY, aabb.maxZ);
        tessellator.draw();
    }

    public void drawOutlinedVolume(BoundingVolume volume, double xOffset, double yOffset, double zOffset, float expand) {
        Tessellator t = Tessellator.instance;
        t.startDrawing(1);
        Float[] points = volume.getBakedLineCoords();
        for (int i = 0; i < points.length; i += 3) {
            float expand0 = (points[i].floatValue() - 0.5f) * 2.0f * expand;
            float expand1 = (points[i + 1].floatValue() - 0.5f) * 2.0f * expand;
            float expand2 = (points[i + 2].floatValue() - 0.5f) * 2.0f * expand;
            t.addVertex((double)points[i].floatValue() + xOffset + (double)expand0, (double)points[i + 1].floatValue() + yOffset + (double)expand1, (double)points[i + 2].floatValue() + zOffset + (double)expand2);
        }
        t.draw();
    }

    public void setDirty(int x0, int y0, int z0, int x1, int y1, int z1) {
        int _x0 = MathHelper.bucketInt(x0, 16);
        int _y0 = MathHelper.bucketInt(y0, 16);
        int _z0 = MathHelper.bucketInt(z0, 16);
        int _x1 = MathHelper.bucketInt(x1, 16);
        int _y1 = MathHelper.bucketInt(y1, 16);
        int _z1 = MathHelper.bucketInt(z1, 16);
        for (int x = _x0; x <= _x1; ++x) {
            int xx = x % this.xChunks;
            if (xx < 0) {
                xx += this.xChunks;
            }
            for (int y = _y0; y <= _y1; ++y) {
                int yy = y % this.yChunks;
                if (yy < 0) {
                    yy += this.yChunks;
                }
                for (int z = _z0; z <= _z1; ++z) {
                    int zz = z % this.zChunks;
                    if (zz < 0) {
                        zz += this.zChunks;
                    }
                    int p = (zz * this.yChunks + yy) * this.xChunks + xx;
                    ChunkRenderer renderer = this.chunkRenderers[p];
                    if (renderer.dirty) continue;
                    this.dirtyChunks.add(renderer);
                    renderer.setDirty();
                }
            }
        }
    }

    @Override
    public void blockChanged(int x, int y, int z) {
        this.setDirty(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1);
    }

    @Override
    public void setBlocksDirty(int x0, int y0, int z0, int x1, int y1, int z1) {
        this.setDirty(x0 - 1, y0 - 1, z0 - 1, x1 + 1, y1 + 1, z1 + 1);
    }

    public void cull(CameraFrustum frustum, float partialTick) {
        for (int i = 0; i < this.chunkRenderers.length; ++i) {
            if (this.chunkRenderers[i].isEmpty() || this.chunkRenderers[i].visible && (i + this.cullStep & 0xF) != 0) continue;
            this.chunkRenderers[i].cull(frustum, partialTick);
        }
        ++this.cullStep;
    }

    @Override
    public void playStreamingMusic(String soundPath, String author, int x, int y, int z) {
        if (soundPath != null) {
            if (author != null && !author.isEmpty()) {
                this.mc.hudIngame.setRecordPlayingMessage(author + " - " + I18n.getInstance().translateKey(soundPath));
            } else {
                this.mc.hudIngame.setRecordPlayingMessage(I18n.getInstance().translateKey(soundPath));
            }
        }
        this.mc.sndManager.playMusic(soundPath, (float)x, (float)y, (float)z, 1.0f, 1.0f);
    }

    @Override
    public void playSound(Entity player, String soundPath, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        this.mc.sndManager.playSoundAt(soundPath, category, (float)x, (float)y, (float)z, volume, pitch);
    }

    @Override
    public void addParticle(String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
        this.addParticle(particleKey, x, y, z, motionX, motionY, motionZ, data, 16.0);
    }

    @Override
    public void addParticle(String particleId, double x, double y, double z, double motionX, double motionY, double motionZ, int data, double maxDistance) {
        double d8;
        double d7;
        if (this.mc == null || this.mc.activeCamera == null || this.mc.particleEngine == null) {
            return;
        }
        double d6 = this.mc.activeCamera.getX() - x;
        if (d6 * d6 + (d7 = this.mc.activeCamera.getY() - y) * d7 + (d8 = this.mc.activeCamera.getZ() - z) * d8 > maxDistance * maxDistance) {
            return;
        }
        Particle fx = ((ParticleLambda)ParticleDispatcher.getInstance().getDispatch(particleId)).newParticle(this.world, x, y, z, motionX, motionY, motionZ, data);
        if (fx != null) {
            this.mc.particleEngine.add(fx);
        }
    }

    @Override
    public void allChanged(boolean lightChanged, boolean seasonChanged) {
        if (seasonChanged) {
            Colorizers.update(false);
        }
        if (seasonChanged || lightChanged && !LightmapHelper.isLightmapEnabled()) {
            for (ChunkRenderer chunkRenderer : this.chunkRenderers) {
                if (!chunkRenderer.skyLit || chunkRenderer.dirty) continue;
                this.dirtyChunks.add(chunkRenderer);
                chunkRenderer.setDirty();
            }
        }
    }

    @Override
    public void tileEntityChanged(int x, int y, int z, TileEntity tileEntity) {
    }

    public void deleteChunkLists() {
        if (this.chunkLists >= 0) {
            GLAllocation.deleteDisplayList(this.chunkLists);
        }
    }

    @Override
    public void levelEvent(@Nullable Player player, int id, int x, int y, int z, int data) {
        Random random = this.world.rand;
        switch (id) {
            default: {
                break;
            }
            case 1001: {
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, x, y, z, "tile.dispenser.click", 1.0f, 1.0f);
                break;
            }
            case 1000: {
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, x, y, z, "tile.dispenser.eject", 1.0f, 1.0f);
                break;
            }
            case 1002: {
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, x, y, z, "tile.dispenser.fire", 1.0f, 1.2f);
                break;
            }
            case 2000: {
                Direction direction = Direction.getDirectionById(data);
                int xOff = direction.getOffsetX();
                int yOff = direction.getOffsetY();
                int zOff = direction.getOffsetZ();
                double px = (double)x + (double)xOff * 0.6 + 0.5;
                double py = (double)y + (double)yOff * 0.6 + 0.5;
                double pz = (double)z + (double)zOff * 0.6 + 0.5;
                for (int i = 0; i < 10; ++i) {
                    double rO = random.nextDouble() * 0.2 + 0.01;
                    double fx = px + (double)xOff * 0.01 + (random.nextDouble() - 0.5) * (double)zOff * 0.5;
                    double fy = py + (double)yOff * 0.01 + (random.nextDouble() - 0.5) * (double)yOff * 0.5;
                    double fz = pz + (double)zOff * 0.01 + (random.nextDouble() - 0.5) * (double)xOff * 0.5;
                    double mx = (double)xOff * rO + random.nextGaussian() * 0.01;
                    double my = (double)yOff * rO + random.nextGaussian() * 0.01;
                    double mz = (double)zOff * rO + random.nextGaussian() * 0.01;
                    this.addParticle("smoke", fx, fy, fz, mx, my, mz, 0);
                }
                break;
            }
            case 2001: {
                if (data > 0) {
                    Block<?> block = Blocks.blocksList[data];
                    this.world.playBlockSoundEffect(null, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, block, EnumBlockSoundEffectType.MINE);
                }
                this.mc.particleEngine.destroy(x, y, z, data, this.world.getBlockMetadata(x, y, z));
                break;
            }
            case 1003: {
                if (Math.random() < 0.5) {
                    this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.door_open", 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f);
                    break;
                }
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.door_close", 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1004: {
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "random.fizz", 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
                break;
            }
            case 1005: {
                if (Item.itemsList[data] instanceof ItemDiscMusic) {
                    ItemDiscMusic record = (ItemDiscMusic)Item.itemsList[data];
                    this.world.playRecord(record.recordName, record.recordAuthor, x, y, z);
                    break;
                }
                this.world.playRecord(null, null, x, y, z);
                break;
            }
            case 1006: {
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, this.world.rand.nextFloat() * 0.25f + 0.6f);
                break;
            }
            case 1007: {
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, this.world.rand.nextFloat() * 0.25f + 0.6f);
            }
        }
    }

    @Override
    public void entityAdded(Entity entity) {
    }

    @Override
    public void entityRemoved(Entity entity) {
    }

    static {
        for (int i = 0; i < breakingAnimation.length; ++i) {
            RenderGlobal.breakingAnimation[i] = TextureRegistry.getTexture("minecraft:block/breaking/" + i);
        }
    }
}

