/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicJarButterfly;
import net.minecraft.core.block.BlockLogicLanternFirefly;
import net.minecraft.core.block.BlockLogicRope;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockModelRope<T extends BlockLogicRope>
extends BlockModelStandard<T> {
    public BlockModelRope(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        WorldSource world = worldSource;
        Block<?> below = world.getBlock(x, y - 1, z);
        boolean hasFloor = below != null && below.canPlaceOnSurface();
        boolean hasBlockNegX = this.canConnect(world, x, y, z, Side.WEST);
        boolean hasBlockPosX = this.canConnect(world, x, y, z, Side.EAST);
        boolean hasBlockNegY = this.canConnect(world, x, y, z, Side.BOTTOM) || hasFloor;
        boolean hasBlockPosY = this.canConnect(world, x, y, z, Side.TOP);
        boolean hasBlockNegZ = this.canConnect(world, x, y, z, Side.NORTH);
        boolean hasBlockPosZ = this.canConnect(world, x, y, z, Side.SOUTH);
        boolean drawKnot = !(hasBlockNegX && hasBlockPosX && !hasBlockNegY && !hasBlockPosY && !hasBlockNegZ && !hasBlockPosZ || !hasBlockNegX && !hasBlockPosX && hasBlockNegY && hasBlockPosY && !hasBlockNegZ && !hasBlockPosZ || !hasBlockNegX && !hasBlockPosX && !hasBlockNegY && !hasBlockPosY && hasBlockNegZ && hasBlockPosZ);
        AABB bounds = AABB.fromPool(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        float ropeThickness = 0.0625f;
        float knotThickness = 0.125f;
        float pileWidth = 0.1875f;
        if (drawKnot) {
            bounds.set(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        if (hasBlockPosY) {
            bounds.set(0.4375, 0.5, 0.4375, 0.5625, 1.0, 0.5625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        if (hasBlockNegY) {
            bounds.set(0.4375, 0.0, 0.4375, 0.5625, 0.5, 0.5625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        if (hasBlockPosX) {
            bounds.set(0.5, 0.4375, 0.4375, 1.0, 0.5625, 0.5625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        if (hasBlockNegX) {
            bounds.set(0.0, 0.4375, 0.4375, 0.5, 0.5625, 0.5625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        if (hasBlockPosZ) {
            bounds.set(0.4375, 0.4375, 0.5, 0.5625, 0.5625, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        if (hasBlockNegZ) {
            bounds.set(0.4375, 0.4375, 0.0, 0.5625, 0.5625, 0.5);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        if (hasFloor) {
            bounds.set(0.3125, 0.0, 0.3125, 0.6875, 0.125, 0.6875);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.375, 0.0, 0.375, 0.625, 0.1875, 0.625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        return true;
    }

    private boolean canConnect(WorldSource worldSource, int x, int y, int z, Side side) {
        int blockX = x + side.getOffsetX();
        int blockY = y + side.getOffsetY();
        int blockZ = z + side.getOffsetZ();
        Block<?> _block = worldSource.getBlock(blockX, blockY, blockZ);
        if (side == Side.BOTTOM) {
            if (Block.hasLogicClass(_block, BlockLogicLanternFirefly.class) && (worldSource.getBlockMetadata(blockX, blockY, blockZ) & 1) != 0) {
                return true;
            }
            if (Block.hasLogicClass(_block, BlockLogicJarButterfly.class) && (worldSource.getBlockMetadata(blockX, blockY, blockZ) & 1) != 0) {
                return true;
            }
        } else if (side == Side.TOP && (worldSource.isBlockOpaqueCube(blockX, blockY, blockZ) || BlockTags.CAN_HANG_OFF.appliesTo(_block))) {
            return true;
        }
        if ((worldSource.getBlockMetadata(x, y, z) & 0x80) != 0 && worldSource.isBlockOpaqueCube(blockX, blockY, blockZ)) {
            return true;
        }
        return _block == this.block;
    }
}

